/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.jssrc.dsl.AutoValue_StatementList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.stream.Stream;

@AutoValue
public abstract class StatementList
extends Statement {
    private static final StatementList EMPTY = new AutoValue_StatementList((ImmutableList<? extends Statement>)ImmutableList.of());

    abstract ImmutableList<? extends Statement> statements();

    public static StatementList create(Iterable<? extends Statement> statements) {
        if (Iterables.isEmpty(statements)) {
            return EMPTY;
        }
        ImmutableList.Builder unrolled = ImmutableList.builder();
        for (Statement statement : statements) {
            if (statement instanceof StatementList) {
                unrolled.addAll(((StatementList)statement).statements());
                continue;
            }
            unrolled.add((Object)statement);
        }
        return new AutoValue_StatementList((ImmutableList<? extends Statement>)unrolled.build());
    }

    public boolean isEmpty() {
        return this.statements().isEmpty();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.statements().stream();
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        for (Statement statement : this.statements()) {
            ctx.appendAll(statement);
        }
    }

    @Override
    public boolean isTerminal() {
        return this.statements().stream().anyMatch(Statement::isTerminal);
    }
}

