/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.template.soy.jssrc.dsl.Assignment;
import com.google.template.soy.jssrc.dsl.AutoValue_Statements_DecoratedStatement;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Debugger;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.ExpressionStatement;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.For;
import com.google.template.soy.jssrc.dsl.ForOf;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.SpecialToken;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.StatementList;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.Throw;
import java.util.List;
import java.util.stream.Stream;

public final class Statements {
    public static final Statement ERROR_STMT = ExpressionStatement.of(Expressions.ERROR_EXPR);
    public static final Statement EMPTY = Statements.of((Iterable<Statement>)ImmutableList.of());

    private Statements() {
    }

    public static Statement of(Statement first, Statement ... rest) {
        return Statements.of((Iterable<Statement>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    public static Statement of(Iterable<Statement> stmts) {
        ImmutableList copy = ImmutableList.copyOf(stmts);
        return copy.size() == 1 ? (Statement)copy.get(0) : StatementList.create((Iterable<? extends Statement>)copy);
    }

    public static ConditionalBuilder ifStatement(Expression predicate, Statement consequent) {
        return new ConditionalBuilder(predicate, consequent);
    }

    public static Statement assign(Expression lhs, Expression rhs) {
        return Assignment.create(lhs, rhs, null);
    }

    public static Statement assign(Expression lhs, Expression rhs, JsDoc jsDoc) {
        return Assignment.create(lhs, rhs, jsDoc);
    }

    public static SwitchBuilder switchValue(Expression switchOn) {
        return new SwitchBuilder(switchOn);
    }

    public static Statement forLoop(String localVar, Expression initial, Expression limit, Expression increment, Statement body) {
        return For.create(localVar, initial, limit, increment, body);
    }

    public static Statement forLoop(String localVar, Expression limit, Statement body) {
        return For.create(localVar, Expressions.number(0L), limit, Expressions.number(1L), body);
    }

    public static Statement forOf(String localVar, Expression collection, Statement body) {
        return ForOf.create(localVar, collection, body);
    }

    public static Statement returnValue(Expression returnValue) {
        return Return.create(returnValue);
    }

    public static Statement returnNothing() {
        return Return.create();
    }

    public static Statement throwValue(Expression throwValue) {
        return Throw.create(throwValue);
    }

    public static Statement debugger() {
        return Debugger.INSTANCE;
    }

    @AutoValue
    static abstract class DecoratedStatement
    extends Statement {
        DecoratedStatement() {
        }

        public static Statement create(Statement statement, List<SpecialToken> before, List<SpecialToken> after) {
            if (before.isEmpty() && after.isEmpty()) {
                return statement;
            }
            return new AutoValue_Statements_DecoratedStatement((ImmutableList<SpecialToken>)ImmutableList.copyOf(before), statement, (ImmutableList<SpecialToken>)ImmutableList.copyOf(after));
        }

        abstract ImmutableList<SpecialToken> beforeTokens();

        abstract Statement statement();

        abstract ImmutableList<SpecialToken> afterTokens();

        @Override
        public Expression asExpr() {
            Expression expr = this.statement().asExpr();
            return Expressions.DecoratedExpression.create(expr, this.beforeTokens(), this.afterTokens());
        }

        @Override
        void doFormatStatement(FormattingContext ctx) {
            for (CodeChunk chunk : this.beforeTokens()) {
                ctx.appendAll(chunk);
            }
            ctx.appendAll(this.statement());
            for (CodeChunk chunk : this.afterTokens()) {
                ctx.appendAll(chunk);
            }
        }

        @Override
        public boolean isTerminal() {
            return this.statement().isTerminal();
        }

        @Override
        Stream<? extends CodeChunk> childrenStream() {
            return Streams.concat((Stream[])new Stream[]{this.beforeTokens().stream(), Stream.of(this.statement()), this.afterTokens().stream()});
        }

        @Override
        public Statement append(List<SpecialToken> tokens) {
            if (tokens.isEmpty()) {
                return this;
            }
            return DecoratedStatement.create(this.statement(), this.beforeTokens(), (List<SpecialToken>)ImmutableList.builder().addAll(tokens).addAll(this.afterTokens()).build());
        }

        @Override
        public Statement prepend(List<SpecialToken> tokens) {
            if (tokens.isEmpty()) {
                return this;
            }
            return DecoratedStatement.create(this.statement(), (List<SpecialToken>)ImmutableList.builder().addAll(tokens).addAll(this.beforeTokens()).build(), this.afterTokens());
        }
    }
}

