/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.jssrc.dsl.AutoValue_StringLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import java.util.Optional;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class StringLiteral
extends Expression {
    static Expression create(String literalValue) {
        return new AutoValue_StringLiteral(literalValue, QuoteStyle.SINGLE);
    }

    static Expression create(String literalValue, QuoteStyle quoteStyle) {
        return new AutoValue_StringLiteral(literalValue, quoteStyle);
    }

    public abstract String literalValue();

    abstract QuoteStyle quoteStyle();

    @Override
    public boolean isDefinitelyNotNull() {
        return true;
    }

    @Override
    public boolean isCheap() {
        return true;
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.empty();
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.appendQuotedString(this.literalValue(), this.quoteStyle());
    }

    @Override
    public Optional<String> asStringLiteral() {
        return Optional.of(this.literalValue());
    }
}

