/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Switch;
import javax.annotation.Nullable;

public final class SwitchBuilder {
    private final Expression switchOn;
    private final ImmutableList.Builder<Switch.CaseClause> clauses = ImmutableList.builder();
    @Nullable
    private Statement defaultCaseBody;

    SwitchBuilder(Expression switchOn) {
        this.switchOn = switchOn;
    }

    @CanIgnoreReturnValue
    public SwitchBuilder addCase(ImmutableList<Expression> caseLabels, Statement body) {
        Preconditions.checkState((!caseLabels.isEmpty() ? 1 : 0) != 0, (Object)"at least one case required");
        this.clauses.add((Object)new Switch.CaseClause(caseLabels, body));
        return this;
    }

    @CanIgnoreReturnValue
    public SwitchBuilder addCase(Expression caseLabel, Statement body) {
        this.clauses.add((Object)new Switch.CaseClause((ImmutableList<Expression>)ImmutableList.of((Object)caseLabel), body));
        return this;
    }

    @CanIgnoreReturnValue
    public SwitchBuilder setDefault(Statement body) {
        Preconditions.checkState((this.defaultCaseBody == null ? 1 : 0) != 0);
        this.defaultCaseBody = body;
        return this;
    }

    public Statement build() {
        return Switch.create(this.switchOn, (ImmutableList<Switch.CaseClause>)this.clauses.build(), this.defaultCaseBody);
    }
}

