/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_TemplateLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Concatenation;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import com.google.template.soy.jssrc.dsl.TsxFragmentElement;
import com.google.template.soy.jssrc.dsl.TsxPrintNode;
import java.util.List;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class TemplateLiteral
extends Expression {
    public static TemplateLiteral create(List<? extends CodeChunk> body) {
        return new AutoValue_TemplateLiteral((ImmutableList<? extends CodeChunk>)((ImmutableList)TsxFragmentElement.mergeLineComments(body.stream()).map(TemplateLiteral::wrapChild).collect(ImmutableList.toImmutableList())));
    }

    private static Expression wrapChild(CodeChunk chunk) {
        if (chunk instanceof TsxPrintNode || chunk instanceof StringLiteral || chunk instanceof TsxPrintNode.CommandChar) {
            return (Expression)chunk;
        }
        if (chunk instanceof Concatenation) {
            return ((Concatenation)chunk).map1to1(TemplateLiteral::wrapChild);
        }
        if (chunk instanceof Statement) {
            return TsxPrintNode.wrap(((Statement)chunk).asExpr());
        }
        return TsxPrintNode.wrap(chunk);
    }

    abstract ImmutableList<? extends CodeChunk> body();

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.body().stream();
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('`');
        ctx.pushLexicalState(FormattingContext.LexicalState.TTL);
        for (CodeChunk s : this.body()) {
            ctx.appendAll(s);
        }
        ctx.append('`');
        ctx.popLexicalState();
    }
}

