/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Ternary;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Precedence;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class Ternary
extends Operation {
    Ternary() {
    }

    abstract Expression predicate();

    abstract Expression consequent();

    abstract Expression alternate();

    static Ternary create(Expression predicate, Expression consequent, Expression alternate) {
        Preconditions.checkArgument((boolean)predicate.hasEquivalentInitialStatements(consequent));
        Preconditions.checkArgument((boolean)predicate.hasEquivalentInitialStatements(alternate));
        return new AutoValue_Ternary(predicate, consequent, alternate);
    }

    @Override
    public Precedence precedence() {
        return Precedence.forSoyOperator(Operator.CONDITIONAL);
    }

    @Override
    public Precedence.Associativity associativity() {
        return Precedence.getAssociativity(Operator.CONDITIONAL);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.predicate(), this.consequent(), this.alternate());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.predicate(), OperandPosition.LEFT, ctx);
        ctx.append(" ? ");
        this.formatOperand(this.consequent(), OperandPosition.LEFT, ctx);
        ctx.append(" : ");
        this.formatOperand(this.alternate(), OperandPosition.RIGHT, ctx);
    }

    @Override
    boolean initialExpressionIsObjectLiteral() {
        return this.predicate().initialExpressionIsObjectLiteral();
    }
}

