/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_TsxElement;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.HtmlTag;
import com.google.template.soy.jssrc.dsl.TsxFragmentElement;
import java.util.List;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class TsxElement
extends Expression {
    public abstract HtmlTag openTag();

    public abstract HtmlTag closeTag();

    public abstract ImmutableList<? extends CodeChunk> body();

    public static TsxElement create(HtmlTag openTag, HtmlTag closeTag, List<? extends CodeChunk> body) {
        Preconditions.checkState((boolean)openTag.tagName().equals(closeTag.tagName()));
        Preconditions.checkState((boolean)openTag.isOpen());
        Preconditions.checkState((boolean)closeTag.isClose());
        return new AutoValue_TsxElement(openTag, closeTag, (ImmutableList<? extends CodeChunk>)((ImmutableList)TsxFragmentElement.mergeLineComments(body.stream()).flatMap(TsxFragmentElement::wrapChild).collect(ImmutableList.toImmutableList())));
    }

    public TsxElement copyWithTagName(String newTagName) {
        return TsxElement.create(this.openTag().copyWithTagName(newTagName), this.closeTag().copyWithTagName(newTagName), this.body());
    }

    public TsxElement copyWithMoreBody(CodeChunk ... bodyToAppend) {
        return TsxElement.create(this.openTag(), this.closeTag(), (List<? extends CodeChunk>)ImmutableList.builder().addAll(this.body()).add((Object[])bodyToAppend).build());
    }

    @Override
    public boolean isCheap() {
        return true;
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.concat(Stream.of(this.openTag(), this.closeTag()), this.body().stream());
    }

    private boolean isComponentCall() {
        Expression tagName = this.openTag().tagName();
        String leafText = Expressions.getLeafText(tagName);
        return leafText != null && Ascii.isUpperCase((char)leafText.charAt(0));
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (this.isComponentCall() && this.body().isEmpty()) {
            try (FormattingContext buffer = ctx.buffer();){
                this.doFormatOutputExprHelper(buffer);
            }
        } else {
            this.doFormatOutputExprHelper(ctx);
        }
    }

    void doFormatOutputExprHelper(FormattingContext ctx) {
        ctx.pushLexicalState(FormattingContext.LexicalState.TSX);
        ctx.appendAll(this.openTag());
        for (CodeChunk s : this.body()) {
            ctx.appendAll(s);
        }
        ctx.appendAll(this.closeTag());
        ctx.popLexicalState();
    }
}

