/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.internal.util.TreeStreams;
import com.google.template.soy.jssrc.dsl.AutoValue_TsxFragmentElement;
import com.google.template.soy.jssrc.dsl.Call;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Concatenation;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.HtmlTag;
import com.google.template.soy.jssrc.dsl.LineComment;
import com.google.template.soy.jssrc.dsl.RangeComment;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import com.google.template.soy.jssrc.dsl.TsxElement;
import com.google.template.soy.jssrc.dsl.TsxPrintNode;
import com.google.template.soy.jssrc.dsl.VariableReference;
import com.google.template.soy.jssrc.dsl.Whitespace;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class TsxFragmentElement
extends Expression
implements CodeChunk.HasRequires {
    public static final GoogRequire ELEMENT = GoogRequire.create("__element__");
    public static final GoogRequire FRAGMENT = GoogRequire.create("__fragment__");

    public static Expression maybeWrap(CodeChunk body) {
        if (body instanceof TsxFragmentElement || body instanceof TsxElement) {
            return (Expression)body;
        }
        return TsxFragmentElement.create((List<? extends CodeChunk>)ImmutableList.of((Object)body));
    }

    public static Expression maybeWrap(List<? extends CodeChunk> children) {
        if (children.size() == 1) {
            CodeChunk onlyChild = children.get(0);
            if (onlyChild instanceof Call || onlyChild instanceof VariableReference) {
                return (Expression)onlyChild;
            }
            return TsxFragmentElement.maybeWrap(onlyChild);
        }
        return TsxFragmentElement.create(children);
    }

    public static Expression create(List<? extends CodeChunk> body) {
        return new AutoValue_TsxFragmentElement((ImmutableList<? extends CodeChunk>)((ImmutableList)TsxFragmentElement.mergeLineComments(body.stream()).flatMap(TsxFragmentElement::wrapChild).collect(ImmutableList.toImmutableList())));
    }

    static Stream<CodeChunk> mergeLineComments(Stream<? extends CodeChunk> s) {
        return TreeStreams.collateAndMerge(s, (prev, next) -> prev instanceof LineComment && next instanceof LineComment, comments -> RangeComment.create("\n" + comments.stream().map(LineComment.class::cast).map(LineComment::content).collect(Collectors.joining("\n")) + "\n", true));
    }

    static Stream<CodeChunk> wrapChild(CodeChunk chunk) {
        if (chunk instanceof TsxElement || chunk instanceof TsxPrintNode || chunk instanceof HtmlTag || chunk instanceof TsxPrintNode.CommandChar) {
            return Stream.of(chunk);
        }
        if (chunk == Expressions.EMPTY) {
            return Stream.of(new CodeChunk[0]);
        }
        if (chunk instanceof StringLiteral) {
            return Stream.of(TsxPrintNode.wrapIfNeeded((StringLiteral)chunk));
        }
        if (chunk instanceof Concatenation) {
            return Stream.of(((Concatenation)chunk).map1toN(TsxFragmentElement::wrapChild));
        }
        if (chunk instanceof Statements.DecoratedStatement || chunk instanceof Expressions.DecoratedExpression) {
            return TsxFragmentElement.mergeLineComments(chunk.childrenStream()).flatMap(TsxFragmentElement::wrapChild);
        }
        if (chunk instanceof Statement) {
            return Stream.of(TsxPrintNode.wrap(((Statement)chunk).asExpr()));
        }
        if (chunk instanceof Whitespace) {
            return Stream.of(chunk);
        }
        return Stream.of(TsxPrintNode.wrap(chunk));
    }

    @Override
    public ImmutableSet<GoogRequire> googRequires() {
        return ImmutableSet.of((Object)ELEMENT, (Object)FRAGMENT);
    }

    abstract ImmutableList<? extends CodeChunk> body();

    @Override
    public boolean isCheap() {
        return true;
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.body().stream();
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.pushLexicalState(FormattingContext.LexicalState.TSX);
        if (this.body().isEmpty()) {
            try (FormattingContext buffer = ctx.buffer();){
                buffer.appendAll(HtmlTag.FRAGMENT_OPEN);
                buffer.appendAll(HtmlTag.FRAGMENT_CLOSE);
            }
        } else {
            ctx.appendAll(HtmlTag.FRAGMENT_OPEN);
            ctx.endLine();
            for (CodeChunk s : this.body()) {
                ctx.appendAll(s);
            }
            ctx.endLine();
            ctx.appendAll(HtmlTag.FRAGMENT_CLOSE);
        }
        ctx.popLexicalState();
    }
}

