/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.BaseUtils;

public final class JsSrcUtils {
    static final ImmutableSet<String> JS_LITERALS = ImmutableSet.of((Object)"null", (Object)"true", (Object)"false", (Object)"NaN", (Object)"Infinity", (Object)"undefined", (Object[])new String[0]);
    static final ImmutableSet<String> JS_RESERVED_WORDS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"catch", (Object)"class", (Object)"const", (Object)"continue", (Object[])new String[]{"debugger", "default", "delete", "do", "else", "enum", "export", "extends", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "try", "typeof", "unknown", "var", "void", "while", "with", "yield", "async", "await"});
    static final ImmutableSet<String> OBJECT_PROPS = ImmutableSet.of((Object)"constructor", (Object)"__proto__", (Object)"__defineGetter__", (Object)"__defineSetter__", (Object)"__lookupGetter__", (Object)"__lookupSetter__", (Object[])new String[]{"hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"});
    public static final ImmutableSet<String> LEGACY_JS_RESERVED_WORDS = ImmutableSet.builder().addAll(JS_LITERALS).addAll(JS_RESERVED_WORDS).add((Object)"proto").add((Object)"soy").add((Object)"soydata").build();

    private JsSrcUtils() {
    }

    static String escapeUnicodeFormatChars(String str) {
        int codePoint;
        int len = str.length();
        boolean hasFormatChar = false;
        for (int i = 0; i < len; ++i) {
            if (Character.getType(str.charAt(i)) != 16) continue;
            hasFormatChar = true;
            break;
        }
        if (!hasFormatChar) {
            return str;
        }
        StringBuilder out = new StringBuilder(len * 4 / 3);
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(i);
            if (Character.getType(codePoint) == 16) {
                BaseUtils.appendHexEscape(out, codePoint);
                continue;
            }
            out.appendCodePoint(codePoint);
        }
        return out.toString();
    }

    public static boolean isReservedWord(String key) {
        return LEGACY_JS_RESERVED_WORDS.contains((Object)key);
    }

    public static boolean isPropertyOfObject(String identifier) {
        return OBJECT_PROPS.contains((Object)identifier);
    }
}

