/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Call;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Id;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_ProtoCall;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

final class NullSafeAccumulator {
    private final Expression base;
    private final List<ChainAccess> chain;

    NullSafeAccumulator(Expression base) {
        this.base = base;
        this.chain = new ArrayList<ChainAccess>();
    }

    @CanIgnoreReturnValue
    NullSafeAccumulator dotAccess(FieldAccess access, boolean nullSafe) {
        this.chain.add(access.toChainAccess(nullSafe));
        return this;
    }

    @CanIgnoreReturnValue
    NullSafeAccumulator mapGetAccess(Expression mapKeyCode, boolean nullSafe) {
        this.chain.add(FieldAccess.call("get", (ImmutableList<Expression>)ImmutableList.of((Object)mapKeyCode)).toChainAccess(nullSafe));
        return this;
    }

    @CanIgnoreReturnValue
    NullSafeAccumulator bracketAccess(Expression arg, boolean nullSafe) {
        this.chain.add(new Bracket(arg, nullSafe));
        return this;
    }

    @CanIgnoreReturnValue
    NullSafeAccumulator transform(boolean nullSafe, Function<Expression, Expression> extender) {
        this.chain.add(new Transform(nullSafe, extender));
        return this;
    }

    @CanIgnoreReturnValue
    NullSafeAccumulator functionCall(boolean nullSafe, JavaScriptValueFactoryImpl.SoyJavaScriptSourceFunctionInvocation invocation) {
        this.chain.add(new FunctionCall(nullSafe, invocation));
        return this;
    }

    Expression result(CodeChunk.Generator codeGenerator) {
        return this.buildAccessChain(codeGenerator);
    }

    private Expression buildAccessChain(CodeChunk.Generator codeGenerator) {
        return NullSafeAccumulator.buildAccessChain(this.base, codeGenerator, this.chain.iterator(), new ArrayDeque<ChainAccess>(), false);
    }

    private static Expression buildAccessChain(Expression base, CodeChunk.Generator generator, Iterator<ChainAccess> chain, Deque<ChainAccess> unpackBuffer, boolean hasNullSafeSinceWrap) {
        Expression result;
        boolean needsWrap;
        if (!chain.hasNext()) {
            return NullSafeAccumulator.flushUnpackBuffer(base, unpackBuffer);
        }
        ChainAccess link = chain.next();
        hasNullSafeSinceWrap = hasNullSafeSinceWrap || link.nullSafe;
        boolean bl = needsWrap = hasNullSafeSinceWrap && !link.supportsNativeNullSafe(base);
        if (needsWrap && !base.isCheap()) {
            base = generator.declarationBuilder().setRhs(base).build().ref();
        }
        Expression newBase = base;
        if (link.getUnpacking() == Unpacking.STOP) {
            newBase = NullSafeAccumulator.flushUnpackBuffer(newBase, unpackBuffer);
        }
        newBase = link.extend(newBase);
        unpackBuffer.addFirst(link);
        if (needsWrap) {
            hasNullSafeSinceWrap = false;
            result = Expressions.ifExpression(base.doubleEqualsNull(), Expressions.LITERAL_UNDEFINED).setElse(NullSafeAccumulator.buildAccessChain(newBase, generator, chain, unpackBuffer, hasNullSafeSinceWrap)).build(generator);
        } else {
            result = NullSafeAccumulator.buildAccessChain(newBase, generator, chain, unpackBuffer, hasNullSafeSinceWrap);
        }
        return result;
    }

    private static Expression flushUnpackBuffer(Expression base, Deque<ChainAccess> unpackBuffer) {
        boolean tail = true;
        for (ChainAccess link : unpackBuffer) {
            Unpacking unpacking = link.getUnpacking();
            if (unpacking == Unpacking.UNPACK) {
                base = link.unpack(base, tail);
                break;
            }
            tail = false;
        }
        unpackBuffer.clear();
        return base;
    }

    static enum AccessType {
        SINGULAR{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return unpackFunction.call(accessChain);
            }
        }
        ,
        REPEATED{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return JsRuntime.SOY_NEWMAPS_NULL_SAFE_ARRAY_MAP.call(accessChain, unpackFunction);
            }
        }
        ,
        MAP{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return JsRuntime.SOY_NEWMAPS_NULL_SAFE_TRANSFORM_VALUES.call(accessChain, unpackFunction);
            }
        };


        abstract Expression unpackResult(Expression var1, Expression var2);

        private static AccessType get(Descriptors.FieldDescriptor desc) {
            if (desc.isMapField()) {
                return MAP;
            }
            if (desc.isRepeated()) {
                return REPEATED;
            }
            return SINGULAR;
        }
    }

    @AutoValue
    static abstract class ProtoCall
    extends FieldAccess {
        ProtoCall() {
        }

        abstract String getter();

        @Nullable
        abstract Expression getterArg();

        @Nullable
        abstract AccessType accessType();

        @Nullable
        abstract Expression unpackFunction();

        static ProtoCall getField(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.accessor(fieldName, desc, Type.GET);
        }

        static ProtoCall getFieldOrUndefined(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.accessor(fieldName, desc, Type.GET_OR_UNDEFINED);
        }

        static ProtoCall getReadonlyField(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.accessor(fieldName, desc, Type.GET_READONLY);
        }

        static ProtoCall hasField(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.accessor(fieldName, desc, Type.HAS);
        }

        private static ProtoCall accessor(String fieldName, Descriptors.FieldDescriptor desc, Type type) {
            Expression arg;
            String getter;
            Expression unpackFunction = null;
            if (type == Type.GET || type == Type.GET_OR_UNDEFINED || type == Type.GET_READONLY) {
                unpackFunction = ProtoCall.getUnpackFunction(desc);
            }
            if (desc.isExtension()) {
                getter = type.getPrefix() + "Extension" + type.getSuffix();
                arg = JsRuntime.extensionField(desc);
            } else {
                getter = type.getPrefix() + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName) + ProtoUtils.getJsFieldSpecificSuffix(desc) + type.getSuffix();
                arg = null;
            }
            return new AutoValue_NullSafeAccumulator_ProtoCall(getter, arg, unpackFunction == null ? null : AccessType.get(desc), unpackFunction);
        }

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new ProtoDotCall(nullSafe, this);
        }

        @Nullable
        private static Expression getUnpackFunction(Descriptors.FieldDescriptor desc) {
            if (ProtoUtils.isSanitizedContentField(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(desc.getMessageType());
            }
            if (ProtoUtils.isSanitizedContentMap(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(ProtoUtils.getMapValueMessageType(desc));
            }
            if (desc.getType() == Descriptors.FieldDescriptor.Type.BYTES || desc.isMapField() && ProtoUtils.getMapValueFieldDescriptor(desc).getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                return JsRuntime.protoByteStringToBase64ConverterFunction();
            }
            return null;
        }

        private static enum Type {
            GET("get", ""),
            GET_OR_UNDEFINED("get", "OrUndefined"),
            GET_READONLY("getReadonly", ""),
            HAS("has", "");

            private final String prefix;
            private final String suffix;

            private Type(String prefix, String suffix) {
                this.prefix = prefix;
                this.suffix = suffix;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }
        }
    }

    @AutoValue
    static abstract class Call
    extends FieldAccess {
        Call() {
        }

        abstract String getter();

        @Nullable
        abstract ImmutableList<Expression> args();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new DotCall(this.getter(), this.args(), nullSafe);
        }
    }

    @AutoValue
    static abstract class Id
    extends FieldAccess {
        Id() {
        }

        abstract String fieldName();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new Dot(this.fieldName(), nullSafe);
        }
    }

    static abstract class FieldAccess {
        FieldAccess() {
        }

        @ForOverride
        abstract ChainAccess toChainAccess(boolean var1);

        static FieldAccess id(String fieldName) {
            return new AutoValue_NullSafeAccumulator_Id(fieldName);
        }

        static FieldAccess call(String getter, ImmutableList<Expression> args) {
            return new AutoValue_NullSafeAccumulator_Call(getter, args);
        }

        static FieldAccess protoCall(String fieldName, Descriptors.FieldDescriptor desc) {
            if (desc.hasPresence() && desc.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                return ProtoCall.getFieldOrUndefined(fieldName, desc);
            }
            return ProtoCall.getField(fieldName, desc);
        }
    }

    private static final class ProtoDotCall
    extends ChainAccess {
        private final ProtoCall protoCall;

        ProtoDotCall(boolean nullSafe, ProtoCall protoCall) {
            super(nullSafe);
            this.protoCall = protoCall;
        }

        @Override
        Expression extend(Expression prevTip) {
            Expression arg = this.protoCall.getterArg();
            String getter = this.protoCall.getter();
            return arg == null ? prevTip.dotAccess(getter, this.nullSafe).call(new Expression[0]) : prevTip.dotAccess(getter, this.nullSafe).call(arg);
        }

        @Override
        Expression unpack(Expression base, boolean tail) {
            AccessType accessType = tail ? this.protoCall.accessType() : AccessType.SINGULAR;
            return accessType.unpackResult(base, this.protoCall.unpackFunction());
        }

        @Override
        Unpacking getUnpacking() {
            return this.protoCall.unpackFunction() != null ? Unpacking.UNPACK : Unpacking.PASS;
        }
    }

    private static class DotCall
    extends ChainAccess {
        final String getter;
        final ImmutableList<Expression> args;

        DotCall(String getter, ImmutableList<Expression> args, boolean nullSafe) {
            super(nullSafe);
            this.getter = getter;
            this.args = args;
        }

        @Override
        final Expression extend(Expression prevTip) {
            return prevTip.dotAccess(this.getter, this.nullSafe).call((Iterable<? extends Expression>)this.args);
        }
    }

    private static final class Dot
    extends ChainAccess {
        final String id;

        Dot(String id, boolean nullSafe) {
            super(nullSafe);
            this.id = id;
        }

        @Override
        Expression extend(Expression prevTip) {
            return prevTip.dotAccess(this.id, this.nullSafe);
        }
    }

    private static final class Bracket
    extends ChainAccess {
        final Expression value;

        Bracket(Expression value, boolean nullSafe) {
            super(nullSafe);
            this.value = value;
        }

        @Override
        Expression extend(Expression prevTip) {
            return prevTip.bracketAccess(this.value, this.nullSafe);
        }

        @Override
        boolean supportsNativeNullSafe(Expression base) {
            return base.hasEquivalentInitialStatements(this.value);
        }
    }

    private static final class FunctionCall
    extends ChainAccess {
        private static final Map<SoyJavaScriptSourceFunction, Boolean> hasNativeNullSafeCache = new HashMap<SoyJavaScriptSourceFunction, Boolean>();
        private final JavaScriptValueFactoryImpl.SoyJavaScriptSourceFunctionInvocation funct;

        public FunctionCall(boolean nullSafe, JavaScriptValueFactoryImpl.SoyJavaScriptSourceFunctionInvocation funct) {
            super(nullSafe);
            this.funct = funct;
        }

        @Override
        Expression extend(Expression prevTip) {
            return this.funct.invoke(Expressions.nullSafeAccumulatorReceiver(prevTip, this.nullSafe));
        }

        @Override
        boolean supportsNativeNullSafe(Expression base) {
            if (!hasNativeNullSafeCache.computeIfAbsent(this.funct.impl(), key -> {
                Expressions.NullSafeAccumulatorReceiver trojan = Expressions.nullSafeAccumulatorReceiver(Expressions.LITERAL_NULL, this.nullSafe);
                Expression unused = this.funct.invoke(trojan);
                return trojan.wasDereferenced();
            }).booleanValue()) {
                return false;
            }
            for (Expression arg : this.funct.args()) {
                if (base.hasEquivalentInitialStatements(arg)) continue;
                return false;
            }
            return true;
        }

        @Override
        Unpacking getUnpacking() {
            return Unpacking.STOP;
        }
    }

    private static final class Transform
    extends ChainAccess {
        private final Function<Expression, Expression> transformer;

        public Transform(boolean nullSafe, Function<Expression, Expression> transformer) {
            super(nullSafe);
            this.transformer = transformer;
        }

        @Override
        Expression extend(Expression prevTip) {
            return this.transformer.apply(prevTip);
        }

        @Override
        boolean supportsNativeNullSafe(Expression base) {
            return false;
        }

        @Override
        Unpacking getUnpacking() {
            return Unpacking.STOP;
        }
    }

    private static abstract class ChainAccess {
        final boolean nullSafe;

        abstract Expression extend(Expression var1);

        boolean supportsNativeNullSafe(Expression base) {
            return true;
        }

        ChainAccess(boolean nullSafe) {
            this.nullSafe = nullSafe;
        }

        Expression unpack(Expression base, boolean tail) {
            throw new UnsupportedOperationException();
        }

        Unpacking getUnpacking() {
            return Unpacking.PASS;
        }
    }

    private static enum Unpacking {
        UNPACK,
        PASS,
        STOP;

    }
}

