/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public final class OutputVarHandler {
    private final Deque<OutputVar> outputVars = new ArrayDeque<OutputVar>();

    private OutputVar currentOutputVar() {
        return this.outputVars.peek();
    }

    public Optional<Statement> initOutputVarIfNecessary() {
        if (!this.outputVars.isEmpty() && this.currentOutputVar().initialized) {
            return Optional.empty();
        }
        return Optional.of(this.initOutputVar(this.currentOutputVar().name.assertExpr().getText(), Expressions.LITERAL_EMPTY_STRING));
    }

    private VariableDeclaration initOutputVar(String name, Expression rhs) {
        this.setOutputVarInited();
        return VariableDeclaration.builder(name).setMutable().setRhs(rhs).build();
    }

    public Statement addChunkToOutputVar(Expression chunk) {
        return this.addChunksToOutputVar((List<? extends Expression>)ImmutableList.of((Object)chunk));
    }

    public Statement addChunksToOutputVar(List<? extends Expression> codeChunks) {
        if (this.currentOutputVar().initialized) {
            Expression rhs = Expressions.concat(codeChunks);
            return this.currentOutputVar().name.plusEquals(rhs).asStatement();
        }
        Expression rhs = Expressions.concatForceString(codeChunks);
        return this.initOutputVar(this.currentOutputVar().name.singleExprOrName(FormatOptions.JSSRC).getText(), rhs);
    }

    public void pushOutputVar(String outputVarName) {
        this.outputVars.push(new OutputVar(Expressions.id(outputVarName), false));
    }

    @CanIgnoreReturnValue
    public Expression popOutputVar() {
        return this.outputVars.pop().name;
    }

    public void setOutputVarInited() {
        Expression outputVar = this.outputVars.pop().name;
        this.outputVars.push(new OutputVar(outputVar, true));
    }

    private static final class OutputVar {
        final Expression name;
        final boolean initialized;

        OutputVar(Expression name, boolean initialized) {
            this.name = name;
            this.initialized = initialized;
        }
    }
}

