/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyToJsVariableMappings {
    private final Map<String, Expression> mappings;
    private final IdentityHashMap<MsgFallbackGroupNode, Expression> isPrimaryMsgInUseForFallbackGroup;

    private SoyToJsVariableMappings(Map<String, ? extends Expression> initialMappings) {
        this.mappings = new HashMap<String, Expression>(initialMappings);
        this.isPrimaryMsgInUseForFallbackGroup = new IdentityHashMap();
    }

    private SoyToJsVariableMappings(SoyToJsVariableMappings parent) {
        this.mappings = new HashMap<String, Expression>(parent.mappings);
        this.isPrimaryMsgInUseForFallbackGroup = parent.isPrimaryMsgInUseForFallbackGroup;
    }

    public static SoyToJsVariableMappings newEmpty() {
        return new SoyToJsVariableMappings((Map<String, ? extends Expression>)ImmutableMap.of());
    }

    static SoyToJsVariableMappings startingWith(SoyToJsVariableMappings initialMappings) {
        return new SoyToJsVariableMappings(initialMappings);
    }

    @VisibleForTesting
    static SoyToJsVariableMappings startingWith(ImmutableMap<String, ? extends Expression> initialMappings) {
        return new SoyToJsVariableMappings((Map<String, ? extends Expression>)initialMappings);
    }

    public SoyToJsVariableMappings put(VarDefn var, Expression translation) {
        return this.put(var.refName(), translation);
    }

    @CanIgnoreReturnValue
    public SoyToJsVariableMappings put(String var, Expression translation) {
        this.mappings.put(var, translation);
        return this;
    }

    @CanIgnoreReturnValue
    public SoyToJsVariableMappings setIsPrimaryMsgInUse(MsgFallbackGroupNode msg, Expression var) {
        this.isPrimaryMsgInUseForFallbackGroup.put(msg, var);
        return this;
    }

    public Expression get(String name) {
        return (Expression)Preconditions.checkNotNull((Object)this.mappings.get(name), (String)"No value for key %s. Available keys: %s", (Object)name, (Object)String.join((CharSequence)",", this.mappings.keySet()));
    }

    public Expression isPrimaryMsgInUse(MsgFallbackGroupNode msg) {
        return this.isPrimaryMsgInUseForFallbackGroup.get(msg);
    }

    @Nullable
    public Expression maybeGet(String name) {
        return this.mappings.get(name);
    }

    public boolean has(String name) {
        return this.mappings.get(name) != null;
    }
}

