/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.NullSafeAccumulator;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnknownType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;

public class TranslateExprNodeVisitor
extends AbstractReturningExprNodeVisitor<Expression> {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private static final SoyErrorKind UNION_ACCESSOR_MISMATCH = SoyErrorKind.of("Cannot access field ''{0}'' of type ''{1}'', because the different union member types have different access methods.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_JS_SRC_FUNCTION_NOT_FOUND = SoyErrorKind.of("Function ''{0}'' implemented by ''{1}'' does not have a JavaScript implementation.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_JS_SRC_BAD_LIST_TO_MAP_CONSTRUCTOR = SoyErrorKind.of("List to map constructor encloses ''{0}'', which is not a list.", new SoyErrorKind.StyleAllowance[0]);
    private final TranslationContext translationContext;
    private final JavaScriptValueFactoryImpl javascriptValueFactory;
    private final ErrorReporter errorReporter;
    private final TemplateAliases templateAliases;
    private final Expression dataSource;
    private static final ImmutableSet<SoyType.Kind> CAN_USE_EQUALS = Sets.immutableEnumSet((Enum)SoyType.Kind.INT, (Enum[])new SoyType.Kind[]{SoyType.Kind.FLOAT, SoyType.Kind.PROTO_ENUM, SoyType.Kind.BOOL, SoyType.Kind.STRING});

    public TranslateExprNodeVisitor(JavaScriptValueFactoryImpl javascriptValueFactory, TranslationContext translationContext, TemplateAliases templateAliases, ErrorReporter errorReporter, Expression dataSource) {
        this.javascriptValueFactory = javascriptValueFactory;
        this.errorReporter = errorReporter;
        this.translationContext = translationContext;
        this.templateAliases = templateAliases;
        this.dataSource = dataSource;
    }

    public Expression getDataSource() {
        return this.dataSource;
    }

    @Override
    protected Expression visit(ExprNode node) {
        return (Expression)Preconditions.checkNotNull((Object)((Expression)super.visit(node)), (String)"visit(%s) returned null", (Object)node);
    }

    Expression genCodeForParamAccess(String paramName, VarDefn varDefn) {
        Expression source = this.dataSource;
        Preconditions.checkState((varDefn instanceof TemplateParam || varDefn instanceof TemplateStateVar ? 1 : 0) != 0, (String)"expected a parameter type, got, %s", (Object)varDefn);
        if (varDefn.isInjected()) {
            if (paramName.equals("csp_nonce") || paramName.equals("csp_style_nonce")) {
                return JsRuntime.IJ_DATA.and(JsRuntime.IJ_DATA.dotAccess(paramName), this.translationContext.codeGenerator());
            }
            source = JsRuntime.IJ_DATA;
        } else if (varDefn.kind() == VarDefn.Kind.STATE) {
            return this.genCodeForStateAccess(paramName, (TemplateStateVar)varDefn);
        }
        if (varDefn instanceof TemplateParam && ((TemplateParam)varDefn).isImplicit()) {
            source = source.castAsUnknown();
        }
        return source.dotAccess(paramName);
    }

    protected Expression genCodeForStateAccess(String paramName, TemplateStateVar stateVar) {
        return Expressions.id(paramName);
    }

    @Override
    protected Expression visitExprRootNode(ExprRootNode node) {
        return this.visit(node.getRoot());
    }

    @Override
    protected Expression visitBooleanNode(BooleanNode node) {
        return node.getValue() ? Expressions.LITERAL_TRUE : Expressions.LITERAL_FALSE;
    }

    @Override
    protected Expression visitFloatNode(FloatNode node) {
        return Expressions.number(node.getValue());
    }

    @Override
    protected Expression visitIntegerNode(IntegerNode node) {
        return Expressions.number(node.getValue());
    }

    @Override
    protected Expression visitNullNode(NullNode node) {
        return Expressions.LITERAL_NULL;
    }

    @Override
    protected Expression visitUndefinedNode(UndefinedNode node) {
        return Expressions.LITERAL_UNDEFINED;
    }

    @Override
    protected Expression visitStringNode(StringNode node) {
        return Expressions.stringLiteral(node.getValue());
    }

    @Override
    protected Expression visitProtoEnumValueNode(ProtoEnumValueNode node) {
        return Expressions.number(node.getValue());
    }

    @Override
    protected Expression visitListLiteralNode(ListLiteralNode node) {
        if (node.numChildren() == 0) {
            return Expressions.arrayLiteral((Iterable<? extends Expression>)ImmutableList.of());
        }
        return JsRuntime.SOY_MAKE_ARRAY.call(this.visitChildren(node));
    }

    @Override
    protected Expression visitListComprehensionNode(ListComprehensionNode node) {
        Expression base = this.visit(node.getListExpr());
        String listIterVarTranslation = "list_comp_" + node.getNodeId() + "_" + node.getListIterVar().name();
        try (TranslationContext.ExitScope unused = this.translationContext.enterSoyScope();){
            VarRefNode transformNode;
            JsDoc doc;
            SoyType listType;
            String indexVarTranslation;
            this.translationContext.soyToJsVariableMappings().put(node.getListIterVar(), Expressions.id(listIterVarTranslation));
            String string = indexVarTranslation = node.getIndexVar() == null ? null : "list_comp_" + node.getNodeId() + "_" + node.getIndexVar().name();
            if (node.getIndexVar() != null) {
                this.translationContext.soyToJsVariableMappings().put(node.getIndexVar(), Expressions.id(indexVarTranslation));
            }
            UnknownType elementType = (listType = SoyTypes.tryRemoveNullish(node.getListExpr().getType())).getKind() == SoyType.Kind.LIST ? ((ListType)listType).getElementType() : UnknownType.getInstance();
            JsType elementJsType = this.jsTypeForStrict(elementType);
            JsDoc jsDoc = doc = node.getIndexVar() == null ? JsDoc.builder().addParam(listIterVarTranslation, elementJsType.typeExpr()).addGoogRequires((Collection<? extends GoogRequire>)elementJsType.getGoogRequires()).build() : JsDoc.builder().addParam(listIterVarTranslation, elementJsType.typeExpr()).addParam(indexVarTranslation, "number").addGoogRequires((Collection<? extends GoogRequire>)elementJsType.getGoogRequires()).build();
            if (node.getFilterExpr() != null && node.getIndexVar() != null) {
                Expression expression = JsRuntime.SOY_FILTER_AND_MAP.call(base, Expressions.arrowFunction(doc, this.maybeCoerceToBoolean(node.getFilterExpr().getType(), this.visit(node.getFilterExpr()), false)), Expressions.arrowFunction(doc, this.visit(node.getListItemTransformExpr())));
                return expression;
            }
            if (node.getFilterExpr() != null) {
                base = JsRuntime.SOY_AS_READONLY.call(base).dotAccess("filter").call(Expressions.arrowFunction(doc, this.maybeCoerceToBoolean(node.getFilterExpr().getType(), this.visit(node.getFilterExpr()), false)));
            }
            if (node.getListItemTransformExpr().getKind() == ExprNode.Kind.VAR_REF_NODE && (transformNode = (VarRefNode)node.getListItemTransformExpr()).getDefnDecl().equals(node.getListIterVar())) {
                Expression expression = base;
                return expression;
            }
            Expression expression = base = JsRuntime.SOY_AS_READONLY.call(base).dotAccess("map").call(Expressions.arrowFunction(doc, this.visit(node.getListItemTransformExpr())));
            return expression;
        }
    }

    @Override
    protected Expression visitRecordLiteralNode(RecordLiteralNode node) {
        LinkedHashMap<String, Expression> objLiteral = new LinkedHashMap<String, Expression>();
        for (int i = 0; i < node.numChildren(); ++i) {
            objLiteral.put(node.getKey(i).identifier(), this.visit(node.getChild(i)));
        }
        return Expressions.objectLiteral(objLiteral);
    }

    @Override
    protected Expression visitMapLiteralNode(MapLiteralNode node) {
        Expression map = Expressions.constructMap(new Expression[0]);
        if (node.getType() != MapType.EMPTY_MAP) {
            MapType mapType = (MapType)node.getType();
            JsType keyType = this.jsTypeFor(mapType.getKeyType());
            JsType valueType = this.jsTypeFor(mapType.getValueType());
            map = map.castAs(String.format("!Map<%s, %s>", keyType.typeExpr(), valueType.typeExpr()), (ImmutableSet<GoogRequire>)ImmutableSet.builder().addAll(keyType.getGoogRequires()).addAll(valueType.getGoogRequires()).build());
        }
        for (int i = 0; i < node.numChildren(); i += 2) {
            ExprNode keyNode = node.getChild(i);
            Expression key = this.assertNonNull(keyNode);
            Expression value = this.visit(node.getChild(i + 1));
            map = map.dotAccess("set").call(key, value);
        }
        return map;
    }

    @Override
    protected Expression visitMapLiteralFromListNode(MapLiteralFromListNode node) {
        Expression list = this.visit(node.getListExpr());
        SoyType listType = node.getListExpr().getType();
        if (!(listType instanceof ListType)) {
            this.errorReporter.report(node.getSourceLocation(), SOY_JS_SRC_BAD_LIST_TO_MAP_CONSTRUCTOR, list);
            return Expressions.constructMap(new Expression[0]);
        }
        if (listType.equals(ListType.EMPTY_LIST)) {
            return Expressions.constructMap(new Expression[0]);
        }
        String dummyVar = "list_to_map_constructor_" + node.getNodeId();
        JsDoc doc = JsDoc.builder().addParam(dummyVar, this.jsTypeForStrict(((ListType)listType).getElementType()).typeExpr()).build();
        Expression body = Expressions.arrayLiteral(Arrays.asList(Expressions.id(dummyVar).dotAccess("key"), Expressions.id(dummyVar).dotAccess("value")));
        Expression nestedList = list.dotAccess("map").call(Expressions.arrowFunction(doc, body));
        return Expressions.constructMap(nestedList);
    }

    @Override
    protected Expression visitVarRefNode(VarRefNode node) {
        Expression translation = this.translationContext.soyToJsVariableMappings().maybeGet(node.getName());
        if (translation != null) {
            return translation;
        }
        return this.genCodeForParamAccess(node.getNameWithoutLeadingDollar(), node.getDefnDecl());
    }

    @Override
    protected Expression visitDataAccessNode(DataAccessNode node) {
        Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
        return this.accumulateDataAccess(node).result(this.translationContext.codeGenerator());
    }

    @Override
    protected Expression visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
        NullSafeAccumulator accumulator = new NullSafeAccumulator(this.visit(nullSafeAccessNode.getBase()));
        ExprNode dataAccess = nullSafeAccessNode.getDataAccess();
        while (dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode nullSafe = (NullSafeAccessNode)dataAccess;
            accumulator = this.accumulateNullSafeDataAccess((DataAccessNode)nullSafe.getBase(), accumulator);
            dataAccess = nullSafe.getDataAccess();
        }
        return this.accumulateNullSafeDataAccessTail((ExprNode.AccessChainComponentNode)dataAccess, accumulator).result(this.translationContext.codeGenerator());
    }

    protected Expression sanitizedContentToProtoConverterFunction(Descriptors.Descriptor messageType) {
        return (Expression)JsRuntime.JS_TO_PROTO_PACK_FN.get((Object)messageType.getFullName());
    }

    private NullSafeAccumulator accumulateNullSafeDataAccessTail(ExprNode.AccessChainComponentNode dataAccess, NullSafeAccumulator accumulator) {
        if (dataAccess.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
            OperatorNodes.AssertNonNullOpNode assertNonNull = (OperatorNodes.AssertNonNullOpNode)dataAccess;
            dataAccess = (ExprNode.AccessChainComponentNode)assertNonNull.getChild(0);
        }
        return this.accumulateNullSafeDataAccess((DataAccessNode)dataAccess, accumulator);
    }

    private NullSafeAccumulator accumulateNullSafeDataAccess(DataAccessNode dataAccessNode, NullSafeAccumulator accumulator) {
        Preconditions.checkArgument((!dataAccessNode.isNullSafe() ? 1 : 0) != 0);
        boolean accessChain = false;
        if (dataAccessNode.getBaseExprChild() instanceof DataAccessNode) {
            accumulator = this.accumulateNullSafeDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild(), accumulator);
            accessChain = true;
        }
        return this.accumulateDataAccess(dataAccessNode, accumulator, !accessChain);
    }

    private NullSafeAccumulator accumulateDataAccess(DataAccessNode dataAccessNode) {
        Preconditions.checkArgument((!dataAccessNode.isNullSafe() ? 1 : 0) != 0);
        NullSafeAccumulator accumulator = dataAccessNode.getBaseExprChild() instanceof DataAccessNode ? this.accumulateDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild()) : new NullSafeAccumulator(this.visit(dataAccessNode.getBaseExprChild()));
        return this.accumulateDataAccess(dataAccessNode, accumulator, false);
    }

    private NullSafeAccumulator accumulateDataAccess(DataAccessNode dataAccessNode, NullSafeAccumulator accumulator, boolean nullSafe) {
        switch (dataAccessNode.getKind()) {
            case FIELD_ACCESS_NODE: {
                FieldAccessNode fieldAccess = (FieldAccessNode)dataAccessNode;
                SoySourceFunctionMethod sourceMethod = fieldAccess.getSoyMethod();
                if (sourceMethod != null) {
                    return accumulator.functionCall(nullSafe, this.javascriptValueFactory.invocation(fieldAccess.getSourceLocation(), fieldAccess.getFieldName(), (SoyJavaScriptSourceFunction)sourceMethod.getImpl(), (List<Expression>)ImmutableList.of(), this.translationContext.codeGenerator()));
                }
                NullSafeAccumulator.FieldAccess access = this.genCodeForFieldAccess(fieldAccess.getBaseExprChild().getType(), fieldAccess.getAccessSourceLocation(), fieldAccess.getFieldName());
                return accumulator.dotAccess(access, nullSafe);
            }
            case ITEM_ACCESS_NODE: {
                ItemAccessNode itemAccess = (ItemAccessNode)dataAccessNode;
                ExprNode keyNode = itemAccess.getKeyExprChild();
                return accumulator.bracketAccess(this.visit(keyNode).castAsUnknown(), nullSafe);
            }
            case METHOD_CALL_NODE: {
                MethodCallNode methodCall = (MethodCallNode)dataAccessNode;
                return this.genCodeForMethodCall(accumulator, methodCall, nullSafe);
            }
        }
        throw new AssertionError((Object)dataAccessNode.getKind());
    }

    private NullSafeAccumulator.FieldAccess genCodeForFieldAccess(SoyType baseType, SourceLocation sourceLocation, String fieldName) {
        Preconditions.checkNotNull((Object)baseType);
        return this.genCodeForMaybeUnion(baseType, fieldName, sourceLocation, type -> {
            if (type.getKind() == SoyType.Kind.PROTO) {
                SoyProtoType protoType = (SoyProtoType)type;
                Descriptors.FieldDescriptor desc = protoType.getFieldDescriptor(fieldName);
                Preconditions.checkNotNull((Object)desc, (String)"Error in proto %s, field not found: %s", (Object)protoType.getDescriptor().getFullName(), (Object)fieldName);
                return NullSafeAccumulator.FieldAccess.protoCall(fieldName, desc);
            }
            return NullSafeAccumulator.FieldAccess.id(fieldName);
        });
    }

    private NullSafeAccumulator genCodeForMethodCall(NullSafeAccumulator base, MethodCallNode methodCallNode, boolean nullSafe) {
        Preconditions.checkArgument((boolean)methodCallNode.isMethodResolved());
        SoyMethod soyMethod = methodCallNode.getSoyMethod();
        if (soyMethod instanceof BuiltinMethod) {
            BuiltinMethod builtinMethod = (BuiltinMethod)soyMethod;
            SoyType baseType = methodCallNode.getBaseType(nullSafe);
            SourceLocation sourceLocation = methodCallNode.getAccessSourceLocation();
            switch (builtinMethod) {
                case GET_READONLY_EXTENSION: 
                case HAS_EXTENSION: 
                case GET_EXTENSION: {
                    SoyProtoType protoBaseType = (SoyProtoType)SoyTypes.tryRemoveNullish(baseType);
                    String extName = BuiltinMethod.getProtoExtensionIdFromMethodCall(methodCallNode);
                    Descriptors.FieldDescriptor descriptor = protoBaseType.getFieldDescriptor(extName);
                    return base.dotAccess(builtinMethod == BuiltinMethod.GET_READONLY_EXTENSION ? NullSafeAccumulator.ProtoCall.getReadonlyField(extName, descriptor) : (builtinMethod == BuiltinMethod.HAS_EXTENSION ? NullSafeAccumulator.ProtoCall.hasField(extName, descriptor) : NullSafeAccumulator.ProtoCall.getField(extName, descriptor)), nullSafe);
                }
                case HAS_PROTO_FIELD: {
                    String fieldName = BuiltinMethod.getProtoFieldNameFromMethodCall(methodCallNode);
                    NullSafeAccumulator.FieldAccess fieldAccess = this.genCodeForMaybeUnion(baseType, fieldName, sourceLocation, type -> NullSafeAccumulator.ProtoCall.hasField(fieldName, ((SoyProtoType)type).getFieldDescriptor(fieldName)));
                    return base.dotAccess(fieldAccess, nullSafe);
                }
                case GET_PROTO_FIELD: {
                    String fieldName = BuiltinMethod.getProtoFieldNameFromMethodCall(methodCallNode);
                    NullSafeAccumulator.FieldAccess fieldAccess = this.genCodeForMaybeUnion(baseType, fieldName, sourceLocation, type -> NullSafeAccumulator.ProtoCall.getField(fieldName, ((SoyProtoType)type).getFieldDescriptor(fieldName)));
                    return base.dotAccess(fieldAccess, nullSafe);
                }
                case GET_PROTO_FIELD_OR_UNDEFINED: {
                    String fieldName = BuiltinMethod.getProtoFieldNameFromMethodCall(methodCallNode);
                    NullSafeAccumulator.FieldAccess fieldAccess = this.genCodeForMaybeUnion(baseType, fieldName, sourceLocation, type -> NullSafeAccumulator.ProtoCall.getFieldOrUndefined(fieldName, ((SoyProtoType)type).getFieldDescriptor(fieldName)));
                    return base.dotAccess(fieldAccess, nullSafe);
                }
                case GET_READONLY_PROTO_FIELD: {
                    String fieldName = BuiltinMethod.getProtoFieldNameFromMethodCall(methodCallNode);
                    NullSafeAccumulator.FieldAccess fieldAccess = this.genCodeForMaybeUnion(baseType, fieldName, sourceLocation, type -> NullSafeAccumulator.ProtoCall.getReadonlyField(fieldName, ((SoyProtoType)type).getFieldDescriptor(fieldName)));
                    return base.dotAccess(fieldAccess, nullSafe);
                }
                case MAP_GET: {
                    return base.mapGetAccess(this.visit(methodCallNode.getParam(0)), nullSafe);
                }
                case BIND: {
                    return base.transform(nullSafe, baseExpr -> this.genCodeForBind((Expression)baseExpr, this.visit(methodCallNode.getParam(0)), baseType));
                }
            }
            throw new AssertionError(builtinMethod);
        }
        if (soyMethod instanceof SoySourceFunctionMethod) {
            SoySourceFunctionMethod sourceMethod = (SoySourceFunctionMethod)soyMethod;
            return base.functionCall(nullSafe, this.javascriptValueFactory.invocation(methodCallNode.getSourceLocation(), methodCallNode.getMethodName().identifier(), (SoyJavaScriptSourceFunction)sourceMethod.getImpl(), (List)methodCallNode.getParams().stream().map(this::visit).collect(ImmutableList.toImmutableList()), this.translationContext.codeGenerator()));
        }
        throw new AssertionError(soyMethod.getClass());
    }

    private NullSafeAccumulator.FieldAccess genCodeForMaybeUnion(SoyType baseType, String fieldName, SourceLocation sourceLocation, Function<SoyType, NullSafeAccumulator.FieldAccess> memberGenerator) {
        if (baseType.isNullOrUndefined()) {
            return memberGenerator.apply(baseType);
        }
        NullSafeAccumulator.FieldAccess fieldAccess = null;
        for (SoyType type : SoyTypes.expandUnions(baseType)) {
            if (type.isNullOrUndefined()) continue;
            NullSafeAccumulator.FieldAccess fieldAccessForType = memberGenerator.apply(type);
            if (fieldAccess == null) {
                fieldAccess = fieldAccessForType;
                continue;
            }
            if (fieldAccess.equals(fieldAccessForType)) continue;
            this.errorReporter.report(sourceLocation, UNION_ACCESSOR_MISMATCH, fieldName, baseType);
        }
        return fieldAccess;
    }

    protected Expression genCodeForBind(Expression template, Expression paramRecord, SoyType templateType) {
        return JsRuntime.BIND_TEMPLATE_PARAMS.call(template, paramRecord);
    }

    @Override
    protected Expression visitGlobalNode(GlobalNode node) {
        return Expressions.dottedIdNoRequire(node.getName());
    }

    @Override
    protected Expression visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List operands = this.visitChildren(node);
        Expression consequent = (Expression)operands.get(0);
        Expression alternate = (Expression)operands.get(1);
        return consequent.nullishCoalesce(alternate, this.translationContext.codeGenerator());
    }

    @Override
    protected Expression visitAndOpNode(OperatorNodes.AndOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        ExprNode lhOperand = node.getChild(0);
        ExprNode rhOperand = node.getChild(1);
        Expression lhChunk = this.maybeCoerceToBoolean(lhOperand.getType(), this.visit(lhOperand), true);
        Expression rhChunk = this.maybeCoerceToBoolean(rhOperand.getType(), this.visit(rhOperand), true);
        return lhChunk.and(rhChunk, this.translationContext.codeGenerator());
    }

    @Override
    protected Expression visitOrOpNode(OperatorNodes.OrOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        ExprNode lhOperand = node.getChild(0);
        ExprNode rhOperand = node.getChild(1);
        Expression lhChunk = this.maybeCoerceToBoolean(lhOperand.getType(), this.visit(lhOperand), true);
        Expression rhChunk = this.maybeCoerceToBoolean(rhOperand.getType(), this.visit(rhOperand), true);
        return lhChunk.or(rhChunk, this.translationContext.codeGenerator());
    }

    @Override
    protected Expression visitAmpAmpOpNode(OperatorNodes.AmpAmpOpNode node) {
        return this.visit(node.getChild(0)).and(this.visit(node.getChild(1)), this.translationContext.codeGenerator());
    }

    @Override
    protected Expression visitBarBarOpNode(OperatorNodes.BarBarOpNode node) {
        return this.visit(node.getChild(0)).or(this.visit(node.getChild(1)), this.translationContext.codeGenerator());
    }

    @Override
    protected Expression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 3 ? 1 : 0) != 0);
        return this.translationContext.codeGenerator().conditionalExpression(this.maybeCoerceToBoolean(node.getChild(0).getType(), this.visit(node.getChild(0)), false), this.visit(node.getChild(1)), this.visit(node.getChild(2)));
    }

    @Override
    protected Expression visitNotOpNode(OperatorNodes.NotOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 1 ? 1 : 0) != 0);
        ExprNode operand = node.getChild(0);
        return Expressions.operation(node.getOperator(), Arrays.asList(this.maybeCoerceToBoolean(operand.getType(), this.visit(operand), false)));
    }

    protected Expression maybeCoerceToBoolean(SoyType type, Expression chunk, boolean force) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)chunk);
        if (force && type.getKind() != SoyType.Kind.BOOL) {
            return JsRuntime.SOY_COERCE_TO_BOOLEAN.call(chunk);
        }
        return chunk;
    }

    protected Expression hasContent(Expression chunk) {
        return JsRuntime.SOY_HAS_CONTENT.call(chunk);
    }

    protected Expression isTruthyNonEmpty(Expression chunk) {
        return JsRuntime.SOY_IS_TRUTHY_NON_EMPTY.call(chunk);
    }

    @Override
    protected Expression visitOperatorNode(ExprNode.OperatorNode node) {
        return Expressions.operation(node.getOperator(), this.visitChildren(node));
    }

    private Expression visitEqualNodeHelper(ExprNode.OperatorNode node, Operator eq) {
        Expression rv;
        boolean needsSoyEquals = false;
        boolean neverSoyEquals = false;
        for (ExprNode c : node.getChildren()) {
            SoyType type = c.getType();
            if (type.isNullOrUndefined()) {
                neverSoyEquals = true;
                continue;
            }
            if (SoyTypes.isKindOrUnionOfKinds(type, CAN_USE_EQUALS)) continue;
            needsSoyEquals = true;
        }
        if (needsSoyEquals && !neverSoyEquals) {
            rv = JsRuntime.SOY_EQUALS.call(this.visitChildren(node));
            if (eq == Operator.NOT_EQUAL) {
                rv = Expressions.not(rv);
            }
        } else {
            rv = Expressions.operation(eq, this.visitChildren(node));
        }
        return rv;
    }

    @Override
    protected Expression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return this.visitEqualNodeHelper(node, Operator.EQUAL);
    }

    @Override
    protected Expression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return this.visitEqualNodeHelper(node, Operator.NOT_EQUAL);
    }

    @Override
    protected Expression visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
        return this.visit((ExprNode)Iterables.getOnlyElement(node.getChildren()));
    }

    private Expression protoInitFieldValue(Descriptors.FieldDescriptor fieldDesc, Expression fieldValue, boolean isRepeatedElement) {
        boolean isArray;
        boolean bl = isArray = fieldDesc.isRepeated() && !isRepeatedElement;
        if (ProtoUtils.isSanitizedContentField(fieldDesc)) {
            Expression sanitizedContentPackFn = this.sanitizedContentToProtoConverterFunction(fieldDesc.getMessageType());
            return isArray ? JsRuntime.GOOG_ARRAY_MAP.call(fieldValue, sanitizedContentPackFn) : sanitizedContentPackFn.call(fieldValue);
        }
        if (fieldDesc.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
            return isArray ? JsRuntime.GOOG_ARRAY_MAP.call(fieldValue, JsRuntime.protoBytesPackToByteStringFunction()) : JsRuntime.protoBytesPackToByteStringFunction().call(fieldValue);
        }
        if (fieldDesc.getType() == Descriptors.FieldDescriptor.Type.ENUM && !isArray) {
            return fieldValue.castAsUnknown();
        }
        return fieldValue;
    }

    protected Expression visitProtoInitFunction(FunctionNode node) {
        SoyProtoType type = (SoyProtoType)node.getType();
        if (node.numParams() == 0) {
            return JsRuntime.emptyProto(type);
        }
        Expression proto = Expressions.construct(JsRuntime.protoConstructor(type), new Expression[0]);
        for (int i = 0; i < node.numParams(); ++i) {
            int j;
            String fnName;
            String fieldName = node.getParamName(i).identifier();
            Descriptors.FieldDescriptor fieldDesc = type.getFieldDescriptor(fieldName);
            ExprNode child = node.getParam(i);
            if (fieldDesc.isMapField() && child.getKind() == ExprNode.Kind.MAP_LITERAL_NODE) {
                MapLiteralNode mapLiteral = (MapLiteralNode)child;
                fnName = "put" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName.substring(0, fieldName.length() - 3)) + ProtoUtils.getJsFieldSpecificSuffix(fieldDesc);
                for (j = 0; j < mapLiteral.numChildren(); j += 2) {
                    Expression key = this.visit(mapLiteral.getChild(j));
                    Expression value = this.protoInitFieldValue(ProtoUtils.getMapValueFieldDescriptor(fieldDesc), this.visit(mapLiteral.getChild(j + 1)), false);
                    proto = proto.dotAccess(fnName).call(key, value);
                }
                continue;
            }
            if (fieldDesc.isRepeated() && !fieldDesc.isExtension() && child.getKind() == ExprNode.Kind.LIST_LITERAL_NODE) {
                ListLiteralNode listLiteral = (ListLiteralNode)child;
                fnName = "add" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName.substring(0, fieldName.length() - 4)) + ProtoUtils.getJsFieldSpecificSuffix(fieldDesc);
                for (j = 0; j < listLiteral.numChildren(); ++j) {
                    proto = proto.dotAccess(fnName).call(this.protoInitFieldValue(fieldDesc, this.visit(listLiteral.getChild(j)), true));
                }
                continue;
            }
            Expression fieldValue = this.protoInitFieldValue(fieldDesc, this.visit(child), false);
            if (fieldDesc.isExtension()) {
                Expression extInfo = JsRuntime.extensionField(fieldDesc);
                proto = proto.dotAccess("setExtension").call(extInfo, fieldValue);
                continue;
            }
            if (fieldDesc.isMapField()) {
                if (ProtoUtils.isSanitizedContentMap(fieldDesc)) {
                    Expression sanitizedContentPackFn = this.sanitizedContentToProtoConverterFunction(ProtoUtils.getMapValueMessageType(fieldDesc));
                    fieldValue = JsRuntime.SOY_NEWMAPS_TRANSFORM_VALUES.call(fieldValue, sanitizedContentPackFn);
                } else if (ProtoUtils.getMapValueFieldDescriptor(fieldDesc).getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                    fieldValue = JsRuntime.SOY_NEWMAPS_TRANSFORM_VALUES.call(fieldValue, JsRuntime.protoBytesPackToByteStringFunction());
                }
                proto = proto.dotAccess("putAll" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName).substring(0, fieldName.length() - 3) + ProtoUtils.getJsFieldSpecificSuffix(fieldDesc)).call(fieldValue);
                continue;
            }
            String setFn = "set" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName) + ProtoUtils.getJsFieldSpecificSuffix(fieldDesc);
            proto = proto.dotAccess(setFn).call(fieldValue);
        }
        return JsRuntime.castAsReadonlyProto(JsRuntime.SOY.dotAccess("$$maybeMakeImmutableProto").call(proto), type);
    }

    @Override
    protected Expression visitFunctionNode(FunctionNode node) {
        Object soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            switch ((BuiltinFunction)soyFunction) {
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node);
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case EVAL_TOGGLE: {
                    return this.visitToggleFunction(node, false);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case SOY_SERVER_KEY: {
                    return this.visitSoyServerKeyFunction(node);
                }
                case PROTO_INIT: {
                    return this.visitProtoInitFunction(node);
                }
                case UNKNOWN_JS_GLOBAL: {
                    return this.visitUnknownJsGlobal(node);
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    return this.visitIsPrimaryMsgInUseFunction(node);
                }
                case TO_FLOAT: {
                    return this.visit(node.getParam(0));
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    return JsRuntime.GOOG_DEBUG.and(JsRuntime.SOY_DEBUG_SOY_TEMPLATE_INFO.call(new Expression[0]), this.translationContext.codeGenerator());
                }
                case VE_DATA: {
                    return this.visitVeDataFunction(node);
                }
                case VE_DEF: {
                    return this.visitVeDefFunction(node);
                }
                case EMPTY_TO_NULL: {
                    return this.visitEmptyToNullFunction(node);
                }
                case UNDEFINED_TO_NULL: {
                    return this.visit(node.getParam(0)).nullishCoalesce(Expressions.LITERAL_NULL, this.translationContext.codeGenerator());
                }
                case UNDEFINED_TO_NULL_SSR: {
                    return this.visit(node.getParam(0));
                }
                case BOOLEAN: {
                    return this.maybeCoerceToBoolean(AnyType.getInstance(), this.visit(node.getParam(0)), true);
                }
                case IS_TRUTHY_NON_EMPTY: {
                    return this.isTruthyNonEmpty(this.visit(node.getParam(0)));
                }
                case HAS_CONTENT: {
                    return this.hasContent(this.visit(node.getParam(0)));
                }
                case LEGACY_DYNAMIC_TAG: 
                case REMAINDER: 
                case MSG_WITH_ID: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof LoggingFunction) {
            return Expressions.stringLiteral(((LoggingFunction)soyFunction).getPlaceholder());
        }
        if (soyFunction instanceof SoyJavaScriptSourceFunction) {
            return this.javascriptValueFactory.applyFunction(node.getSourceLocation(), node.getStaticFunctionName(), (SoyJavaScriptSourceFunction)soyFunction, this.visitParams(node), this.translationContext.codeGenerator());
        }
        if (soyFunction instanceof FunctionNode.ExternRef) {
            FunctionNode.ExternRef ref = (FunctionNode.ExternRef)soyFunction;
            if (!this.translationContext.soyToJsVariableMappings().has(ref.name())) {
                return Expressions.LITERAL_UNDEFINED;
            }
            return this.translationContext.soyToJsVariableMappings().get(ref.name()).call(this.visitParams(node));
        }
        if (!(soyFunction instanceof SoyJsSrcFunction)) {
            this.errorReporter.report(node.getSourceLocation(), SOY_JS_SRC_FUNCTION_NOT_FOUND, node.getStaticFunctionName(), soyFunction == null ? "missing implementation" : soyFunction.getClass().getName());
            soyFunction = TranslateExprNodeVisitor.getUnknownFunction(node.getStaticFunctionName(), node.numParams());
        }
        return SoyJsPluginUtils.applySoyFunction((SoyJsSrcFunction)soyFunction, this.visitParams(node), node.getSourceLocation(), this.errorReporter);
    }

    protected JsType jsTypeForStrict(SoyType type) {
        return JsType.forJsSrcStrict(type);
    }

    protected JsType jsTypeFor(SoyType type) {
        return JsType.forJsSrc(type);
    }

    private Expression visitCheckNotNullFunction(FunctionNode node) {
        return this.assertNonNull(node.getParam(0));
    }

    private Expression assertNonNull(ExprNode expr) {
        Expression e = this.visit(expr);
        return e.isDefinitelyNotNull() ? e : JsRuntime.SOY_CHECK_NOT_NULL.call(e);
    }

    private Expression visitCssFunction(FunctionNode node) {
        return JsRuntime.GOOG_GET_CSS_NAME.call(this.visitParams(node));
    }

    protected Expression visitToggleFunction(FunctionNode node, boolean useGoogModuleSyntax) {
        StringNode pathName = (StringNode)node.getChild(0);
        StringNode toggleName = (StringNode)node.getChild(1);
        return JsRuntime.getToggleRef(pathName.getValue(), toggleName.getValue(), useGoogModuleSyntax);
    }

    private Expression visitXidFunction(FunctionNode node) {
        return JsRuntime.XID.call(this.visitParams(node));
    }

    private Expression visitSoyServerKeyFunction(FunctionNode node) {
        return JsRuntime.SERIALIZE_KEY.call(this.visit(node.getParam(0)));
    }

    private Expression visitIsPrimaryMsgInUseFunction(FunctionNode node) {
        MsgFallbackGroupNode msgNode = (MsgFallbackGroupNode)((LetContentNode)((LocalVar)((VarRefNode)node.getParam(0)).getDefnDecl()).declaringNode()).getChild(0);
        return this.translationContext.soyToJsVariableMappings().isPrimaryMsgInUse(msgNode);
    }

    private Expression visitUnknownJsGlobal(FunctionNode node) {
        StringNode expr = (StringNode)node.getParam(0);
        return this.translationContext.codeGenerator().declarationBuilder().setRhs(Expressions.dottedIdNoRequire(expr.getValue())).setJsDoc(JsDoc.builder().addParameterizedAnnotation("suppress", "missingRequire").build()).build().ref();
    }

    private Expression visitVeDataFunction(FunctionNode node) {
        return Expressions.construct(JsRuntime.SOY_VISUAL_ELEMENT_DATA, this.visit(node.getParam(0)), this.visit(node.getParam(1)));
    }

    private Expression visitVeDefFunction(FunctionNode node) {
        Expression metadataExpr = node.numParams() == 4 ? this.visit(node.getParam(3)) : Expressions.LITERAL_UNDEFINED;
        Expression debugNameExpr = Expressions.ifExpression(JsRuntime.GOOG_DEBUG, this.visit(node.getParam(0))).setElse(Expressions.LITERAL_UNDEFINED).build(this.translationContext.codeGenerator());
        return Expressions.construct(JsRuntime.SOY_VISUAL_ELEMENT, this.visit(node.getParam(1)), metadataExpr, debugNameExpr);
    }

    protected Expression visitEmptyToNullFunction(FunctionNode node) {
        return JsRuntime.SOY_EMPTY_TO_NULL.call(this.visit(node.getParam(0)));
    }

    private static SoyJsSrcFunction getUnknownFunction(final String name, final int argSize) {
        return new SoyJsSrcFunction(){

            @Override
            public JsExpr computeForJsSrc(List<JsExpr> args) {
                ArrayList<String> argStrings = new ArrayList<String>();
                for (JsExpr arg : args) {
                    argStrings.add(arg.getText());
                }
                return new JsExpr(name + "(" + COMMA_JOINER.join(argStrings) + ")", Integer.MAX_VALUE);
            }

            @Override
            public String getName() {
                return name;
            }

            public ImmutableSet<Integer> getValidArgsSizes() {
                return ImmutableSet.of((Object)argSize);
            }
        };
    }

    @Override
    protected Expression visitTemplateLiteralNode(TemplateLiteralNode node) {
        Expression templateLiteral = Expressions.dottedIdNoRequire(this.templateAliases.get(node.getResolvedName()));
        return JsRuntime.MARK_TEMPLATE.call(templateLiteral, Expressions.stringLiteral(node.getResolvedName()));
    }

    private List<Expression> visitParams(ExprNode.CallableExpr call) {
        ArrayList<Expression> results = new ArrayList<Expression>(call.numParams());
        for (ExprNode child : call.getParams()) {
            results.add(this.visit(child));
        }
        return results;
    }
}

