/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.msgs.restricted.MsgPartUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IcuSyntaxUtils {
    private static final Pattern ICU_SYNTAX_CHAR_NEEDING_ESCAPE_PATTERN = Pattern.compile(" ' (?= ['{}\\#] ) | ' $ | [{}] ", 4);
    private static final ImmutableMap<String, String> ICU_SYNTAX_CHAR_ESCAPE_MAP = ImmutableMap.of((Object)"'", (Object)"''", (Object)"{", (Object)"'{'", (Object)"}", (Object)"'}'");

    private IcuSyntaxUtils() {
    }

    public static ImmutableList<SoyMsgPart> convertMsgPartsToEmbeddedIcuSyntax(ImmutableList<SoyMsgPart> origMsgParts) {
        if (!MsgPartUtils.hasPlrselPart(origMsgParts)) {
            return origMsgParts;
        }
        ImmutableList.Builder newMsgPartsBuilder = ImmutableList.builder();
        StringBuilder currRawTextSb = new StringBuilder();
        IcuSyntaxUtils.convertMsgPartsHelper((ImmutableList.Builder<SoyMsgPart>)newMsgPartsBuilder, currRawTextSb, origMsgParts, false);
        if (currRawTextSb.length() > 0) {
            newMsgPartsBuilder.add((Object)SoyMsgRawTextPart.of(currRawTextSb.toString()));
        }
        return newMsgPartsBuilder.build();
    }

    private static void convertMsgPartsHelper(ImmutableList.Builder<SoyMsgPart> newMsgPartsBuilder, StringBuilder currRawTextSb, List<SoyMsgPart> origMsgParts, boolean isInPlrselPart) {
        for (SoyMsgPart origMsgPart : origMsgParts) {
            if (origMsgPart instanceof SoyMsgRawTextPart) {
                String rawText = ((SoyMsgRawTextPart)origMsgPart).getRawText();
                if (isInPlrselPart) {
                    rawText = IcuSyntaxUtils.icuEscape(rawText);
                }
                currRawTextSb.append(rawText);
                continue;
            }
            if (origMsgPart instanceof SoyMsgPlaceholderPart) {
                if (currRawTextSb.length() > 0) {
                    newMsgPartsBuilder.add((Object)SoyMsgRawTextPart.of(currRawTextSb.toString()));
                    currRawTextSb.setLength(0);
                }
                newMsgPartsBuilder.add((Object)origMsgPart);
                continue;
            }
            if (origMsgPart instanceof SoyMsgPluralRemainderPart) {
                currRawTextSb.append(IcuSyntaxUtils.getPluralRemainderString());
                continue;
            }
            if (origMsgPart instanceof SoyMsgPluralPart) {
                IcuSyntaxUtils.convertPluralPartHelper(newMsgPartsBuilder, currRawTextSb, (SoyMsgPluralPart)origMsgPart);
                continue;
            }
            if (!(origMsgPart instanceof SoyMsgSelectPart)) continue;
            IcuSyntaxUtils.convertSelectPartHelper(newMsgPartsBuilder, currRawTextSb, (SoyMsgSelectPart)origMsgPart);
        }
    }

    private static void convertPluralPartHelper(ImmutableList.Builder<SoyMsgPart> newMsgPartsBuilder, StringBuilder currRawTextSb, SoyMsgPluralPart origPluralPart) {
        currRawTextSb.append(IcuSyntaxUtils.getPluralOpenString(origPluralPart.getPluralVarName(), origPluralPart.getOffset()));
        for (SoyMsgPart.Case pluralCase : origPluralPart.getCases()) {
            currRawTextSb.append(IcuSyntaxUtils.getPluralCaseOpenString((SoyMsgPluralCaseSpec)pluralCase.spec()));
            IcuSyntaxUtils.convertMsgPartsHelper(newMsgPartsBuilder, currRawTextSb, pluralCase.parts(), true);
            currRawTextSb.append(IcuSyntaxUtils.getPluralCaseCloseString());
        }
        currRawTextSb.append(IcuSyntaxUtils.getPluralCloseString());
    }

    private static void convertSelectPartHelper(ImmutableList.Builder<SoyMsgPart> newMsgPartsBuilder, StringBuilder currRawTextSb, SoyMsgSelectPart origSelectPart) {
        currRawTextSb.append(IcuSyntaxUtils.getSelectOpenString(origSelectPart.getSelectVarName()));
        for (SoyMsgPart.Case selectCase : origSelectPart.getCases()) {
            currRawTextSb.append(IcuSyntaxUtils.getSelectCaseOpenString((String)selectCase.spec()));
            IcuSyntaxUtils.convertMsgPartsHelper(newMsgPartsBuilder, currRawTextSb, selectCase.parts(), true);
            currRawTextSb.append(IcuSyntaxUtils.getSelectCaseCloseString());
        }
        currRawTextSb.append(IcuSyntaxUtils.getSelectCloseString());
    }

    @VisibleForTesting
    static String icuEscape(String rawText) {
        Matcher matcher = ICU_SYNTAX_CHAR_NEEDING_ESCAPE_PATTERN.matcher(rawText);
        if (!matcher.find()) {
            return rawText;
        }
        StringBuffer escapedTextSb = new StringBuffer();
        do {
            String repl = (String)ICU_SYNTAX_CHAR_ESCAPE_MAP.get((Object)matcher.group());
            matcher.appendReplacement(escapedTextSb, repl);
        } while (matcher.find());
        matcher.appendTail(escapedTextSb);
        return escapedTextSb.toString();
    }

    private static String getPluralOpenString(String varName, int offset) {
        StringBuilder openingPartSb = new StringBuilder();
        openingPartSb.append('{').append(varName).append(",plural,");
        if (offset != 0) {
            openingPartSb.append("offset:").append(offset).append(' ');
        }
        return openingPartSb.toString();
    }

    private static String getPluralCloseString() {
        return "}";
    }

    private static String getPluralCaseOpenString(SoyMsgPluralCaseSpec pluralCaseSpec) {
        Object icuCaseName = pluralCaseSpec.getType() == SoyMsgPluralCaseSpec.Type.EXPLICIT ? "=" + pluralCaseSpec.getExplicitValue() : pluralCaseSpec.getType().name().toLowerCase();
        return (String)icuCaseName + "{";
    }

    private static String getPluralCaseCloseString() {
        return "}";
    }

    private static String getPluralRemainderString() {
        return "#";
    }

    private static String getSelectOpenString(String varName) {
        return "{" + varName + ",select,";
    }

    private static String getSelectCloseString() {
        return "}";
    }

    private static String getSelectCaseOpenString(String caseValue) {
        return (caseValue != null ? caseValue : "other") + "{";
    }

    private static String getSelectCaseCloseString() {
        return "}";
    }
}

