/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.LocalVariablesNodeVisitor;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@RunAfter(value={FinalizeTemplateRegistryPass.class})
final class CheckDelegatesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind CROSS_PACKAGE_DELCALL = SoyErrorKind.of("Found illegal call from ''{0}'' to ''{1}'', which is in a different delegate package.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELCALL_TO_BASIC_TEMPLATE = SoyErrorKind.of("''delcall'' to basic template defined at ''{0}'' (expected ''call'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different param declarations compared to the definition at {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND = SoyErrorKind.of("If one deltemplate has strict autoescaping, all its peers must also be strictly autoescaped with the same content kind: {0} != {1}. Conflicting definition at {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different strict html mode compared to the definition at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CANNOT_DELCALL_WITHOUT_LEGACY_NAMESPACE = SoyErrorKind.of("Modifiable templates must have legacydeltemplatenamespace set to be used with `delcall`.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CANNOT_DELTEMPLATE_WITHOUT_LEGACY_NAMESPACE = SoyErrorKind.of("Modifiable templates must have legacydeltemplatenamespace set to be used with `deltemplate`.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_DEPRECATED = SoyErrorKind.of("Deltemplates are deprecated. Use go/soy/reference/modifiable-templates instead.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> templateRegistryFull;

    CheckDelegatesPass(ErrorReporter errorReporter, Supplier<FileSetMetadata> templateRegistryFull) {
        this.errorReporter = errorReporter;
        this.templateRegistryFull = templateRegistryFull;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        this.checkTemplates(this.templateRegistryFull.get().getDelTemplateSelector());
        for (SoyFileNode fileNode : sourceFiles) {
            LocalVariablesNodeVisitor.LocalVariables localVariables = LocalVariablesNodeVisitor.getFileScopeVariables(fileNode);
            for (TemplateNode template : fileNode.getTemplates()) {
                if (template instanceof TemplateDelegateNode && Strings.isNullOrEmpty((String)((TemplateDelegateNode)template).getDelTemplateVariant()) && Strings.isNullOrEmpty((String)template.getModName())) {
                    this.errorReporter.report(template.getSourceLocation(), DELTEMPLATES_DEPRECATED, new Object[0]);
                }
                String currTemplateNameForUserMsgs = template.getTemplateNameForUserMsgs();
                String currModName = template.getModName();
                for (TemplateLiteralNode templateLiteralNode : SoyTreeUtils.getAllNodesOfType(template, TemplateLiteralNode.class)) {
                    this.checkTemplateLiteralNode(templateLiteralNode, currModName, currTemplateNameForUserMsgs);
                }
                for (CallDelegateNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallDelegateNode.class)) {
                    this.checkCallDelegateNode(callNode, localVariables, this.templateRegistryFull.get().getDelTemplateSelector());
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplates(DelTemplateSelector<TemplateMetadata> fileSetDelTemplateSelector) {
        for (Collection delTemplateGroup : fileSetDelTemplateSelector.delTemplateNameToValues().asMap().values()) {
            TemplateMetadata firstDelTemplate = null;
            for (TemplateMetadata delTemplate : delTemplateGroup) {
                if (firstDelTemplate == null) {
                    firstDelTemplate = delTemplate;
                }
                if (delTemplate.getSoyFileKind() != SoyFileKind.SRC) continue;
                firstDelTemplate = delTemplate;
                break;
            }
            if (firstDelTemplate == null) continue;
            Set<TemplateType.Parameter> firstRequiredParamSet = CheckDelegatesPass.getRequiredParamSet(firstDelTemplate);
            SanitizedContentKind firstContentKind = firstDelTemplate.getTemplateType().getContentKind().getSanitizedContentKind();
            boolean firstStrictHtml = firstDelTemplate.getTemplateType().isStrictHtml() && firstContentKind.isHtml();
            for (TemplateMetadata delTemplate : delTemplateGroup) {
                if (firstDelTemplate == delTemplate) continue;
                Set<TemplateType.Parameter> currRequiredParamSet = CheckDelegatesPass.getRequiredParamSet(delTemplate);
                if (!(CheckDelegatesPass.paramSetsEqual(currRequiredParamSet, firstRequiredParamSet) || delTemplate.getTemplateType().isModifiable() || delTemplate.getTemplateType().isModifying())) {
                    ImmutableList<TemplateType.Parameter> firstParamList = firstDelTemplate.getTemplateType().getParameters();
                    ImmutableList<TemplateType.Parameter> currParamList = delTemplate.getTemplateType().getParameters();
                    Set<TemplateType.Parameter> missingParamSet = CheckDelegatesPass.getRequiredParamsDifference(firstParamList, currParamList);
                    Set<TemplateType.Parameter> unexpectedParamSet = CheckDelegatesPass.getRequiredParamsDifference(currParamList, firstParamList);
                    this.errorReporter.report(delTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS, delTemplate.getDelTemplateName(), firstDelTemplate.getSourceLocation().toString(), CheckDelegatesPass.getInconsistentParamMessage(missingParamSet, unexpectedParamSet));
                }
                if (delTemplate.getTemplateType().getContentKind().getSanitizedContentKind() != firstContentKind) {
                    this.errorReporter.report(firstDelTemplate.getSourceLocation(), STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND, String.valueOf((Object)delTemplate.getTemplateType().getContentKind().getSanitizedContentKind()), String.valueOf((Object)firstContentKind), delTemplate.getSourceLocation().toString());
                }
                if (delTemplate.getTemplateType().isStrictHtml() == firstStrictHtml) continue;
                this.errorReporter.report(firstDelTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE, delTemplate.getDelTemplateName(), delTemplate.getSourceLocation().toString());
            }
            TemplateMetadata defaultTemplate = this.getDefault(delTemplateGroup);
            if (defaultTemplate == null || !defaultTemplate.getTemplateType().isModifiable() || !defaultTemplate.getTemplateType().getLegacyDeltemplateNamespace().isEmpty()) continue;
            for (TemplateMetadata template : delTemplateGroup) {
                if (template == defaultTemplate || template.getTemplateType().isModifying()) continue;
                this.errorReporter.report(template.getSourceLocation(), CANNOT_DELTEMPLATE_WITHOUT_LEGACY_NAMESPACE, new Object[0]);
            }
        }
    }

    private static boolean paramSetsEqual(Set<TemplateType.Parameter> s1, Set<TemplateType.Parameter> s2) {
        return s1.equals(s2);
    }

    private static Set<TemplateType.Parameter> getRequiredParamSet(TemplateMetadata delTemplate) {
        return delTemplate.getTemplateType().getParameters().stream().filter(TemplateType.Parameter::isRequired).map(TemplateType.Parameter::toComparable).collect(Collectors.toSet());
    }

    private void checkTemplateLiteralNode(TemplateLiteralNode node, @Nullable String currModName, String currTemplateNameForUserMsgs) {
        String calleeModName;
        String calleeName = node.getResolvedName();
        TemplateMetadata callee = this.templateRegistryFull.get().getBasicTemplateOrElement(calleeName);
        if (callee != null && (calleeModName = callee.getModName()) != null && !calleeModName.equals(currModName)) {
            this.errorReporter.report(node.getSourceLocation(), CROSS_PACKAGE_DELCALL, currTemplateNameForUserMsgs, callee.getTemplateName());
        }
    }

    @Nullable
    private TemplateMetadata getDefault(Iterable<TemplateMetadata> templates) {
        for (TemplateMetadata callee : templates) {
            if (callee.getModName() != null || !Strings.isNullOrEmpty((String)callee.getDelTemplateVariant())) continue;
            return callee;
        }
        return null;
    }

    private void checkCallDelegateNode(CallDelegateNode node, LocalVariablesNodeVisitor.LocalVariables localVariables, DelTemplateSelector<TemplateMetadata> fileSetDelTemplateSelector) {
        VarDefn collision;
        String delCalleeName = node.getDelCalleeName();
        TemplateMetadata defaultTemplate = this.getDefault((Iterable<TemplateMetadata>)fileSetDelTemplateSelector.delTemplateNameToValues().get((Object)delCalleeName));
        if (defaultTemplate != null && defaultTemplate.getTemplateType().isModifiable()) {
            if (defaultTemplate.getTemplateType().getLegacyDeltemplateNamespace().equals(delCalleeName)) {
                return;
            }
            this.errorReporter.report(node.getSourceLocation(), CANNOT_DELCALL_WITHOUT_LEGACY_NAMESPACE, new Object[0]);
        }
        if ((collision = localVariables.lookup(delCalleeName)) == null) {
            return;
        }
        if (collision.kind() == VarDefn.Kind.TEMPLATE || collision.kind() == VarDefn.Kind.IMPORT_VAR && collision.hasType() && collision.type().getKind() == SoyType.Kind.TEMPLATE_TYPE) {
            this.errorReporter.report(node.getSourceLocation(), DELCALL_TO_BASIC_TEMPLATE, collision.nameLocation().toLineColumnString());
        }
    }

    private static String getInconsistentParamMessage(Set<TemplateType.Parameter> missingParamSet, Set<TemplateType.Parameter> unexpectedParamSet) {
        StringBuilder message = new StringBuilder();
        if (!missingParamSet.isEmpty()) {
            message.append(String.format("\n  Missing params: %s", CheckDelegatesPass.formatParamSet(missingParamSet)));
        }
        if (!unexpectedParamSet.isEmpty()) {
            message.append(String.format("\n  Unexpected params: %s", CheckDelegatesPass.formatParamSet(unexpectedParamSet)));
        }
        return message.toString();
    }

    private static Set<String> formatParamSet(Set<TemplateType.Parameter> paramSet) {
        return paramSet.stream().map(param -> {
            String formattedParam = param.getName() + ": " + String.valueOf(param.getType());
            formattedParam = formattedParam + (param.isRequired() ? "" : " (optional)");
            return formattedParam;
        }).collect(Collectors.toSet());
    }

    private static Set<TemplateType.Parameter> getRequiredParamsDifference(List<TemplateType.Parameter> paramList1, List<TemplateType.Parameter> paramList2) {
        Map nameToParamMap = (Map)paramList2.stream().map(TemplateType.Parameter::toComparable).collect(ImmutableMap.toImmutableMap(TemplateType.Parameter::getName, param -> param));
        return paramList1.stream().filter(param -> {
            String paramName = param.getName();
            if (!nameToParamMap.containsKey(paramName)) {
                return param.isRequired();
            }
            TemplateType.Parameter param2 = (TemplateType.Parameter)nameToParamMap.get(paramName);
            return !param.equals(param2) && (param.isRequired() || param2.isRequired());
        }).collect(Collectors.toSet());
    }
}

