/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.function.Supplier;

@RunAfter(value={SoyConformancePass.class})
final class CheckIndirectDepsPass
implements CompilerFileSetPass {
    private static final SoyErrorKind CALL_TO_INDIRECT_DEPENDENCY = SoyErrorKind.of("Import is satisfied only by indirect dependency {0}. Add it as a direct dependency.", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;
    private final SoyTypeRegistry registry;
    private final Supplier<FileSetMetadata> templateRegistryFull;

    public CheckIndirectDepsPass(ErrorReporter errorReporter, SoyTypeRegistry registry, Supplier<FileSetMetadata> templateRegistryFull) {
        this.errorReporter = errorReporter;
        this.registry = registry;
        this.templateRegistryFull = templateRegistryFull;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        sourceFiles.stream().flatMap(f -> f.getImports().stream()).filter(i -> i.getImportType() == ImportNode.ImportType.TEMPLATE || i.getImportType() == ImportNode.ImportType.PROTO).forEach(i -> {
            SoyFileKind calleeKind;
            SourceLogicalPath importPath = i.getSourceFilePath();
            String callerFilePath = i.getSourceLocation().getFilePath().path();
            String calleeFilePath = importPath.path();
            SoyFileKind soyFileKind = calleeKind = i.getImportType() == ImportNode.ImportType.TEMPLATE ? this.templateRegistryFull.get().getFile(importPath).getSoyFileKind() : this.registry.getProtoRegistry().getDepKind(importPath);
            if (calleeKind != SoyFileKind.INDIRECT_DEP) {
                return;
            }
            this.errorReporter.report(i.getPathSourceLocation(), CALL_TO_INDIRECT_DEPENDENCY, calleeFilePath);
        });
        return CompilerFileSetPass.Result.CONTINUE;
    }
}

