/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateType;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@RunAfter(value={ResolveExpressionTypesPass.class})
final class CheckModifiableTemplatesPass
implements CompilerFilePass {
    private static final SoyErrorKind MODIFIES_WITHOUT_MODNAME = SoyErrorKind.of("\"modifies\" can only be used in a file with a '{'modname'}' command, unless it is used on a variant template. If this is a non-variant template, did you forget to add a '{'modname'}'? Or did you forget to mark this template as a variant?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MODIFIABLE_WITH_MODNAME = SoyErrorKind.of("\"modifiable\" templates cannot be placed in files with a '{'modname'}' command.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_SIGNATURE = SoyErrorKind.of("Template with signature {0} cannot be modified by template with incompatible signature {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_VARIANT_TYPE = SoyErrorKind.of("Expected variant of type {0}, found type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MODDING_MULTIPLE_FILES = SoyErrorKind.of("A single Soy file can only modify templates from a single external namespace. Namespaces: {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNRESOLVED_MODIFIES_EXPR = SoyErrorKind.of("The \"modifies\" expression could not be statically resolved to a valid template literal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MODIFIES_NON_MODIFIABLE = SoyErrorKind.of("Template in \"modifies\" expression must have `modifiable=\"true\"` set.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckModifiableTemplatesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        TreeSet<String> modifiedNamespaces = new TreeSet<String>();
        for (TemplateNode templateNode : file.getTemplates()) {
            if (!(templateNode instanceof TemplateBasicNode)) continue;
            TemplateBasicNode templateBasicNode = (TemplateBasicNode)templateNode;
            if (templateBasicNode.isModifiable() && file.getModName() != null) {
                this.errorReporter.report(templateNode.getSourceLocation(), MODIFIABLE_WITH_MODNAME, new Object[0]);
            }
            if (templateBasicNode.getModifiesExpr() != null && templateBasicNode.getVariantExpr() == null && file.getModName() == null) {
                this.errorReporter.report(templateNode.getSourceLocation(), MODIFIES_WITHOUT_MODNAME, new Object[0]);
            }
            this.validateModifiesAttribute(templateBasicNode, file, modifiedNamespaces);
            this.validateVariantExpr(templateBasicNode);
        }
    }

    private void validateModifiesAttribute(TemplateBasicNode templateBasicNode, SoyFileNode file, Set<String> modifiedNamespaces) {
        if (templateBasicNode.getModifiesExpr() == null) {
            return;
        }
        if (!(templateBasicNode.getModifiesExpr().getRoot() instanceof TemplateLiteralNode)) {
            this.errorReporter.report(templateBasicNode.getModifiesExpr().getSourceLocation(), UNRESOLVED_MODIFIES_EXPR, new Object[0]);
            return;
        }
        TemplateType baseType = (TemplateType)templateBasicNode.getModifiesExpr().getRoot().getType();
        if (!baseType.isModifiable()) {
            this.errorReporter.report(templateBasicNode.getModifiesExpr().getSourceLocation(), MODIFIES_NON_MODIFIABLE, new Object[0]);
            return;
        }
        TemplateType overrideType = TemplateMetadata.buildTemplateType(templateBasicNode);
        if (!CheckModifiableTemplatesPass.mayOverride(baseType, overrideType)) {
            this.errorReporter.report(templateBasicNode.getSourceLocation(), INCOMPATIBLE_SIGNATURE, baseType, overrideType);
        }
        this.validateSingleFileIsModded(templateBasicNode, file, modifiedNamespaces);
    }

    private static boolean mayOverride(TemplateType baseType, TemplateType overrideType) {
        if (!baseType.getContentKind().isAssignableFrom(overrideType.getContentKind())) {
            return false;
        }
        for (Map.Entry entry : baseType.getParameterMap().entrySet()) {
            if (!((TemplateType.Parameter)entry.getValue()).isRequired() || overrideType.getParameter((String)entry.getKey()) != null) continue;
            return false;
        }
        for (TemplateType.Parameter overrideParam : overrideType.getParameters()) {
            TemplateType.Parameter baseParam = baseType.getParameter(overrideParam.getName());
            if (baseParam == null) {
                return false;
            }
            if (!baseParam.isRequired() && overrideParam.isRequired()) {
                return false;
            }
            if (overrideParam.getCheckedType().isAssignableFromStrict(baseParam.getCheckedType())) continue;
            return false;
        }
        return true;
    }

    private void validateVariantExpr(TemplateBasicNode templateBasicNode) {
        if (templateBasicNode.getVariantExpr() == null) {
            return;
        }
        TemplateType modifiedTemplateType = (TemplateType)templateBasicNode.getModifiesExpr().getRoot().getType();
        SoyType variantType = templateBasicNode.getVariantExpr().getRoot().getType();
        if (!modifiedTemplateType.getUseVariantType().isAssignableFromStrict(variantType)) {
            this.errorReporter.report(templateBasicNode.getVariantExpr().getSourceLocation(), BAD_VARIANT_TYPE, modifiedTemplateType.getUseVariantType(), variantType);
        }
    }

    private void validateSingleFileIsModded(TemplateBasicNode templateBasicNode, SoyFileNode file, Set<String> modifiedNamespaces) {
        Preconditions.checkNotNull((Object)templateBasicNode.getModifiesExpr());
        Preconditions.checkState((boolean)(templateBasicNode.getModifiesExpr().getRoot() instanceof TemplateLiteralNode));
        TemplateLiteralNode literal = (TemplateLiteralNode)templateBasicNode.getModifiesExpr().getRoot();
        String namespace = literal.getResolvedName().substring(0, literal.getResolvedName().lastIndexOf("."));
        if (!namespace.equals(file.getNamespace())) {
            modifiedNamespaces.add(namespace);
            if (modifiedNamespaces.size() > 1) {
                this.errorReporter.report(templateBasicNode.getModifiesExpr().getSourceLocation(), MODDING_MULTIPLE_FILES, Joiner.on((String)", ").join(modifiedNamespaces));
            }
        }
    }
}

