/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.basetree.Copyable;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RuntimeTypeCoercion;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@RunAfter(value={FinalizeTemplateRegistryPass.class})
final class CheckTemplateCallsPass
implements CompilerFileSetPass {
    static final SoyErrorKind ARGUMENT_TYPE_MISMATCH = SoyErrorKind.of("Type mismatch on param {0}: expected: {1}, actual: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_PARAM = SoyErrorKind.of("Duplicate param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSES_UNUSED_PARAM = SoyErrorKind.of("''{0}'' is not a declared parameter of {1} or any indirect callee.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NO_DEFAULT_DELTEMPLATE = SoyErrorKind.of("No default deltemplate found for {0}. Please add a default deltemplate, even if it is empty.\nSee go/soy/reference/delegate-templates#basic-structure.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_IMPORT_DEFAULT_DELTEMPLATE = SoyErrorKind.of("Delcall without without import to file containing default deltemplate ''{0}''. Add: import * as unused{1} from ''{2}'';\nSee go/soy/reference/delegate-templates#basic-structure.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_USEVARIANTTYPE = SoyErrorKind.of("Cannot specify \"variant\" unless the callee specifies \"usevarianttype\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_VARIANT_TYPE = SoyErrorKind.of("Expected variant of type {0}, found type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_PARAM = SoyErrorKind.of("Call missing required {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRICT_HTML = SoyErrorKind.of("Found call to non stricthtml template. Strict HTML template can only call other strict HTML templates from an HTML context.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CAN_ONLY_CALL_TEMPLATE_TYPES = SoyErrorKind.of("'{'call'}' is only valid on template types, but found type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CANNOT_CALL_MIXED_CONTENT_TYPE = SoyErrorKind.of("Cannot call expressions of different content types; found {0} and {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CANNOT_CALL_MODIFYING_TEMPLATE_DIRECTLY = SoyErrorKind.of("Cannot call modifying templates directly. Call the main modifiable template instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CAN_OMIT_KIND_ONLY_FOR_SINGLE_CALL = SoyErrorKind.of("The ''kind'' attribute can be omitted only if the param contains a single call command.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_DATA_EXPR = SoyErrorKind.of("''data='' should be a record type, found ''{0}''.", SoyErrorKind.StyleAllowance.NO_CAPS);
    private final ErrorReporter errorReporter;
    private final boolean rewriteShortFormCalls;
    private final Supplier<FileSetMetadata> templateRegistryFull;
    private static final ImmutableSet<String> DEFAULT_DELTEMPLATE_PASSLIST = ImmutableSet.of();

    CheckTemplateCallsPass(ErrorReporter errorReporter, boolean rewriteShortFormCalls, Supplier<FileSetMetadata> templateRegistryFull) {
        this.errorReporter = errorReporter;
        this.rewriteShortFormCalls = rewriteShortFormCalls;
        this.templateRegistryFull = templateRegistryFull;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        CheckCallsHelper helper = new CheckCallsHelper(this.templateRegistryFull.get());
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getTemplates()) {
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallBasicNode.class)) {
                    helper.checkCall(template, (CallBasicNode)callNode);
                }
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallDelegateNode.class)) {
                    helper.checkCall(file, template, (CallDelegateNode)callNode, file.getFilePath().path());
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private static final class TemplateParamTypes {
        final Multimap<String, SoyType> params = HashMultimap.create();
        final Set<String> indirectParamNames = new HashSet<String>();

        private TemplateParamTypes() {
        }

        boolean isIndirect(String paramName) {
            return this.indirectParamNames.contains(paramName);
        }
    }

    private final class CheckCallsHelper {
        private final FileSetMetadata fileSetMetadata;
        private final Map<TemplateType, TemplateParamTypes> paramTypesMap = new HashMap<TemplateType, TemplateParamTypes>();

        CheckCallsHelper(FileSetMetadata registry) {
            this.fileSetMetadata = registry;
        }

        void checkCall(TemplateNode callerTemplate, CallBasicNode node) {
            SoyType calleeType = node.getCalleeExpr().getType();
            if (calleeType.getKind() == SoyType.Kind.TEMPLATE) {
                this.checkCall(callerTemplate, node, (TemplateType)calleeType);
            } else if (calleeType.getKind() == SoyType.Kind.UNION) {
                TemplateContentKind templateContentKind = null;
                for (SoyType member : ((UnionType)calleeType).getMembers()) {
                    if (member.getKind() == SoyType.Kind.TEMPLATE) {
                        TemplateType templateType = (TemplateType)member;
                        if (templateContentKind == null) {
                            templateContentKind = templateType.getContentKind();
                        } else if (!templateType.getContentKind().equals(templateContentKind)) {
                            CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CANNOT_CALL_MIXED_CONTENT_TYPE, templateContentKind, templateType.getContentKind());
                        }
                        this.checkCall(callerTemplate, node, templateType);
                        continue;
                    }
                    CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CAN_ONLY_CALL_TEMPLATE_TYPES, calleeType);
                    GlobalNode.replaceExprWithError(node.getCalleeExpr().getChild(0));
                }
            } else if (calleeType.getKind() != SoyType.Kind.UNKNOWN) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CAN_ONLY_CALL_TEMPLATE_TYPES, calleeType);
                GlobalNode.replaceExprWithError(node.getCalleeExpr().getChild(0));
            }
        }

        void checkCall(TemplateNode callerTemplate, CallBasicNode node, TemplateType calleeType) {
            this.checkCallParamNames(node, calleeType);
            this.checkPassesUnusedParams(node, calleeType);
            this.checkStrictHtml(callerTemplate, node, calleeType);
            this.checkCallParamTypes(callerTemplate, node, calleeType);
            this.checkVariant(node, calleeType);
            if (calleeType.isModifying()) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CANNOT_CALL_MODIFYING_TEMPLATE_DIRECTLY, new Object[0]);
            }
        }

        void checkCall(SoyFileNode file, TemplateNode callerTemplate, CallDelegateNode node, String callerFilename) {
            ImmutableList potentialCallees = this.fileSetMetadata.getDelTemplateSelector().delTemplateNameToValues().get((Object)node.getDelCalleeName());
            for (TemplateMetadata delTemplate2 : potentialCallees) {
                TemplateType delTemplateType = delTemplate2.getTemplateType();
                this.checkCallParamTypes(callerTemplate, node, delTemplateType);
                this.checkCallParamNames(node, delTemplateType);
            }
            if (this.shouldEnforceDefaultDeltemplate(node.getDelCalleeName())) {
                ImmutableList defaultImpl = (ImmutableList)potentialCallees.stream().filter(delTemplate -> delTemplate.getModName() == null && Strings.isNullOrEmpty((String)delTemplate.getDelTemplateVariant())).collect(ImmutableList.toImmutableList());
                if (defaultImpl.isEmpty()) {
                    CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), NO_DEFAULT_DELTEMPLATE, node.getDelCalleeName());
                } else {
                    SourceFilePath defaultLocation = ((TemplateMetadata)defaultImpl.get(0)).getSourceLocation().getFilePath();
                    if (!defaultLocation.equals(file.getSourceLocation().getFilePath()) && SoyTreeUtils.getAllNodesOfType(file, ImportNode.class).stream().noneMatch(imp -> imp.getSourceFilePath().equals(defaultLocation.asLogicalPath()))) {
                        CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), NO_IMPORT_DEFAULT_DELTEMPLATE, node.getDelCalleeName(), CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, defaultLocation.fileName().replaceAll(".soy$", "")), defaultLocation.path());
                    }
                }
            }
            if (!potentialCallees.isEmpty()) {
                this.checkStrictHtml(callerTemplate, node, ((TemplateMetadata)potentialCallees.get(0)).getTemplateType());
            }
        }

        boolean shouldEnforceDefaultDeltemplate(String delCalleeName) {
            return !DEFAULT_DELTEMPLATE_PASSLIST.contains((Object)delCalleeName);
        }

        private void checkCallParamTypes(TemplateNode callerTemplate, CallNode call, TemplateType callee) {
            Collection declaredParamTypes;
            String paramName;
            TemplateParamTypes calleeParamTypes = this.getTemplateParamTypes(callee);
            HashSet<String> explicitParams = new HashSet<String>();
            for (Copyable<Node> callerParam : call.getChildren()) {
                SoyType argType;
                paramName = ((CallParamNode)callerParam).getKey().identifier();
                declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_VALUE_NODE) {
                    CallParamValueNode node = (CallParamValueNode)callerParam;
                    argType = RuntimeTypeCoercion.maybeCoerceType(node.getExpr().getRoot(), declaredParamTypes);
                } else if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_CONTENT_NODE) {
                    CallParamContentNode callParamContentNode = (CallParamContentNode)callerParam;
                    if (!callParamContentNode.isImplicitContentKind()) {
                        argType = SanitizedType.getTypeForContentKind(callParamContentNode.getContentKind());
                    } else {
                        if (callParamContentNode.numChildren() != 1 || !(callParamContentNode.getChild(0) instanceof CallBasicNode)) {
                            if (CheckTemplateCallsPass.this.rewriteShortFormCalls) {
                                CheckTemplateCallsPass.this.errorReporter.report(callParamContentNode.getSourceLocation(), CAN_OMIT_KIND_ONLY_FOR_SINGLE_CALL, new Object[0]);
                            }
                            callParamContentNode.setContentKind(SanitizedContentKind.HTML);
                            continue;
                        }
                        CallBasicNode callNode = (CallBasicNode)callParamContentNode.getChild(0);
                        TemplateType templateType = (TemplateType)callNode.getCalleeExpr().getType();
                        callParamContentNode.setContentKind(templateType.getContentKind().getSanitizedContentKind());
                        argType = SanitizedType.getTypeForContentKind(templateType.getContentKind().getSanitizedContentKind());
                    }
                } else {
                    throw new AssertionError();
                }
                for (SoyType formalType : declaredParamTypes) {
                    this.checkArgumentAgainstParamType(((AbstractSoyNode)callerParam).getSourceLocation(), paramName, argType, formalType, calleeParamTypes);
                }
                explicitParams.add(paramName);
            }
            if (call.isPassingData()) {
                if (call.isPassingAllData()) {
                    for (Copyable<Node> callerParam : callerTemplate.getParams()) {
                        paramName = ((AbstractVarDefn)((Object)callerParam)).name();
                        if (explicitParams.contains(paramName)) continue;
                        declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                        for (SoyType formalType : declaredParamTypes) {
                            this.checkArgumentAgainstParamType(call.getSourceLocation(), paramName, ((AbstractVarDefn)((Object)callerParam)).type(), formalType, calleeParamTypes);
                        }
                    }
                } else {
                    ExprRootNode dataExpr = call.getDataExpr();
                    if (!SoyTypes.isKindOrUnionOfKind(dataExpr.getType(), SoyType.Kind.RECORD) && dataExpr.getType().getKind() != SoyType.Kind.UNKNOWN && dataExpr.getType().getKind() != SoyType.Kind.ANY) {
                        CheckTemplateCallsPass.this.errorReporter.report(dataExpr.getSourceLocation(), INVALID_DATA_EXPR, dataExpr.getType());
                    }
                }
            }
        }

        private void checkArgumentAgainstParamType(SourceLocation location, String paramName, SoyType argType, SoyType formalType, TemplateParamTypes calleeParams) {
            if (!formalType.isAssignableFromLoose(argType)) {
                if (calleeParams.isIndirect(paramName) && formalType.isAssignableFromLoose(SoyTypes.tryRemoveNullish(argType))) {
                    return;
                }
                CheckTemplateCallsPass.this.errorReporter.report(location, ARGUMENT_TYPE_MISMATCH, paramName, formalType, argType);
            }
        }

        private TemplateParamTypes getTemplateParamTypes(TemplateType callee) {
            return this.paramTypesMap.computeIfAbsent(callee, this::computeTemplateParamTypes);
        }

        private TemplateParamTypes computeTemplateParamTypes(TemplateType callee) {
            TemplateParamTypes paramTypes = new TemplateParamTypes();
            for (TemplateType.Parameter param : callee.getParameters()) {
                paramTypes.params.put((Object)param.getName(), (Object)param.getCheckedType());
            }
            IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(callee);
            for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                if (paramTypes.params.containsKey((Object)indirectParamName)) continue;
                paramTypes.params.putAll((Object)indirectParamName, (Iterable)ipi.indirectParamTypes.get((Object)indirectParamName));
                paramTypes.indirectParamNames.add(indirectParamName);
            }
            return paramTypes;
        }

        private void checkStrictHtml(TemplateNode callerTemplate, CallNode caller, TemplateType callee) {
            if (callerTemplate.isStrictHtml() && caller.getIsPcData() && callee.getContentKind().getSanitizedContentKind().isHtml() && !callee.isStrictHtml()) {
                CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), STRICT_HTML, new Object[0]);
            }
        }

        private void checkCallParamNames(CallNode caller, TemplateType callee) {
            HashSet callerParamKeys = Sets.newHashSet();
            for (CallParamNode callerParam : caller.getChildren()) {
                boolean isUnique = callerParamKeys.add(callerParam.getKey().identifier());
                if (isUnique) continue;
                CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), DUPLICATE_PARAM, callerParam.getKey().identifier());
            }
            if (!caller.isPassingData()) {
                ArrayList missingParamKeys = Lists.newArrayListWithCapacity((int)2);
                for (TemplateType.Parameter calleeParam : callee.getParameters()) {
                    if (!calleeParam.isRequired() || callerParamKeys.contains(calleeParam.getName())) continue;
                    missingParamKeys.add(calleeParam.getName());
                }
                if (!missingParamKeys.isEmpty()) {
                    String errorMsgEnd = missingParamKeys.size() == 1 ? "param '" + (String)missingParamKeys.get(0) + "'" : "params " + String.valueOf(missingParamKeys);
                    CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), MISSING_PARAM, errorMsgEnd);
                }
            }
        }

        private void checkPassesUnusedParams(CallNode caller, TemplateType callee) {
            if (caller.numChildren() == 0) {
                return;
            }
            HashSet paramNames = Sets.newHashSet();
            for (TemplateType.Parameter param : callee.getParameters()) {
                paramNames.add(param.getName());
            }
            IndirectParamsCalculator.IndirectParamsInfo ipi = null;
            for (CallParamNode callerParam : caller.getChildren()) {
                String paramName = callerParam.getKey().identifier();
                if (paramNames.contains(paramName)) continue;
                if (ipi == null) {
                    ipi = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(callee);
                    if (ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) {
                        return;
                    }
                }
                if (paramName.equals("extraRootElementAttributes") && callee.getAllowExtraAttributes()) {
                    return;
                }
                if (ipi.indirectParams.containsKey((Object)paramName)) continue;
                ImmutableSet allParams = ImmutableSet.builder().addAll((Iterable)paramNames).addAll((Iterable)ipi.indirectParams.keySet()).build();
                CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), PASSES_UNUSED_PARAM, paramName, callee.getIdentifierForDebugging(), SoyErrors.getDidYouMeanMessage((Iterable<String>)allParams, paramName));
            }
        }

        private void checkVariant(CallBasicNode node, TemplateType calleeType) {
            if (node.getVariantExpr() == null) {
                return;
            }
            if (calleeType.getUseVariantType().isNullOrUndefined()) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), NO_USEVARIANTTYPE, new Object[0]);
            } else if (!SoyTypes.makeNullish(calleeType.getUseVariantType()).isAssignableFromStrict(node.getVariantExpr().getType())) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getVariantExpr().getSourceLocation(), BAD_VARIANT_TYPE, calleeType.getUseVariantType(), node.getVariantExpr().getType());
            }
        }
    }
}

