/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.MoreCallValidationsPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;

@RunAfter(value={ResolveExpressionTypesPass.class, MoreCallValidationsPass.class})
final class CheckValidVarrefsPass
implements CompilerFilePass {
    private static final ImmutableSet<SoyType.Kind> BAD_SOY_TYPE_KINDS = ImmutableSet.of((Object)((Object)SoyType.Kind.TEMPLATE_MODULE), (Object)((Object)SoyType.Kind.PROTO_ENUM_TYPE), (Object)((Object)SoyType.Kind.PROTO_MODULE));
    private static final SoyErrorKind ILLEGAL_TYPE_OF_VARIABLE = SoyErrorKind.of("Illegal use of symbol ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckValidVarrefsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator idGenerator) {
        SoyTreeUtils.allNodesOfType(file, VarRefNode.class).forEach(this::checkVarRef);
    }

    private void checkVarRef(VarRefNode varRef) {
        ExprNode.ParentExprNode parent;
        VarDefn defn = varRef.getDefnDecl();
        if (defn != null && defn.hasType() && BAD_SOY_TYPE_KINDS.contains((Object)defn.type().getKind())) {
            this.errorReporter.report(varRef.getSourceLocation(), ILLEGAL_TYPE_OF_VARIABLE, varRef.toSourceString());
        }
        ExprNode.Kind parentKind = (parent = varRef.getParent()) != null ? parent.getKind() : null;
        SoyType.Kind exprKind = varRef.getType().getKind();
        if (!(exprKind != SoyType.Kind.FUNCTION || parentKind == ExprNode.Kind.FUNCTION_NODE && varRef.equals(parent.getChild(0)))) {
            this.errorReporter.report(varRef.getSourceLocation(), ILLEGAL_TYPE_OF_VARIABLE, varRef.toSourceString());
        } else if (exprKind == SoyType.Kind.PROTO_TYPE && parent != null && parentKind != ExprNode.Kind.FIELD_ACCESS_NODE && parentKind != ExprNode.Kind.FUNCTION_NODE) {
            this.errorReporter.report(varRef.getSourceLocation(), ILLEGAL_TYPE_OF_VARIABLE, varRef.toSourceString());
        } else if (exprKind == SoyType.Kind.PROTO_EXTENSION && parentKind != ExprNode.Kind.METHOD_CALL_NODE) {
            this.errorReporter.report(varRef.getSourceLocation(), ILLEGAL_TYPE_OF_VARIABLE, varRef.toSourceString());
        } else if (exprKind == SoyType.Kind.CSS_TYPE && parentKind != ExprNode.Kind.FIELD_ACCESS_NODE) {
            this.errorReporter.report(varRef.getSourceLocation(), ILLEGAL_TYPE_OF_VARIABLE, varRef.toSourceString());
        }
    }
}

