/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.AutoescaperPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.ast.NamedTypeNode;
import java.util.EnumMap;
import javax.annotation.Nullable;

@RunBefore(value={ResolveNamesPass.class, AutoescaperPass.class, ResolvePluginsPass.class})
public final class ContentSecurityPolicyNonceInjectionPass
implements CompilerFilePass {
    public static final String CSP_NONCE_VARIABLE_NAME = "csp_nonce";
    public static final String CSP_STYLE_NONCE_VARIABLE_NAME = "csp_style_nonce";
    public static final String FILTER_NAME = "|filterCspNonceValue";
    private static final SoyErrorKind IJ_CSP_NONCE_REFERENCE = SoyErrorKind.of("Found a use of the injected parameter ''{0}''. This parameter is reserved by the Soy compiler for Content Security Policy support.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MANUAL_NONCE = SoyErrorKind.of("Found a ''nonce'' attribute on a tag that is supported by Soy auto-nonce support. Instead of manually adding nonces you should just supply the ''csp_nonce'' injected parameter and rely on the Soy compiler to add nonce attributes.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    ContentSecurityPolicyNonceInjectionPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getTemplates()) {
            for (TemplateParam param : template.getAllParams()) {
                if (!param.isInjected() || !param.name().equals(CSP_NONCE_VARIABLE_NAME) && !param.name().equals(CSP_STYLE_NONCE_VARIABLE_NAME)) continue;
                this.errorReporter.report(param.nameLocation(), IJ_CSP_NONCE_REFERENCE, param.name());
            }
        }
        for (TemplateNode template : file.getTemplates()) {
            EnumMap<NonceType, TemplateParam> defns = new EnumMap<NonceType, TemplateParam>(NonceType.class);
            for (HtmlOpenTagNode openTag : SoyTreeUtils.getAllNodesOfType(template, HtmlOpenTagNode.class)) {
                NonceType nonceType = this.isTagNonceable(openTag);
                if (nonceType == NonceType.NONE) continue;
                HtmlAttributeNode manualNonce = openTag.getDirectAttributeNamed("nonce");
                if (manualNonce != null) {
                    this.errorReporter.report(manualNonce.getSourceLocation(), MANUAL_NONCE, new Object[0]);
                    continue;
                }
                TemplateParam defn = (TemplateParam)defns.get((Object)nonceType);
                if (defn == null) {
                    defn = this.createDefn(nonceType);
                    defns.put(nonceType, defn);
                    template.addParam(defn);
                }
                SourceLocation insertionLocation = openTag.getSourceLocation().getEndPoint().offsetCols(openTag.isSelfClosing() ? -2 : -1).asLocation(openTag.getSourceLocation().getFilePath());
                openTag.addChild(ContentSecurityPolicyNonceInjectionPass.createCspInjection(insertionLocation, nodeIdGen, defn));
            }
        }
    }

    private TemplateParam createDefn(NonceType nonceType) {
        return new TemplateParam(nonceType == NonceType.STYLE ? CSP_STYLE_NONCE_VARIABLE_NAME : CSP_NONCE_VARIABLE_NAME, SourceLocation.UNKNOWN, SourceLocation.UNKNOWN, NamedTypeNode.create(SourceLocation.UNKNOWN, "any"), true, false, true, "Created by ContentSecurityPolicyNonceInjectionPass.", null);
    }

    private NonceType isTagNonceable(HtmlOpenTagNode tag) {
        String name;
        TagName nameObj = tag.getTagName();
        if (!nameObj.isStatic()) {
            return NonceType.NONE;
        }
        switch (name = nameObj.getStaticTagNameAsLowerCase()) {
            case "script": {
                return NonceType.OTHER;
            }
            case "style": {
                return NonceType.STYLE;
            }
            case "link": {
                return this.isNonceableLink(tag);
            }
        }
        return NonceType.NONE;
    }

    @Nullable
    private String getStaticDirectAttributeValue(HtmlOpenTagNode tag, String attribute) {
        HtmlAttributeNode attr = tag.getDirectAttributeNamed(attribute);
        return attr == null ? null : attr.getStaticContent();
    }

    private NonceType isNonceableLink(HtmlOpenTagNode tag) {
        String relAttrValue = this.getStaticDirectAttributeValue(tag, "rel");
        if (relAttrValue == null) {
            return NonceType.NONE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)"import", (CharSequence)relAttrValue)) {
            return NonceType.OTHER;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)"stylesheet", (CharSequence)relAttrValue)) {
            return NonceType.STYLE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)"preload", (CharSequence)relAttrValue)) {
            String asAttrValue = this.getStaticDirectAttributeValue(tag, "as");
            if (asAttrValue == null) {
                return NonceType.NONE;
            }
            if (Ascii.equalsIgnoreCase((CharSequence)asAttrValue, (CharSequence)"style")) {
                return NonceType.STYLE;
            }
            if (Ascii.equalsIgnoreCase((CharSequence)asAttrValue, (CharSequence)"script")) {
                return NonceType.OTHER;
            }
        }
        return NonceType.NONE;
    }

    private static IfNode createCspInjection(SourceLocation insertionLocation, IdGenerator nodeIdGen, TemplateParam defn) {
        IfNode ifNode = new IfNode(nodeIdGen.genId(), insertionLocation);
        IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), insertionLocation, SourceLocation.UNKNOWN, "if", ContentSecurityPolicyNonceInjectionPass.referenceCspNonce(insertionLocation, defn));
        ifNode.addChild(ifCondNode);
        HtmlAttributeNode nonceAttribute = new HtmlAttributeNode(nodeIdGen.genId(), insertionLocation, insertionLocation.getBeginPoint());
        ifCondNode.addChild(nonceAttribute);
        nonceAttribute.addChild(new RawTextNode(nodeIdGen.genId(), "nonce", insertionLocation));
        HtmlAttributeValueNode attributeValue = new HtmlAttributeValueNode(nodeIdGen.genId(), insertionLocation, HtmlAttributeValueNode.Quotes.DOUBLE);
        nonceAttribute.addChild(attributeValue);
        PrintNode printNode = new PrintNode(nodeIdGen.genId(), insertionLocation, true, ContentSecurityPolicyNonceInjectionPass.referenceCspNonce(insertionLocation, defn), (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
        printNode.addChild(PrintDirectiveNode.createSyntheticNode(nodeIdGen.genId(), Identifier.create(FILTER_NAME, insertionLocation), insertionLocation));
        attributeValue.addChild(printNode);
        return ifNode;
    }

    private static VarRefNode referenceCspNonce(SourceLocation insertionLocation, TemplateParam defn) {
        return new VarRefNode("$" + defn.name(), insertionLocation, defn);
    }

    private static enum NonceType {
        NONE,
        STYLE,
        OTHER;

    }
}

