/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.UnknownType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class ProtoImportProcessor
implements ImportsPass.ImportProcessor {
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter errorReporter;
    private final boolean disableAllTypeChecking;
    private final ImmutableMap<SourceLogicalPath, Descriptors.FileDescriptor> pathToDescriptor;
    private Map<String, String> msgAndEnumLocalToFqn;
    private Map<String, String> extLocalToFqn;
    private static final SoyErrorKind PROTO_MODULE_IMPORT = SoyErrorKind.of("Module-level proto imports are forbidden. Import each message explicitly.", new SoyErrorKind.StyleAllowance[0]);

    ProtoImportProcessor(SoyTypeRegistry typeRegistry, ErrorReporter errorReporter, boolean disableAllTypeChecking) {
        this.typeRegistry = typeRegistry;
        this.errorReporter = errorReporter;
        this.disableAllTypeChecking = disableAllTypeChecking;
        this.pathToDescriptor = (ImmutableMap)typeRegistry.getProtoDescriptors().stream().collect(ImmutableMap.toImmutableMap(d -> SourceLogicalPath.create(d.getName()), d -> d));
    }

    @Override
    public boolean handlesPath(SourceLogicalPath path) {
        return this.pathToDescriptor.containsKey((Object)path);
    }

    @Override
    public ImmutableCollection<SourceLogicalPath> getAllPaths() {
        return this.pathToDescriptor.keySet();
    }

    @Override
    public void handle(SoyFileNode file, ImmutableCollection<ImportNode> imports) {
        this.msgAndEnumLocalToFqn = new HashMap<String, String>();
        this.extLocalToFqn = new HashMap<String, String>();
        for (ImportNode anImport : imports) {
            anImport.setImportType(ImportNode.ImportType.PROTO);
            if (anImport.isModuleImport()) {
                this.errorReporter.report(anImport.getSourceLocation(), PROTO_MODULE_IMPORT, new Object[0]);
                continue;
            }
            this.processImportedSymbols(anImport);
        }
        this.updateImportsContext(file);
    }

    @Override
    public void init(ImmutableList<SoyFileNode> sourceFiles) {
    }

    private void processImportedSymbols(ImportNode node) {
        if (this.disableAllTypeChecking) {
            return;
        }
        Descriptors.FileDescriptor fd = (Descriptors.FileDescriptor)this.pathToDescriptor.get((Object)node.getSourceFilePath());
        node.setModuleType(this.typeRegistry.getProtoImportType((Descriptors.GenericDescriptor)fd));
        ImmutableMap messages = (ImmutableMap)fd.getMessageTypes().stream().collect(ImmutableMap.toImmutableMap(Descriptors.Descriptor::getName, f -> f));
        ImmutableMap enums = (ImmutableMap)fd.getEnumTypes().stream().collect(ImmutableMap.toImmutableMap(Descriptors.EnumDescriptor::getName, f -> f));
        ImmutableMap extensions = (ImmutableMap)fd.getExtensions().stream().collect(ImmutableMap.toImmutableMap(Field::computeSoyName, f -> f));
        for (ImportedVar symbol : node.getIdentifiers()) {
            String name = symbol.getSymbol();
            String fullName = fd.getPackage().isEmpty() ? name : fd.getPackage() + "." + name;
            Descriptors.Descriptor messageDesc = (Descriptors.Descriptor)messages.get((Object)name);
            if (messageDesc != null) {
                ProtoImportProcessor.putDistinct(this.msgAndEnumLocalToFqn, symbol.name(), fullName);
                symbol.setType(this.typeRegistry.getProtoImportType((Descriptors.GenericDescriptor)messageDesc));
                continue;
            }
            Descriptors.EnumDescriptor enumDesc = (Descriptors.EnumDescriptor)enums.get((Object)name);
            if (enumDesc != null) {
                ProtoImportProcessor.putDistinct(this.msgAndEnumLocalToFqn, symbol.name(), fullName);
                symbol.setType(this.typeRegistry.getProtoImportType((Descriptors.GenericDescriptor)enumDesc));
                continue;
            }
            Descriptors.FieldDescriptor extDesc = (Descriptors.FieldDescriptor)extensions.get((Object)name);
            if (extDesc != null) {
                ProtoImportProcessor.putDistinct(this.extLocalToFqn, symbol.name(), fullName);
                symbol.setType(this.typeRegistry.getProtoImportType((Descriptors.GenericDescriptor)extDesc));
                continue;
            }
            symbol.setType(UnknownType.getInstance());
            ImportsPass.reportUnknownSymbolError(this.errorReporter, symbol.nameLocation(), name, node.getPath(), (Iterable<String>)Sets.union((Set)messages.keySet(), (Set)Sets.union((Set)enums.keySet(), (Set)extensions.keySet())));
        }
    }

    private static <K, V> void putDistinct(Map<K, V> into, K key, V value) {
        V old = into.put(key, value);
        if (old != null) {
            Preconditions.checkArgument((boolean)value.equals(old));
        }
    }

    void updateImportsContext(SoyFileNode file) {
        file.getImportsContext().setTypeRegistry(this.disableAllTypeChecking ? this.typeRegistry : new ImportsContext.ImportsTypeRegistry(this.typeRegistry, (ImmutableMap<String, String>)ImmutableMap.copyOf(this.msgAndEnumLocalToFqn), (ImmutableMap<String, String>)ImmutableMap.builder().putAll(this.msgAndEnumLocalToFqn).putAll(this.extLocalToFqn).build()));
    }
}

