/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.Metadata;
import com.google.template.soy.soytree.PartialFileMetadata;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.TemplateModuleImportType;
import com.google.template.soy.types.UnknownType;
import java.util.function.Supplier;

public final class TemplateImportProcessor
implements ImportsPass.ImportProcessor {
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> registryFromDeps;
    private PartialFileSetMetadata fileSetMetadata;
    private SoyTypeRegistry typeRegistry;

    TemplateImportProcessor(ErrorReporter errorReporter, Supplier<FileSetMetadata> registryFromDeps) {
        this.registryFromDeps = registryFromDeps;
        this.errorReporter = errorReporter;
    }

    @Override
    public void init(ImmutableList<SoyFileNode> sourceFiles) {
        this.fileSetMetadata = Metadata.partialMetadataForAst(this.registryFromDeps.get(), sourceFiles);
    }

    @Override
    public void handle(SoyFileNode file, ImmutableCollection<ImportNode> imports) {
        this.typeRegistry = file.getSoyTypeRegistry();
        for (ImportNode anImport : imports) {
            anImport.setImportType(ImportNode.ImportType.TEMPLATE);
            if (anImport.isModuleImport()) {
                this.processImportedModule(anImport);
                continue;
            }
            this.processImportedSymbols(anImport);
        }
    }

    private void processImportedSymbols(ImportNode node) {
        PartialFileMetadata fileMetadata = this.fileSetMetadata.getPartialFile(SourceLogicalPath.create(node.getPath()));
        node.setModuleType(this.buildModuleType(node));
        for (ImportedVar symbol : node.getIdentifiers()) {
            String name = symbol.getSymbol();
            boolean isTemplate = fileMetadata.hasTemplate(name);
            if (!(isTemplate || fileMetadata.hasConstant(name) || fileMetadata.hasExtern(name))) {
                ImportsPass.reportUnknownSymbolError(this.errorReporter, symbol.nameLocation(), name, node.getPath(), fileMetadata.getTemplateNames());
                symbol.setType(UnknownType.getInstance());
                continue;
            }
            if (!isTemplate) continue;
            symbol.setType(this.typeRegistry.intern(TemplateImportType.create(TemplateImportProcessor.templateFqn(fileMetadata, name))));
        }
    }

    private static String templateFqn(PartialFileMetadata file, String name) {
        String namespace = file.getNamespace();
        return namespace.isEmpty() ? name : namespace + "." + name;
    }

    private void processImportedModule(ImportNode node) {
        ((ImportedVar)Iterables.getOnlyElement(node.getIdentifiers())).setType(this.buildModuleType(node));
    }

    private TemplateModuleImportType buildModuleType(ImportNode node) {
        SourceLogicalPath path = SourceLogicalPath.create(node.getPath());
        PartialFileMetadata templatesPerFile = this.fileSetMetadata.getPartialFile(path);
        return this.typeRegistry.intern(TemplateModuleImportType.create(templatesPerFile.getNamespace(), path, (ImmutableSet<String>)ImmutableSet.copyOf(templatesPerFile.getConstantNames()), (ImmutableSet<String>)ImmutableSet.copyOf(templatesPerFile.getExternNames()), (ImmutableSet<String>)ImmutableSet.copyOf(templatesPerFile.getTemplateNames())));
    }

    @Override
    public boolean handlesPath(SourceLogicalPath path) {
        return this.fileSetMetadata.getPartialFile(path) != null;
    }

    @Override
    public ImmutableCollection<SourceLogicalPath> getAllPaths() {
        return (ImmutableCollection)this.fileSetMetadata.getAllPartialFiles().stream().map(f -> f.getPath().asLogicalPath()).collect(ImmutableSet.toImmutableSet());
    }
}

