/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.shared.ToggleRegistry;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.ToggleImportType;

final class ToggleImportProcessor
implements ImportsPass.ImportProcessor {
    private final ErrorReporter errorReporter;
    private final ToggleRegistry toggleRegistry;
    private static final SoyErrorKind TOGGLE_MODULE_IMPORT = SoyErrorKind.of("Module-level toggle imports are forbidden. Import individual toggles by name.", new SoyErrorKind.StyleAllowance[0]);

    ToggleImportProcessor(ToggleRegistry toggleRegistry, ErrorReporter errorReporter) {
        this.toggleRegistry = toggleRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    public boolean handlesPath(SourceLogicalPath path) {
        return this.toggleRegistry.getPaths().contains((Object)path);
    }

    public ImmutableSet<SourceLogicalPath> getAllPaths() {
        return this.toggleRegistry.getPaths();
    }

    @Override
    public void init(ImmutableList<SoyFileNode> sourceFiles) {
    }

    @Override
    public void handle(SoyFileNode file, ImmutableCollection<ImportNode> imports) {
        for (ImportNode importNode : imports) {
            importNode.setImportType(ImportNode.ImportType.TOGGLE);
            if (importNode.isModuleImport()) {
                this.errorReporter.report(importNode.getSourceLocation(), TOGGLE_MODULE_IMPORT, new Object[0]);
                continue;
            }
            this.processImportedSymbols(importNode);
        }
    }

    public void processImportedSymbols(ImportNode node) {
        for (ImportedVar symbol : node.getIdentifiers()) {
            String name = symbol.getSymbol();
            SourceLogicalPath path = node.getSourceFilePath();
            if (!this.toggleRegistry.getToggles(path).contains((Object)name)) {
                ImportsPass.reportUnknownSymbolError(this.errorReporter, symbol.nameLocation(), name, node.getPath(), this.toggleRegistry.getToggles(path));
            }
            ToggleImportType nodeType = ToggleImportType.create(name, path);
            symbol.setType(nodeType);
        }
    }
}

