/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNodes;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UndefinedType;
import java.util.LinkedHashMap;
import java.util.Map;

final class TypeNarrowingConditionVisitor {
    private final ExprEquivalence exprEquivalence;
    private final SoyTypeRegistry typeRegistry;
    Map<ExprEquivalence.Wrapper, SoyType> positiveTypeConstraints = new LinkedHashMap<ExprEquivalence.Wrapper, SoyType>();
    Map<ExprEquivalence.Wrapper, SoyType> negativeTypeConstraints = new LinkedHashMap<ExprEquivalence.Wrapper, SoyType>();

    public TypeNarrowingConditionVisitor(ExprEquivalence exprEquivalence, SoyTypeRegistry typeRegistry) {
        this.exprEquivalence = exprEquivalence;
        this.typeRegistry = typeRegistry;
    }

    public void ifTruthy(ExprNode node) {
        new TruthyVisitor().exec(node);
    }

    private void ifNullish(ExprNode node, NullishMode mode, boolean neq) {
        new NonNullishVisitor(neq, mode, true).exec(node);
    }

    public void ifNonNullish(ExprNode node) {
        new NonNullishVisitor(false, NullishMode.NULLISH, false).exec(node);
    }

    private TypeNarrowingConditionVisitor createTypeNarrowingConditionVisitor() {
        return new TypeNarrowingConditionVisitor(this.exprEquivalence, this.typeRegistry);
    }

    private static void computeConstraintUnionInto(Map<ExprEquivalence.Wrapper, SoyType> left, Map<ExprEquivalence.Wrapper, SoyType> right, Map<ExprEquivalence.Wrapper, SoyType> into) {
        Sets.union(left.keySet(), right.keySet()).forEach(key -> {
            SoyType lhsType = (SoyType)left.get(key);
            SoyType rhsType = (SoyType)right.get(key);
            SoyType stricter = lhsType == null ? rhsType : (rhsType == null ? lhsType : SoyTypes.computeStricterType(lhsType, rhsType).orElse(lhsType));
            into.put((ExprEquivalence.Wrapper)key, stricter);
        });
    }

    private void computeConstraintIntersectionInto(Map<ExprEquivalence.Wrapper, SoyType> left, Map<ExprEquivalence.Wrapper, SoyType> right, Map<ExprEquivalence.Wrapper, SoyType> into) {
        Sets.intersection(left.keySet(), right.keySet()).forEach(key -> {
            SoyType rhsType;
            SoyType originalType = key.get().getType();
            SoyType lhsType = (SoyType)left.get(key);
            SoyType lct = SoyTypes.computeLowestCommonType(this.typeRegistry, lhsType, rhsType = (SoyType)right.get(key));
            if (!lct.isNullOrUndefined()) {
                if (!SoyTypes.isUndefinable(originalType)) {
                    lct = SoyTypes.tryRemoveUndefined(lct);
                }
                if (!SoyTypes.isNullable(originalType)) {
                    lct = SoyTypes.tryRemoveNull(lct);
                }
            }
            into.put((ExprEquivalence.Wrapper)key, lct);
        });
    }

    private static boolean isNullishNonTransform(FunctionNode node) {
        Object soyFunction;
        return node.isResolved() && ((soyFunction = node.getSoyFunction()) == BuiltinFunction.UNDEFINED_TO_NULL || soyFunction == BuiltinFunction.UNDEFINED_TO_NULL_SSR || soyFunction == BuiltinFunction.CHECK_NOT_NULL);
    }

    private static boolean isTruthyNonTransform(FunctionNode node) {
        if (TypeNarrowingConditionVisitor.isNullishNonTransform(node)) {
            return true;
        }
        return node.hasStaticName() && "Boolean".equals(node.getFunctionName());
    }

    private final class TruthyVisitor
    extends AbstractExprNodeVisitor<Void> {
        private TruthyVisitor() {
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            ExprEquivalence.Wrapper wrapped = TypeNarrowingConditionVisitor.this.exprEquivalence.wrap(node);
            TypeNarrowingConditionVisitor.this.positiveTypeConstraints.put(wrapped, SoyTypes.tryRemoveNullish(node.getType()));
            TypeNarrowingConditionVisitor.this.negativeTypeConstraints.put(wrapped, node.getType());
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visit(node.getRoot());
            super.visitExprRootNode(node);
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (TypeNarrowingConditionVisitor.isTruthyNonTransform(node)) {
                this.visit(node.getParam(0));
                return;
            }
            if (node.getFunctionName().equals("hasContent") || node.getFunctionName().equals("isTruthyNonEmpty")) {
                TypeNarrowingConditionVisitor childVisitor = TypeNarrowingConditionVisitor.this.createTypeNarrowingConditionVisitor();
                childVisitor.ifTruthy(node.getChild(0));
                TypeNarrowingConditionVisitor.this.positiveTypeConstraints.putAll(childVisitor.positiveTypeConstraints);
            }
            this.visitExprNode(node);
        }

        @Override
        protected void visitAmpAmpOpNode(OperatorNodes.AmpAmpOpNode node) {
            this.processAnd(node);
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.processAnd(node);
        }

        private void processAnd(AbstractOperatorNode node) {
            Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = TypeNarrowingConditionVisitor.this.createTypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = TypeNarrowingConditionVisitor.this.createTypeNarrowingConditionVisitor();
            leftVisitor.ifTruthy(node.getChild(0));
            rightVisitor.ifTruthy(node.getChild(1));
            TypeNarrowingConditionVisitor.computeConstraintUnionInto(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints, TypeNarrowingConditionVisitor.this.positiveTypeConstraints);
            TypeNarrowingConditionVisitor.this.computeConstraintIntersectionInto(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints, TypeNarrowingConditionVisitor.this.negativeTypeConstraints);
        }

        @Override
        protected void visitBarBarOpNode(OperatorNodes.BarBarOpNode node) {
            this.processOr(node);
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            this.processOr(node);
        }

        private void processOr(AbstractOperatorNode node) {
            Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = TypeNarrowingConditionVisitor.this.createTypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = TypeNarrowingConditionVisitor.this.createTypeNarrowingConditionVisitor();
            leftVisitor.ifTruthy(node.getChild(0));
            rightVisitor.ifTruthy(node.getChild(1));
            TypeNarrowingConditionVisitor.this.computeConstraintIntersectionInto(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints, TypeNarrowingConditionVisitor.this.positiveTypeConstraints);
            TypeNarrowingConditionVisitor.computeConstraintUnionInto(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints, TypeNarrowingConditionVisitor.this.negativeTypeConstraints);
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            TypeNarrowingConditionVisitor childVisitor = TypeNarrowingConditionVisitor.this.createTypeNarrowingConditionVisitor();
            childVisitor.ifTruthy(node.getChild(0));
            TypeNarrowingConditionVisitor.this.positiveTypeConstraints.putAll(childVisitor.negativeTypeConstraints);
            TypeNarrowingConditionVisitor.this.negativeTypeConstraints.putAll(childVisitor.positiveTypeConstraints);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            if (ExprNodes.isNullishLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(0), NullishMode.NULLISH, false);
            } else if (ExprNodes.isNonNullishLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(0));
            }
            if (ExprNodes.isNullishLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(1), NullishMode.NULLISH, false);
            } else if (ExprNodes.isNonNullishLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(1));
            }
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            if (ExprNodes.isNullishLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(0), NullishMode.NULLISH, true);
            }
            if (ExprNodes.isNullishLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(1), NullishMode.NULLISH, true);
            }
        }

        @Override
        protected void visitTripleEqualOpNode(OperatorNodes.TripleEqualOpNode node) {
            if (ExprNodes.isNullishLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(0), NullishMode.forNode(node.getChild(1)), false);
            } else if (ExprNodes.isNonNullishLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(0));
            }
            if (ExprNodes.isNullishLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(1), NullishMode.forNode(node.getChild(0)), false);
            } else if (ExprNodes.isNonNullishLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(1));
            }
        }

        @Override
        protected void visitTripleNotEqualOpNode(OperatorNodes.TripleNotEqualOpNode node) {
            if (ExprNodes.isNullishLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(0), NullishMode.forNode(node.getChild(1)), true);
            } else if (ExprNodes.isNullishLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNullish(node.getChild(1), NullishMode.forNode(node.getChild(0)), true);
            }
        }

        @Override
        protected void visitNullSafeAccessNode(NullSafeAccessNode node) {
            for (ExprNode nullSafeBase : node.asNullSafeBaseList()) {
                TypeNarrowingConditionVisitor.this.positiveTypeConstraints.put(TypeNarrowingConditionVisitor.this.exprEquivalence.wrap(nullSafeBase), SoyTypes.tryRemoveNullish(nullSafeBase.getType()));
            }
            super.visitNullSafeAccessNode(node);
        }

        @Override
        protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(0));
            TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(1));
        }

        @Override
        protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(0));
            TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(1));
        }

        @Override
        protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            if (ExprNodes.isNonFalsyLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(0));
            } else if (ExprNodes.isNonFalsyLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(1));
            }
        }

        @Override
        protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            if (ExprNodes.isNonFalsyLiteral(node.getChild(1))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(0));
            } else if (ExprNodes.isNonFalsyLiteral(node.getChild(0))) {
                TypeNarrowingConditionVisitor.this.ifNonNullish(node.getChild(1));
            }
        }
    }

    private final class NonNullishVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final boolean neq;
        private final boolean nullish;
        private final NullishMode mode;

        public NonNullishVisitor(boolean neq, NullishMode mode, boolean nullish) {
            this.neq = neq;
            this.mode = mode;
            this.nullish = nullish;
        }

        private SoyType tryRemoveNullish(SoyType type) {
            switch (this.mode) {
                case NULLISH: {
                    return SoyTypes.tryRemoveNullish(type);
                }
                case NULL: {
                    return SoyTypes.tryRemoveNull(type);
                }
                case UNDEFINED: {
                    return SoyTypes.tryRemoveUndefined(type);
                }
            }
            throw new AssertionError();
        }

        private SoyType tryKeepNullish(SoyType type) {
            switch (this.mode) {
                case NULLISH: {
                    return SoyTypes.isNullish(type) ? SoyTypes.tryKeepNullish(type) : SoyTypes.NULL_OR_UNDEFINED;
                }
                case NULL: {
                    return NullType.getInstance();
                }
                case UNDEFINED: {
                    return UndefinedType.getInstance();
                }
            }
            throw new AssertionError();
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (TypeNarrowingConditionVisitor.isNullishNonTransform(node)) {
                this.visit(node.getParam(0));
                return;
            }
            this.visitExprNode(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            ExprEquivalence.Wrapper wrapped = TypeNarrowingConditionVisitor.this.exprEquivalence.wrap(node);
            if (this.nullish) {
                if (this.neq) {
                    TypeNarrowingConditionVisitor.this.negativeTypeConstraints.put(wrapped, this.tryKeepNullish(node.getType()));
                    TypeNarrowingConditionVisitor.this.positiveTypeConstraints.put(wrapped, this.tryRemoveNullish(node.getType()));
                } else {
                    TypeNarrowingConditionVisitor.this.positiveTypeConstraints.put(wrapped, this.tryKeepNullish(node.getType()));
                    TypeNarrowingConditionVisitor.this.negativeTypeConstraints.put(wrapped, this.tryRemoveNullish(node.getType()));
                }
            } else if (!this.neq) {
                TypeNarrowingConditionVisitor.this.positiveTypeConstraints.put(wrapped, this.tryRemoveNullish(node.getType()));
            }
        }

        @Override
        protected void visitNullSafeAccessNode(NullSafeAccessNode node) {
            boolean nonNullConstant;
            boolean bl = nonNullConstant = this.mode == NullishMode.NULL || !this.nullish;
            Map<ExprEquivalence.Wrapper, SoyType> chainConstraints = this.neq ? (nonNullConstant ? TypeNarrowingConditionVisitor.this.negativeTypeConstraints : TypeNarrowingConditionVisitor.this.positiveTypeConstraints) : (nonNullConstant ? TypeNarrowingConditionVisitor.this.positiveTypeConstraints : TypeNarrowingConditionVisitor.this.negativeTypeConstraints);
            ImmutableList<ExprNode> chain = node.asNullSafeBaseList();
            for (int i = 0; i < chain.size() - 1; ++i) {
                ExprNode nullSafeBase = (ExprNode)chain.get(i);
                chainConstraints.put(TypeNarrowingConditionVisitor.this.exprEquivalence.wrap(nullSafeBase), SoyTypes.tryRemoveNullish(nullSafeBase.getType()));
            }
            if (!chain.isEmpty()) {
                this.visitExprNode((ExprNode)Iterables.getLast(chain));
            }
            this.visitExprNode(node);
        }
    }

    static enum NullishMode {
        NULLISH,
        NULL,
        UNDEFINED;


        public static NullishMode forNode(ExprNode node) {
            switch (node.getKind()) {
                case NULL_NODE: {
                    return NULL;
                }
                case UNDEFINED_NODE: {
                    return UNDEFINED;
                }
            }
            throw new IllegalArgumentException(node.getKind().toString());
        }
    }
}

