/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TypeRegistries;
import com.google.template.soy.types.TypeRegistry;

final class ValidateAliasesPass
implements CompilerFilePass {
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_TYPE_NAME = SoyErrorKind.of("Alias ''{0}'' conflicts with a type of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    ValidateAliasesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        TypeRegistry registry = TypeRegistries.builtinTypeRegistry();
        for (AliasDeclaration alias : file.getAliasDeclarations()) {
            SoyType type = registry.getType(alias.alias().identifier());
            if (type == null || type.getKind() == SoyType.Kind.UNKNOWN || alias.namespace().identifier().equals(ValidateAliasesPass.getFqProtoName(type))) continue;
            this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_TYPE_NAME, alias.alias());
        }
    }

    private static String getFqProtoName(SoyType type) {
        if (type instanceof SoyProtoType) {
            return ((SoyProtoType)type).getDescriptor().getFullName();
        }
        if (type instanceof SoyProtoEnumType) {
            return ((SoyProtoEnumType)type).getDescriptor().getFullName();
        }
        return null;
    }
}

