/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.logging.LoggingConfigValidator;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.ProtoImportType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@RunAfter(value={ResolveExpressionTypesPass.class})
final class VeDefValidationPass
implements CompilerFileSetPass {
    private static final SoyErrorKind VE_DEF_OUTSIDE_CONST = SoyErrorKind.of("Visual elements defined with ve_def() must be assigned to a constant.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_VE_DEF_NAME = SoyErrorKind.of("The first argument to ve_def() must be an string literal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_VE_DEF_ID = SoyErrorKind.of("The second argument to ve_def() must be an integer literal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_VE_DEF_DATA_PROTO_TYPE = SoyErrorKind.of("The third argument to ve_def() must be proto type or 'null'.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_VE_DEF_METADATA = SoyErrorKind.of("The fourth argument to ve_def() must be an proto init expression of LoggableElementMetadata. All fields must be literals.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final ExprEquivalence exprEquivalence;
    private final CopyState copyState;

    VeDefValidationPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.exprEquivalence = new ExprEquivalence();
        this.copyState = new CopyState();
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        HashSet vedefsInConstNodes = new HashSet();
        ArrayList<LoggingConfigValidator.VisualElement> vedefs = new ArrayList<LoggingConfigValidator.VisualElement>();
        for (SoyFileNode file : sourceFiles) {
            SoyTreeUtils.allNodesOfType(file, ConstNode.class).forEach(c -> this.maybeAddVeDefFromConst((ConstNode)c, vedefsInConstNodes));
            SoyTreeUtils.allNodesOfType(file, FunctionNode.class).filter(VeDefValidationPass::isVeDef).forEach(func -> {
                if (!vedefsInConstNodes.contains(func)) {
                    this.errorReporter.report(func.getSourceLocation(), VE_DEF_OUTSIDE_CONST, new Object[0]);
                }
                this.buildVeDefAndValidate((FunctionNode)func, (List<LoggingConfigValidator.VisualElement>)vedefs);
            });
        }
        LoggingConfigValidator.validate(vedefs, this.errorReporter);
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void maybeAddVeDefFromConst(ConstNode constNode, Set<ExprNode> veDefsInConstNodes) {
        if (VeDefValidationPass.isVeDef(constNode.getExpr().getRoot())) {
            veDefsInConstNodes.add(constNode.getExpr().getRoot());
        }
    }

    private void buildVeDefAndValidate(FunctionNode func, List<LoggingConfigValidator.VisualElement> vedefs) {
        Optional<Object> staticMetadata;
        Optional<String> dataProtoType;
        if (func.numParams() < 2) {
            return;
        }
        if (!(func.getParam(0) instanceof StringNode)) {
            this.errorReporter.report(func.getParam(0).getSourceLocation(), BAD_VE_DEF_NAME, new Object[0]);
            return;
        }
        String veName = ((StringNode)func.getParam(0)).getValue();
        if (!(func.getParam(1) instanceof IntegerNode)) {
            this.errorReporter.report(func.getParam(1).getSourceLocation(), BAD_VE_DEF_ID, new Object[0]);
            return;
        }
        long id = ((IntegerNode)func.getParam(1)).getValue();
        if (func.numParams() < 3 || func.getParam(2) instanceof NullNode) {
            dataProtoType = Optional.empty();
        } else {
            if (!(func.getParam(2).getType() instanceof ProtoImportType)) {
                this.errorReporter.report(func.getParam(2).getSourceLocation(), BAD_VE_DEF_DATA_PROTO_TYPE, new Object[0]);
                return;
            }
            dataProtoType = Optional.of(func.getParam(2).getType().toString());
        }
        if (func.numParams() < 4) {
            staticMetadata = Optional.empty();
        } else {
            if (!func.getParam(3).getType().toString().equals("soy.LoggableElementMetadata")) {
                this.errorReporter.report(func.getParam(3).getSourceLocation(), BAD_VE_DEF_METADATA, new Object[0]);
                return;
            }
            staticMetadata = Optional.of(this.exprEquivalence.wrap(func.getParam(3).copy(this.copyState)));
        }
        vedefs.add(LoggingConfigValidator.VisualElement.create(veName, id, dataProtoType, staticMetadata, func.getSourceLocation()));
    }

    private static boolean isVeDef(ExprNode node) {
        if (!(node instanceof FunctionNode)) {
            return false;
        }
        FunctionNode functionNode = (FunctionNode)node;
        return functionNode.isResolved() && functionNode.getSoyFunction() == BuiltinFunction.VE_DEF;
    }
}

