/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.types.ast.FunctionTypeNode;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TemplateTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import com.google.template.soy.types.ast.UnionTypeNode;

final class LegacyObjectMapFinder
implements TypeNodeVisitor<Void> {
    private static final SoyErrorKind LEGACY_OBJECT_MAP_NOT_SUPPORTED = SoyErrorKind.of("legacy_object_map is not supported in pysrc. Use maps or records instead.", SoyErrorKind.StyleAllowance.NO_CAPS);
    private final ErrorReporter errorReporter;

    LegacyObjectMapFinder(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void visit(GenericTypeNode node) {
        switch (node.getResolvedType().getKind()) {
            case LEGACY_OBJECT_MAP: {
                this.errorReporter.report(node.sourceLocation(), LEGACY_OBJECT_MAP_NOT_SUPPORTED, new Object[0]);
            }
            case LIST: 
            case MAP: 
            case VE: {
                for (TypeNode child : node.arguments()) {
                    child.accept(this);
                }
                break;
            }
            case ELEMENT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected generic type: " + String.valueOf((Object)node.getResolvedType().getKind())));
            }
        }
        return null;
    }

    @Override
    public Void visit(UnionTypeNode node) {
        for (TypeNode child : node.candidates()) {
            child.accept(this);
        }
        return null;
    }

    @Override
    public Void visit(RecordTypeNode node) {
        for (RecordTypeNode.Property property : node.properties()) {
            property.type().accept(this);
        }
        return null;
    }

    @Override
    public Void visit(TemplateTypeNode node) {
        for (TemplateTypeNode.Parameter parameter : node.parameters()) {
            parameter.type().accept(this);
        }
        node.returnType().accept(this);
        return null;
    }

    @Override
    public Void visit(FunctionTypeNode node) {
        return null;
    }

    @Override
    public Void visit(NamedTypeNode node) {
        return null;
    }
}

