/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.GenPyCodeVisitor;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.PythonValueFactoryImpl;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class PySrcMain {
    private static final SoyErrorKind DUPLICATE_NAMESPACE_ERROR = SoyErrorKind.of("Multiple files are providing the same namespace: {0}. Soy namespaces must be unique.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyScopedData.Enterable apiCallScope;

    public PySrcMain(SoyScopedData.Enterable apiCallScope) {
        this.apiCallScope = apiCallScope;
    }

    private List<String> genPySrc(SoyFileSetNode soyTree, SoyPySrcOptions pySrcOptions, ImmutableMap<String, String> currentManifest, FileSetMetadata fileSetMetadata, ErrorReporter errorReporter) {
        BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromPyOptions(pySrcOptions.getBidiIsRtlFn());
        try (SoyScopedData.InScope inScope = this.apiCallScope.enter(null, bidiGlobalDir);){
            List<String> list = PySrcMain.createVisitor(pySrcOptions, inScope.getBidiGlobalDir(), errorReporter, currentManifest, fileSetMetadata).gen(soyTree, errorReporter);
            return list;
        }
    }

    public List<String> genPyFiles(SoyFileSetNode soyTree, FileSetMetadata fileSetMetadata, SoyPySrcOptions pySrcOptions, ErrorReporter errorReporter) throws IOException {
        ImmutableMap<String, String> manifest = PySrcMain.generateManifest(PySrcMain.getSoyNamespaces(soyTree), pySrcOptions.getInputToOutputFilePaths(), pySrcOptions.getOutputDirectoryFlag(), errorReporter);
        List<String> pyFileContents = this.genPySrc(soyTree, pySrcOptions, manifest, fileSetMetadata, errorReporter);
        if (soyTree.getChildren().size() != pyFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", soyTree.getChildren().size(), pyFileContents.size()));
        }
        if (pySrcOptions.namespaceManifestFile() != null) {
            try (BufferedWriter out = Files.newWriter((File)new File(pySrcOptions.namespaceManifestFile()), (Charset)StandardCharsets.UTF_8);){
                for (String namespace : manifest.keySet()) {
                    out.write(String.format("%s=%s\n", namespace, manifest.get((Object)namespace)));
                }
            }
        }
        return pyFileContents;
    }

    private static ImmutableMap<String, String> generateManifest(Map<SourceLogicalPath, String> soyNamespaces, Map<SourceLogicalPath, Path> inputToOutputPaths, Optional<Path> outputDirectoryFlag, ErrorReporter errorReporter) {
        HashMap<String, String> manifest = new HashMap<String, String>();
        for (SourceLogicalPath inputFilePath : inputToOutputPaths.keySet()) {
            String outputFilePath = inputToOutputPaths.get(inputFilePath).toString();
            String pythonPath = outputFilePath.replace(".py", "").replace('/', '.');
            String namespace = soyNamespaces.get(inputFilePath);
            if (manifest.containsKey(namespace)) {
                errorReporter.report(SourceLocation.UNKNOWN, DUPLICATE_NAMESPACE_ERROR, namespace);
            }
            manifest.put(namespace, pythonPath);
        }
        return ImmutableMap.copyOf(manifest);
    }

    private static ImmutableMap<SourceLogicalPath, String> getSoyNamespaces(SoyFileSetNode soyTree) {
        ImmutableMap.Builder namespaces = new ImmutableMap.Builder();
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            namespaces.put((Object)soyFile.getFilePath().asLogicalPath(), (Object)soyFile.getNamespace());
        }
        return namespaces.build();
    }

    @VisibleForTesting
    static GenPyCodeVisitor createVisitor(SoyPySrcOptions pySrcOptions, BidiGlobalDir bidiGlobalDir, ErrorReporter errorReporter, ImmutableMap<String, String> currentManifest, FileSetMetadata fileSetMetadata) {
        GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsFactory;
        final IsComputableAsPyExprVisitor isComputableAsPyExprs = new IsComputableAsPyExprVisitor();
        final PythonValueFactoryImpl pluginValueFactory = new PythonValueFactoryImpl(errorReporter, bidiGlobalDir);
        class PyCallExprVisitorSupplier
        implements Supplier<GenPyCallExprVisitor> {
            GenPyExprsVisitor.GenPyExprsVisitorFactory factory;

            PyCallExprVisitorSupplier() {
            }

            @Override
            public GenPyCallExprVisitor get() {
                return new GenPyCallExprVisitor(isComputableAsPyExprs, pluginValueFactory, (GenPyExprsVisitor.GenPyExprsVisitorFactory)Preconditions.checkNotNull((Object)this.factory));
            }
        }
        PyCallExprVisitorSupplier provider = new PyCallExprVisitorSupplier();
        provider.factory = genPyExprsFactory = new GenPyExprsVisitor.GenPyExprsVisitorFactory(isComputableAsPyExprs, pluginValueFactory, provider);
        return new GenPyCodeVisitor(pySrcOptions, currentManifest, fileSetMetadata, isComputableAsPyExprs, genPyExprsFactory, provider.get(), pluginValueFactory);
    }
}

