/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.errorprone.annotations.Immutable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@Immutable(containerOf={"T"})
public final class DelTemplateSelector<T> {
    private final ImmutableTable<String, String, Group<T>> nameAndVariantToGroup;
    private final ImmutableListMultimap<String, T> delTemplateNameToValues;

    private DelTemplateSelector(Builder<T> builder) {
        ImmutableTable.Builder nameAndVariantBuilder = ImmutableTable.builder();
        ImmutableListMultimap.Builder delTemplateNameToValuesBuilder = ImmutableListMultimap.builder();
        for (Table.Cell entry : builder.nameAndVariantToGroup.cellSet()) {
            Group group = ((Group.Builder)entry.getValue()).build();
            nameAndVariantBuilder.put((Object)((String)entry.getRowKey()), (Object)((String)entry.getColumnKey()), group);
            String delTemplateName = (String)entry.getRowKey();
            if (group.defaultValue != null) {
                delTemplateNameToValuesBuilder.put((Object)delTemplateName, group.defaultValue);
            }
            delTemplateNameToValuesBuilder.putAll((Object)delTemplateName, (Iterable)group.modToValue.values());
        }
        this.nameAndVariantToGroup = nameAndVariantBuilder.buildOrThrow();
        this.delTemplateNameToValues = delTemplateNameToValuesBuilder.build();
    }

    public ImmutableListMultimap<String, T> delTemplateNameToValues() {
        return this.delTemplateNameToValues;
    }

    public boolean hasDelTemplateNamed(String delTemplateName) {
        return this.nameAndVariantToGroup.containsRow((Object)delTemplateName);
    }

    @Nullable
    public T selectTemplate(String delTemplateName, String variant, Predicate<String> activeModSelector) {
        Object selection;
        Group group = (Group)this.nameAndVariantToGroup.get((Object)delTemplateName, (Object)variant);
        if (group != null && (selection = group.select(activeModSelector)) != null) {
            return selection;
        }
        if (!variant.isEmpty() && (group = (Group)this.nameAndVariantToGroup.get((Object)delTemplateName, (Object)"")) != null) {
            return group.select(activeModSelector);
        }
        return null;
    }

    public Builder<T> toBuilder() {
        Builder builder = new Builder();
        for (Table.Cell cell : this.nameAndVariantToGroup.cellSet()) {
            builder.nameAndVariantToGroup.put((Object)((String)cell.getRowKey()), (Object)((String)cell.getColumnKey()), ((Group)cell.getValue()).toBuilder());
        }
        return builder;
    }

    @Immutable(containerOf={"T"})
    private static final class Group<T> {
        final String formattedName;
        @Nullable
        final T defaultValue;
        final ImmutableMap<String, T> modToValue;

        private Group(Builder<T> builder) {
            this.formattedName = (String)Preconditions.checkNotNull((Object)builder.formattedName);
            this.defaultValue = builder.defaultValue;
            this.modToValue = ImmutableMap.copyOf(builder.modToValue);
        }

        T select(Predicate<String> activeModSelector) {
            Map.Entry selected = null;
            for (Map.Entry entry : this.modToValue.entrySet()) {
                if (!activeModSelector.test((String)entry.getKey())) continue;
                if (selected != null) {
                    throw new IllegalArgumentException(String.format("For delegate template '%s', found two active implementations with equal priority in delegate packages '%s' and '%s'.", this.formattedName, entry.getKey(), selected.getKey()));
                }
                selected = entry;
            }
            if (selected != null) {
                return (T)selected.getValue();
            }
            return this.defaultValue;
        }

        Builder<T> toBuilder() {
            Builder builder = new Builder(this.formattedName);
            builder.defaultValue = this.defaultValue;
            builder.modToValue.putAll(this.modToValue);
            return builder;
        }

        static final class Builder<T> {
            final String formattedName;
            Map<String, T> modToValue = new LinkedHashMap<String, T>();
            T defaultValue;

            Builder(String formattedName) {
                this.formattedName = (String)Preconditions.checkNotNull((Object)formattedName);
            }

            T setDefault(T defaultValue) {
                if (this.defaultValue != null) {
                    return this.defaultValue;
                }
                Preconditions.checkState((this.defaultValue == null ? 1 : 0) != 0);
                this.defaultValue = Preconditions.checkNotNull(defaultValue);
                return null;
            }

            T add(String mod, T value) {
                Preconditions.checkArgument((!mod.isEmpty() ? 1 : 0) != 0);
                return (T)this.modToValue.put(mod, Preconditions.checkNotNull(value));
            }

            Group<T> build() {
                return new Group(this);
            }
        }
    }

    public static final class Builder<T> {
        private final Table<String, String, Group.Builder<T>> nameAndVariantToGroup = Tables.newCustomTable(new LinkedHashMap(), LinkedHashMap::new);

        public T addDefault(String delTemplateName, String variant, T value) {
            return this.getBuilder(delTemplateName, variant).setDefault(value);
        }

        public T add(String delTemplateName, String mod, String variant, T value) {
            return this.getBuilder(delTemplateName, variant).add(mod, value);
        }

        private Group.Builder<T> getBuilder(String name, String variant) {
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            Group.Builder v = (Group.Builder)this.nameAndVariantToGroup.get((Object)name, (Object)variant);
            if (v == null) {
                v = new Group.Builder(name + (String)(variant.isEmpty() ? "" : ":" + variant));
                this.nameAndVariantToGroup.put((Object)name, (Object)variant, v);
            }
            return v;
        }

        public DelTemplateSelector<T> build() {
            return new DelTemplateSelector(this);
        }
    }
}

