/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNodes;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.sharedpasses.opti.PreevalVisitor;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.SoyType;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class SimplifyExprVisitor
extends AbstractExprNodeVisitor<Void> {
    private static final SoyErrorKind SOY_DATA_ERROR = SoyErrorKind.of("Invalid value: {0}.", new SoyErrorKind.StyleAllowance[0]);
    private final PreevalVisitor preevalVisitor = new PreevalVisitor(Environment.prerenderingEnvironment());
    private final ErrorReporter errorReporter;

    SimplifyExprVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitExprRootNode(ExprRootNode node) {
        this.visit(node.getRoot());
    }

    @Override
    protected void visitListLiteralNode(ListLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRecordLiteralNode(RecordLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMapLiteralNode(MapLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
        this.processAnd(node, true);
    }

    @Override
    protected void visitAmpAmpOpNode(OperatorNodes.AmpAmpOpNode node) {
        this.processAnd(node, false);
    }

    private void processAnd(AbstractOperatorNode node, boolean booleanCoerce) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(1) : node.getChild(0);
            node.getParent().replaceChild(node, booleanCoerce && replacementNode.getType().getKind() != SoyType.Kind.BOOL ? SimplifyExprVisitor.booleanCoerce(replacementNode) : replacementNode);
        }
    }

    @Override
    protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
        this.processOr(node, true);
    }

    @Override
    protected void visitBarBarOpNode(OperatorNodes.BarBarOpNode node) {
        this.processOr(node, false);
    }

    private void processOr(AbstractOperatorNode node, boolean booleanCoerce) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(0) : node.getChild(1);
            node.getParent().replaceChild(node, booleanCoerce && replacementNode.getType().getKind() != SoyType.Kind.BOOL ? SimplifyExprVisitor.booleanCoerce(replacementNode) : replacementNode);
        }
    }

    static ExprNode booleanCoerce(ExprNode expr) {
        SoyValue operand = SimplifyExprVisitor.getConstantOrNull(expr);
        if (operand != null) {
            return new BooleanNode(operand.coerceToBoolean(), expr.getSourceLocation());
        }
        FunctionNode func = FunctionNode.newPositional(Identifier.create("Boolean", expr.getSourceLocation()), BuiltinFunction.BOOLEAN, expr.getSourceLocation());
        func.addChild(expr);
        func.setType(BoolType.getInstance());
        func.setAllowedParamTypes((List<SoyType>)ImmutableList.of((Object)AnyType.getInstance()));
        return func;
    }

    @Override
    protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 == null) {
            return;
        }
        ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(1) : node.getChild(2);
        node.getParent().replaceChild(node, replacementNode);
    }

    @Override
    protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            if (operand0.isNullish()) {
                node.getParent().replaceChild(node, node.getChild(1));
            } else {
                node.getParent().replaceChild(node, node.getChild(0));
            }
        } else {
            switch (node.getChild(0).getKind()) {
                case LIST_LITERAL_NODE: 
                case RECORD_LITERAL_NODE: {
                    node.getParent().replaceChild(node, node.getChild(0));
                    break;
                }
            }
        }
    }

    @Override
    protected void visitFieldAccessNode(FieldAccessNode node) {
        this.visitDataAccessNodeInternal(node, SimplifyExprVisitor::visitFieldAccessNode);
    }

    @Nullable
    private static ExprNode visitFieldAccessNode(FieldAccessNode node, ExprNode baseExpr) {
        if (baseExpr instanceof RecordLiteralNode) {
            RecordLiteralNode recordLiteral = (RecordLiteralNode)baseExpr;
            for (int i = 0; i < recordLiteral.numChildren(); ++i) {
                if (!recordLiteral.getKey(i).identifier().equals(node.getFieldName())) continue;
                return recordLiteral.getChild(i);
            }
        }
        return null;
    }

    private <T extends DataAccessNode> void visitDataAccessNodeInternal(T node, BiFunction<T, ExprNode, ExprNode> delegate) {
        this.visitExprNode(node);
        if (node.getParent() == null) {
            return;
        }
        ExprNode baseExpr = node.getChild(0);
        ExprNode replacement = delegate.apply(node, baseExpr);
        if (replacement != null) {
            node.getParent().replaceChild(node, replacement);
        }
    }

    @Override
    protected void visitItemAccessNode(ItemAccessNode node) {
        this.visitDataAccessNodeInternal(node, SimplifyExprVisitor::visitItemAccessNode);
    }

    @Nullable
    private static ExprNode visitItemAccessNode(ItemAccessNode node, ExprNode baseExpr) {
        ExprNode keyExpr = node.getChild(1);
        if (baseExpr instanceof ListLiteralNode && keyExpr instanceof IntegerNode) {
            ListLiteralNode listLiteral = (ListLiteralNode)baseExpr;
            long index = ((IntegerNode)keyExpr).getValue();
            if (index >= 0L && index < (long)listLiteral.numChildren()) {
                return listLiteral.getChild((int)index);
            }
            return new UndefinedNode(node.getSourceLocation());
        }
        return null;
    }

    @Override
    protected void visitMethodCallNode(MethodCallNode node) {
        this.visitDataAccessNodeInternal(node, SimplifyExprVisitor::visitMethodCallNode);
    }

    @Nullable
    private static ExprNode visitMethodCallNode(MethodCallNode node, ExprNode baseExpr) {
        if (baseExpr instanceof MapLiteralNode && node.isMethodResolved() && node.getSoyMethod() == BuiltinMethod.MAP_GET) {
            MapLiteralNode mapLiteral = (MapLiteralNode)baseExpr;
            ExprNode keyExpr = node.getParam(0);
            boolean areAllKeysConstants = true;
            ExprEquivalence exprEquivalence = new ExprEquivalence();
            for (int i = 0; i < mapLiteral.numChildren(); i += 2) {
                ExprNode key = mapLiteral.getChild(i);
                ExprNode value = mapLiteral.getChild(i + 1);
                if (exprEquivalence.equivalent(keyExpr, key)) {
                    return value;
                }
                areAllKeysConstants = areAllKeysConstants && SimplifyExprVisitor.isConstant(key);
            }
            if (SimplifyExprVisitor.isConstant(keyExpr) && areAllKeysConstants) {
                return new UndefinedNode(node.getSourceLocation());
            }
        }
        return null;
    }

    @Override
    protected void visitNullSafeAccessNode(NullSafeAccessNode node) {
        ExprNode dataAccessChild;
        block5: while (true) {
            this.visit(node.getBase());
            ExprNode base = node.getBase();
            if (ExprNodes.isNullishLiteral(base)) {
                node.getParent().replaceChild(node, base);
                return;
            }
            dataAccessChild = node.getDataAccess();
            switch (dataAccessChild.getKind()) {
                case ASSERT_NON_NULL_OP_NODE: {
                    return;
                }
                case NULL_SAFE_ACCESS_NODE: {
                    NullSafeAccessNode nullSafeAccessChild = (NullSafeAccessNode)dataAccessChild;
                    DataAccessNode dataAccessChain = (DataAccessNode)nullSafeAccessChild.getBase();
                    DataAccessNode dataAccessChainBase = SimplifyExprVisitor.findBaseDataAccess(dataAccessChain);
                    ExprNode replacement = SimplifyExprVisitor.findReplacement(dataAccessChainBase, base);
                    if (replacement == null) {
                        return;
                    }
                    node.getParent().replaceChild(node, nullSafeAccessChild);
                    if (dataAccessChainBase == dataAccessChain) {
                        nullSafeAccessChild.replaceChild(nullSafeAccessChild.getBase(), replacement);
                    } else {
                        dataAccessChainBase.getParent().replaceChild(dataAccessChainBase, replacement);
                    }
                    node = nullSafeAccessChild;
                    continue block5;
                }
                case FIELD_ACCESS_NODE: 
                case ITEM_ACCESS_NODE: 
                case METHOD_CALL_NODE: {
                    DataAccessNode dataAccessChainBase = SimplifyExprVisitor.findBaseDataAccess((DataAccessNode)dataAccessChild);
                    ExprNode replacement = SimplifyExprVisitor.findReplacement(dataAccessChainBase, base);
                    if (replacement == null) {
                        return;
                    }
                    if (dataAccessChild == dataAccessChainBase) {
                        node.getParent().replaceChild(node, replacement);
                        this.visit(replacement);
                    } else {
                        dataAccessChainBase.getParent().replaceChild(dataAccessChainBase, replacement);
                        node.getParent().replaceChild(node, dataAccessChild);
                        this.visit(dataAccessChild);
                    }
                    return;
                }
            }
            break;
        }
        throw new AssertionError((Object)dataAccessChild.getKind());
    }

    @Nullable
    private static ExprNode findReplacement(DataAccessNode dataAccessChainBase, ExprNode base) {
        switch (dataAccessChainBase.getKind()) {
            case FIELD_ACCESS_NODE: {
                return SimplifyExprVisitor.visitFieldAccessNode((FieldAccessNode)dataAccessChainBase, base);
            }
            case ITEM_ACCESS_NODE: {
                return SimplifyExprVisitor.visitItemAccessNode((ItemAccessNode)dataAccessChainBase, base);
            }
            case METHOD_CALL_NODE: {
                return SimplifyExprVisitor.visitMethodCallNode((MethodCallNode)dataAccessChainBase, base);
            }
        }
        throw new AssertionError((Object)dataAccessChainBase.getKind());
    }

    private static DataAccessNode findBaseDataAccess(DataAccessNode node) {
        if (node.getBaseExprChild() instanceof DataAccessNode) {
            return SimplifyExprVisitor.findBaseDataAccess((DataAccessNode)node.getBaseExprChild());
        }
        return node;
    }

    @Override
    protected void visitFunctionNode(FunctionNode node) {
        if (node.getSoyFunction() instanceof BuiltinFunction) {
            switch ((BuiltinFunction)node.getSoyFunction()) {
                case BOOLEAN: 
                case EMPTY_TO_NULL: 
                case UNDEFINED_TO_NULL: 
                case UNDEFINED_TO_NULL_SSR: {
                    this.visitExprNode(node);
                    break;
                }
            }
            return;
        }
        if (node.getSoyFunction() instanceof LoggingFunction) {
            return;
        }
        this.visitExprNode(node);
    }

    @Override
    protected void visitExprNode(ExprNode node) {
        if (!(node instanceof ExprNode.ParentExprNode)) {
            return;
        }
        ExprNode.ParentExprNode nodeAsParent = (ExprNode.ParentExprNode)node;
        this.visitChildren(nodeAsParent);
        if (!SimplifyExprVisitor.childrenAreConstant(nodeAsParent)) {
            return;
        }
        this.attemptPreeval(nodeAsParent);
    }

    private void attemptPreeval(ExprNode node) {
        ExprNode.PrimitiveNode newNode;
        SoyValue preevalResult;
        try {
            preevalResult = (SoyValue)this.preevalVisitor.exec(node);
        }
        catch (RenderException e) {
            return;
        }
        catch (SoyDataException e) {
            this.errorReporter.report(node.getSourceLocation(), SOY_DATA_ERROR, e.getMessage());
            return;
        }
        if (preevalResult instanceof PrimitiveData && (newNode = InternalValueUtils.convertPrimitiveDataToExpr((PrimitiveData)preevalResult, node.getSourceLocation())) != null) {
            node.getParent().replaceChild(node, newNode);
        }
    }

    private static boolean childrenAreConstant(ExprNode.ParentExprNode parent) {
        if (parent.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode nullSafe = (NullSafeAccessNode)parent;
            return SimplifyExprVisitor.isConstant(nullSafe.getBase()) && SimplifyExprVisitor.childrenAreConstant((ExprNode.ParentExprNode)nullSafe.getDataAccess());
        }
        for (ExprNode child : parent.getChildren()) {
            if (SimplifyExprVisitor.isConstant(child)) continue;
            return false;
        }
        return true;
    }

    static boolean isConstant(ExprNode expr) {
        return expr instanceof ExprNode.PrimitiveNode;
    }

    @Nullable
    static SoyValue getConstantOrNull(ExprNode expr) {
        switch (expr.getKind()) {
            case NULL_NODE: {
                return NullData.INSTANCE;
            }
            case UNDEFINED_NODE: {
                return UndefinedData.INSTANCE;
            }
            case BOOLEAN_NODE: {
                return BooleanData.forValue(((BooleanNode)expr).getValue());
            }
            case INTEGER_NODE: {
                return IntegerData.forValue(((IntegerNode)expr).getValue());
            }
            case FLOAT_NODE: {
                return FloatData.forValue(((FloatNode)expr).getValue());
            }
            case STRING_NODE: {
                return StringData.forValue(((StringNode)expr).getValue());
            }
            case PROTO_ENUM_VALUE_NODE: {
                return IntegerData.forValue(((ProtoEnumValueNode)expr).getValue());
            }
            case FUNCTION_NODE: {
                SoyValue b;
                FunctionNode func = (FunctionNode)expr;
                if (func.getFunctionName().equals("Boolean") && (b = SimplifyExprVisitor.getConstantOrNull(func.getChild(0))) != null) {
                    return BooleanData.forValue(b.coerceToBoolean());
                }
                return null;
            }
        }
        return null;
    }
}

