/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.sharedpasses.opti.PreevalVisitorFactory;
import com.google.template.soy.sharedpasses.opti.PrerenderVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyExprVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.StringType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public final class SimplifyVisitor {
    private final Impl impl;
    private final SimplifyExprVisitor simplifyExprVisitor;
    private final PreevalVisitorFactory preevalVisitorFactory;

    public static SimplifyVisitor create(IdGenerator idGenerator, ImmutableList<SoyFileNode> sourceFiles, ErrorReporter errorReporter) {
        return new SimplifyVisitor(idGenerator, sourceFiles, new SimplifyExprVisitor(errorReporter), new PreevalVisitorFactory());
    }

    private SimplifyVisitor(IdGenerator idGenerator, ImmutableList<SoyFileNode> sourceFiles, SimplifyExprVisitor simplifyExprVisitor, PreevalVisitorFactory preevalVisitorFactory) {
        this.impl = new Impl(sourceFiles, idGenerator);
        this.simplifyExprVisitor = simplifyExprVisitor;
        this.preevalVisitorFactory = preevalVisitorFactory;
    }

    public void simplify(SoyFileNode file) {
        this.impl.exec(file);
    }

    private static boolean isValidBlockNodeForLet(SoyNode node) {
        switch (node.getKind()) {
            case LET_CONTENT_NODE: 
            case CALL_PARAM_CONTENT_NODE: 
            case IF_COND_NODE: 
            case IF_ELSE_NODE: 
            case SWITCH_CASE_NODE: 
            case SWITCH_DEFAULT_NODE: 
            case FOR_NONEMPTY_NODE: 
            case TEMPLATE_BASIC_NODE: 
            case TEMPLATE_DELEGATE_NODE: 
            case TEMPLATE_ELEMENT_NODE: {
                return true;
            }
            case VE_LOG_NODE: {
                return !(node.getParent() instanceof SoyNode.MsgBlockNode);
            }
            case LOG_NODE: 
            case MSG_FALLBACK_GROUP_NODE: 
            case MSG_NODE: 
            case MSG_PLURAL_NODE: 
            case MSG_SELECT_NODE: 
            case MSG_SELECT_CASE_NODE: 
            case MSG_SELECT_DEFAULT_NODE: 
            case MSG_PLURAL_CASE_NODE: 
            case MSG_PLURAL_DEFAULT_NODE: 
            case MSG_HTML_TAG_NODE: 
            case MSG_PLACEHOLDER_NODE: {
                return false;
            }
        }
        if (node instanceof SoyNode.BlockNode) {
            throw new AssertionError((Object)("unhandled block node: " + String.valueOf((Object)node.getKind()) + "  " + String.valueOf(node) + " @" + String.valueOf(node.getSourceLocation())));
        }
        return false;
    }

    private static boolean isConstant(@Nullable ExprRootNode exprRoot) {
        return exprRoot != null && SimplifyExprVisitor.isConstant(exprRoot.getRoot());
    }

    @Nullable
    private static SoyValue getConstantOrNull(ExprRootNode exprRoot) {
        if (exprRoot == null) {
            return null;
        }
        ExprNode expr = exprRoot.getRoot();
        return SimplifyExprVisitor.getConstantOrNull(expr);
    }

    private static void replaceNodeWithList(SoyNode.StandaloneNode origNode, List<? extends SoyNode.StandaloneNode> replacementNodes) {
        ParentNode parent = origNode.getParent();
        int indexInParent = parent.getChildIndex(origNode);
        parent.removeChild(indexInParent);
        parent.addChildren(indexInParent, replacementNodes);
    }

    public static void mergeBindAndCall(CallBasicNode node, IdGenerator nodeIdGen) {
        ExprNode calleeRoot = node.getCalleeExpr().getRoot();
        if (calleeRoot.getKind() == ExprNode.Kind.METHOD_CALL_NODE && ((MethodCallNode)calleeRoot).getSoyMethod() == BuiltinMethod.BIND) {
            MethodCallNode methodCallNode = (MethodCallNode)calleeRoot;
            if (methodCallNode.numParams() != 1) {
                return;
            }
            RecordLiteralNode record = (RecordLiteralNode)methodCallNode.getParam(0);
            ExprNode bindCallee = methodCallNode.getBaseExprChild();
            node.getCalleeExpr().replaceChild(calleeRoot, bindCallee);
            node.getCalleeExpr().setType(bindCallee.getType());
            ArrayList<ExprNode> children = new ArrayList<ExprNode>(record.getChildren());
            for (int i = 0; i < children.size(); ++i) {
                Identifier key = record.getKey(i);
                ExprNode value = (ExprNode)children.get(i);
                SourceLocation loc = key.location();
                if (loc.isBefore(value.getSourceLocation())) {
                    loc = loc.extend(value.getSourceLocation());
                }
                CallParamValueNode paramNode = new CallParamValueNode(nodeIdGen.genId(), loc, key, value);
                node.addChild(i, paramNode);
            }
        }
    }

    static ImmutableList<SoyNode> trimToMovablePrefix(LetNode from, SoyNode.ExprHolderNode ref, List<SoyNode> path) {
        path = new ArrayList<SoyNode>(path);
        for (int i = 0; i < path.size(); ++i) {
            SoyNode node = path.get(i);
            if (node instanceof ForNode) {
                return ImmutableList.copyOf(path.subList(0, i));
            }
            if (node instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)node).getChildren().stream().anyMatch(n -> n instanceof SkipNode)) {
                return ImmutableList.copyOf(path.subList(0, i));
            }
            if (node instanceof SkipNode) {
                HtmlOpenTagNode skipParent = (HtmlOpenTagNode)node.getParent();
                int index = path.indexOf(skipParent);
                index = index == -1 ? 0 : index;
                return ImmutableList.copyOf(path.subList(0, index));
            }
            if (SimplifyVisitor.isValidBlockNodeForLet((SoyNode)((Object)node.getParent())) && !SoyTreeUtils.isDescendantOf(ref, node)) continue;
            path.remove(i);
            --i;
        }
        return ImmutableList.copyOf(path);
    }

    static List<SoyNode> evaluationOrder(LetNode from, SoyNode.ExprHolderNode ref) {
        int start = from.getParent().getChildIndex(from);
        ArrayList<SoyNode> children = new ArrayList<SoyNode>();
        try {
            SimplifyVisitor.doEvaluationOrder(from.getParent(), start + 1, ref, children);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("error while looking for: " + String.valueOf(ref) + " a reference to: " + String.valueOf(from) + ":\npath: " + String.valueOf(children) + "\n\n:" + from.getParent().toSourceString(), e);
        }
        return children;
    }

    private static void doEvaluationOrder(SoyNode.ParentSoyNode<?> from, int index, SoyNode.ExprHolderNode ref, List<SoyNode> children) {
        while (index < from.numChildren()) {
            SoyNode next = (SoyNode)from.getChild(index);
            if (next == ref) {
                return;
            }
            children.add(next);
            if (SoyTreeUtils.isDescendantOf(ref, next)) {
                SimplifyVisitor.doEvaluationOrder((SoyNode.ParentSoyNode)next, 0, ref, children);
                return;
            }
            ++index;
        }
        ParentNode parent = from.getParent();
        if (parent instanceof SoyFileNode) {
            throw new VerifyException("too far");
        }
        SimplifyVisitor.doEvaluationOrder(parent, parent.getChildIndex(from) + 1, ref, children);
    }

    private static <T> List<T> commonPrefix(List<T> a, List<T> b) {
        if (a.size() > b.size()) {
            a = a.subList(0, b.size());
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            a = a.subList(0, i);
            break;
        }
        return a;
    }

    private final class Impl
    extends AbstractSoyNodeVisitor<Void> {
        final ImmutableMap<String, TemplateNode> basicTemplates;
        final IdGenerator nodeIdGen;
        final IdentityHashMap<LocalVar, LocalVar> varDefnReplacements = new IdentityHashMap();

        Impl(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
            this.nodeIdGen = idGenerator;
            ImmutableMap.Builder basicTemplates = ImmutableMap.builder();
            for (SoyFileNode fileNode : sourceFiles) {
                for (TemplateNode template : fileNode.getTemplates()) {
                    if (template instanceof TemplateDelegateNode) continue;
                    basicTemplates.put((Object)template.getTemplateName(), (Object)template);
                }
            }
            this.basicTemplates = basicTemplates.buildOrThrow();
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            LetNode letNode;
            Object local;
            VarDefn defn;
            List<RefAndHolder> allRefs;
            boolean simplifiedAnyLet;
            do {
                simplifiedAnyLet = false;
                this.varDefnReplacements.clear();
                ImmutableSet referencedVars = ImmutableSet.of();
                SoyTreeUtils.execOnAllV2Exprs(node, SimplifyVisitor.this.simplifyExprVisitor);
                super.visitTemplateNode(node);
                allRefs = this.getAllRefs(node);
                if (!this.varDefnReplacements.isEmpty()) {
                    for (RefAndHolder refAndHolder : allRefs) {
                        LocalVar localVar = this.varDefnReplacements.get(refAndHolder.ref.getDefnDecl());
                        if (localVar == null) continue;
                        refAndHolder.ref.setDefn(localVar);
                    }
                }
                TreeMap<LetValueNode, RefAndHolder> possiblyInlinableRefs = new TreeMap<LetValueNode, RefAndHolder>(Comparator.comparing(AbstractSoyNode::getSourceLocation).thenComparing(AbstractSoyNode::getId));
                for (RefAndHolder refAndHolder : allRefs) {
                    defn = refAndHolder.ref.getDefnDecl();
                    if (defn.kind() != VarDefn.Kind.LOCAL_VAR || ((SoyNode.LocalVarNode)((AbstractLocalVarDefn)(local = (LocalVar)defn)).declaringNode()).getKind() != SoyNode.Kind.LET_VALUE_NODE) continue;
                    letNode = (LetValueNode)((AbstractLocalVarDefn)local).declaringNode();
                    possiblyInlinableRefs.compute((LetValueNode)letNode, (key, oldValue) -> oldValue == null ? refAndHolder : RefAndHolder.NULL);
                }
                for (Map.Entry entry : possiblyInlinableRefs.entrySet()) {
                    if (entry.getValue() == RefAndHolder.NULL) continue;
                    RefAndHolder refAndHolder = (RefAndHolder)entry.getValue();
                    simplifiedAnyLet = this.maybeInline((LetValueNode)entry.getKey(), refAndHolder.ref, refAndHolder.holder) || simplifiedAnyLet;
                }
                if (simplifiedAnyLet) continue;
                referencedVars = (ImmutableSet)allRefs.stream().map(ref -> ref.ref.getDefnDecl()).collect(ImmutableSet.toImmutableSet());
                for (SoyNode.LocalVarNode localVarNode : (ImmutableList)SoyTreeUtils.allNodesOfType(node, SoyNode.LocalVarNode.class).collect(ImmutableList.toImmutableList())) {
                    if (localVarNode instanceof ForNonemptyNode) {
                        ForNonemptyNode forNode = (ForNonemptyNode)localVarNode;
                        if (forNode.getIndexVar() == null || referencedVars.contains((Object)forNode.getIndexVar())) continue;
                        forNode.deleteIndexVar();
                        simplifiedAnyLet = true;
                        continue;
                    }
                    if (localVarNode instanceof LetNode) {
                        if (referencedVars.contains(localVarNode.getVar())) continue;
                        ParentNode parent = localVarNode.getParent();
                        parent.removeChild(parent.getChildIndex(localVarNode));
                        simplifiedAnyLet = true;
                        continue;
                    }
                    throw new AssertionError((Object)("unknown var type: " + String.valueOf(localVarNode) + " @" + String.valueOf(localVarNode.getSourceLocation())));
                }
            } while (simplifiedAnyLet);
            SetMultimap letToReferences = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
            for (RefAndHolder refAndHolder : allRefs) {
                defn = refAndHolder.ref.getDefnDecl();
                if (defn.kind() != VarDefn.Kind.LOCAL_VAR || !(((AbstractLocalVarDefn)(local = (LocalVar)defn)).declaringNode() instanceof LetNode)) continue;
                letNode = (LetNode)((AbstractLocalVarDefn)local).declaringNode();
                letToReferences.put((Object)letNode, (Object)refAndHolder.holder);
            }
            for (LetNode letNode2 : (ImmutableList)letToReferences.keySet().stream().sorted(Comparator.comparing(AbstractSoyNode::getSourceLocation)).collect(ImmutableList.toImmutableList())) {
                List<SoyNode> commonPath = null;
                for (SoyNode.ExprHolderNode reference : letToReferences.get((Object)letNode2)) {
                    List<SoyNode> pathToReference = SimplifyVisitor.evaluationOrder(letNode2, reference);
                    pathToReference = SimplifyVisitor.trimToMovablePrefix(letNode2, reference, pathToReference);
                    if (commonPath == null) {
                        commonPath = pathToReference;
                        continue;
                    }
                    commonPath = SimplifyVisitor.commonPrefix(commonPath, pathToReference);
                }
                if (commonPath.isEmpty()) continue;
                letNode2.getParent().removeChild(letNode2);
                SoyNode insertAfter = (SoyNode)Iterables.getLast((Iterable)commonPath);
                ParentNode insertAfterParent = insertAfter.getParent();
                int index = insertAfterParent.getChildIndex(insertAfter);
                insertAfterParent.addChild(index + 1, letNode2);
            }
        }

        private List<RefAndHolder> getAllRefs(TemplateNode template) {
            ArrayList<RefAndHolder> refs = new ArrayList<RefAndHolder>();
            SoyTreeUtils.allNodesOfType(template, SoyNode.ExprHolderNode.class).forEach(holder -> holder.getExprList().stream().flatMap(root -> SoyTreeUtils.allNodesOfType(root, VarRefNode.class)).forEach(ref -> refs.add(new RefAndHolder((VarRefNode)ref, (SoyNode.ExprHolderNode)holder))));
            return refs;
        }

        private boolean maybeInline(LetValueNode definition, VarRefNode ref, SoyNode.ExprHolderNode holder) {
            if (!this.isTrivialDefinition(definition.getExpr().getRoot()) && this.isInLoop(definition, ref, holder)) {
                return false;
            }
            ref.getParent().replaceChild(ref, definition.getExpr().getRoot());
            definition.getParent().removeChild(definition);
            return true;
        }

        private boolean isTrivialDefinition(ExprNode expr) {
            FunctionNode functionNode;
            if (expr instanceof ExprNode.PrimitiveNode) {
                return true;
            }
            if (expr instanceof FunctionNode && (functionNode = (FunctionNode)expr).getSoyFunction() instanceof BuiltinFunction) {
                switch ((BuiltinFunction)functionNode.getSoyFunction()) {
                    case XID: 
                    case CSS: {
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isInLoop(LetValueNode definition, VarRefNode var, SoyNode.ExprHolderNode holder) {
            Preconditions.checkNotNull((Object)definition);
            if (var.getNearestAncestor(ListComprehensionNode.class) != null) {
                return true;
            }
            return !Objects.equal((Object)holder.getNearestAncestor(ForNonemptyNode.class), (Object)definition.getNearestAncestor(ForNonemptyNode.class));
        }

        @Override
        protected void visitCallBasicNode(CallBasicNode node) {
            super.visitCallBasicNode(node);
            SimplifyVisitor.mergeBindAndCall(node, this.nodeIdGen);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            super.visitPrintNode(node);
            ParentNode parent = node.getParent();
            if (parent instanceof SoyNode.MsgBlockNode) {
                return;
            }
            if (!SimplifyVisitor.isConstant(node.getExpr())) {
                return;
            }
            for (PrintDirectiveNode directive : node.getChildren()) {
                for (ExprRootNode arg : directive.getArgs()) {
                    if (SimplifyVisitor.isConstant(arg)) continue;
                    return;
                }
            }
            StringBuilder prerenderOutputSb = new StringBuilder();
            try {
                PrerenderVisitor prerenderer = new PrerenderVisitor(SimplifyVisitor.this.preevalVisitorFactory, prerenderOutputSb, this.basicTemplates);
                prerenderer.exec(node);
            }
            catch (RenderException pe) {
                return;
            }
            String string = prerenderOutputSb.toString();
            if (string.isEmpty()) {
                if (parent instanceof HtmlAttributeNode) {
                    return;
                }
                parent.removeChild(node);
            } else {
                parent.replaceChild(node, new RawTextNode(this.nodeIdGen.genId(), string, node.getSourceLocation()));
            }
        }

        @Override
        protected void visitIfNode(IfNode node) {
            super.visitIfNode(node);
            ArrayList children = Lists.newArrayList(node.getChildren());
            for (int condIndex = 0; condIndex < children.size(); ++condIndex) {
                SoyNode child = (SoyNode)children.get(condIndex);
                if (!(child instanceof IfCondNode)) continue;
                IfCondNode condNode = (IfCondNode)child;
                SoyValue condExpr = SimplifyVisitor.getConstantOrNull(condNode.getExpr());
                if (condExpr != null) {
                    if (condExpr.coerceToBoolean()) {
                        for (int i = node.numChildren() - 1; i > condIndex; --i) {
                            node.removeChild(i);
                        }
                        IfElseNode newElseNode = new IfElseNode(this.nodeIdGen.genId(), condNode.getSourceLocation(), condNode.getOpenTagLocation());
                        newElseNode.addChildren(condNode.getChildren());
                        node.replaceChild(condIndex, newElseNode);
                        break;
                    }
                    node.removeChild(condNode);
                    children = Lists.newArrayList(node.getChildren());
                    --condIndex;
                    continue;
                }
                if (condNode.numChildren() != 0) continue;
                node.removeChild(condNode);
                children = Lists.newArrayList(node.getChildren());
                int nextNodeIndex = condIndex--;
                if (nextNodeIndex >= children.size()) continue;
                OperatorNodes.NotOpNode negation = new OperatorNodes.NotOpNode(SourceLocation.UNKNOWN, SourceLocation.UNKNOWN);
                negation.addChild(condNode.getExpr().getRoot());
                negation.setType(BoolType.getInstance());
                if (nextNodeIndex == children.size() - 1) {
                    SoyNode next = (SoyNode)children.get(nextNodeIndex);
                    if (next instanceof IfCondNode) {
                        IfCondNode nextCondNode = (IfCondNode)next;
                        ExprRootNode rootCondition = nextCondNode.getExpr();
                        OperatorNodes.AmpAmpOpNode andNode = new OperatorNodes.AmpAmpOpNode(SourceLocation.UNKNOWN, SourceLocation.UNKNOWN);
                        andNode.addChild(negation);
                        andNode.addChild(rootCondition.getRoot());
                        andNode.setType(BoolType.getInstance());
                        rootCondition.addChild(andNode);
                        rootCondition.setType(BoolType.getInstance());
                        continue;
                    }
                    IfElseNode nextElseNode = (IfElseNode)next;
                    IfCondNode newCondNode = new IfCondNode(nextElseNode.getId(), nextElseNode.getSourceLocation(), nextElseNode.getOpenTagLocation(), "elseif", negation);
                    newCondNode.getExpr().setType(BoolType.getInstance());
                    newCondNode.addChildren(nextElseNode.getChildren());
                    node.replaceChild(nextElseNode, newCondNode);
                    children.set(nextNodeIndex, newCondNode);
                    continue;
                }
                IfNode newParentIf = new IfNode(this.nodeIdGen.genId(), condNode.getSourceLocation());
                newParentIf.setHtmlContext(node.getHtmlContext());
                if (nextNodeIndex == 0) {
                    IfCondNode newParentCondNode = new IfCondNode(condNode.getId(), condNode.getSourceLocation(), condNode.getOpenTagLocation(), "if", negation);
                    newParentCondNode.getExpr().setType(BoolType.getInstance());
                    newParentIf.addChild(newParentCondNode);
                    node.getParent().replaceChild(node, newParentIf);
                    newParentCondNode.addChild(node);
                    continue;
                }
                IfCondNode elseIf = new IfCondNode(this.nodeIdGen.genId(), condNode.getSourceLocation(), condNode.getOpenTagLocation(), "elseif", negation);
                elseIf.getExpr().setType(BoolType.getInstance());
                elseIf.addChild(newParentIf);
                node.addChild(nextNodeIndex, elseIf);
                newParentIf.addChildren(children.subList(nextNodeIndex, children.size()));
                this.visitIfNode(newParentIf);
                break;
            }
            if (node.numChildren() == 0) {
                node.getParent().removeChild(node);
            }
            if (node.numChildren() == 1 && node.getChild(0) instanceof IfElseNode) {
                SimplifyVisitor.replaceNodeWithList(node, ((SoyNode.BlockNode)node.getChild(0)).getChildren());
            }
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            super.visitSwitchNode(node);
            SoyValue switchExprValue = SimplifyVisitor.getConstantOrNull(node.getExpr());
            if (switchExprValue == null) {
                return;
            }
            for (SoyNode child : Lists.newArrayList((Iterable)node.getChildren())) {
                if (!(child instanceof SwitchCaseNode)) continue;
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                boolean hasMatchingConstant = false;
                boolean hasAllNonmatchingConstants = true;
                for (ExprRootNode caseExpr : caseNode.getExprList()) {
                    SoyValue caseExprValue = SimplifyVisitor.getConstantOrNull(caseExpr);
                    if (caseExprValue == null) {
                        hasAllNonmatchingConstants = false;
                        continue;
                    }
                    if (!caseExprValue.equals(switchExprValue)) continue;
                    hasMatchingConstant = true;
                    hasAllNonmatchingConstants = false;
                    break;
                }
                if (hasMatchingConstant) {
                    int caseIndex = node.getChildIndex(caseNode);
                    for (int i = node.numChildren() - 1; i > caseIndex; --i) {
                        node.removeChild(i);
                    }
                    SwitchDefaultNode newDefaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), caseNode.getSourceLocation(), caseNode.getOpenTagLocation());
                    newDefaultNode.addChildren(caseNode.getChildren());
                    node.replaceChild(caseIndex, (SoyNode)newDefaultNode);
                    break;
                }
                if (!hasAllNonmatchingConstants) continue;
                node.removeChild(caseNode);
            }
            if (node.numChildren() == 1 && node.getChild(0) instanceof SwitchDefaultNode) {
                SimplifyVisitor.replaceNodeWithList(node, ((CaseOrDefaultNode)node.getChild(0)).getChildren());
            }
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            super.visitCallParamContentNode(node);
            ExprNode asExpression = this.rewriteContentNodeAsExpression(node);
            if (asExpression != null) {
                CallParamValueNode valueNode = new CallParamValueNode(node.getId(), node.getSourceLocation(), node.getKey(), asExpression);
                node.getParent().replaceChild(node, (SoyNode)valueNode);
            }
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            super.visitLetContentNode(node);
            ExprNode asExpression = this.rewriteContentNodeAsExpression(node);
            if (asExpression != null) {
                LetValueNode valueNode = new LetValueNode(node.getId(), node.getSourceLocation(), node.getVarRefName(), node.getVar().nameLocation(), asExpression);
                valueNode.getVar().setType(node.getVar().type());
                node.getParent().replaceChild(node, valueNode);
                this.varDefnReplacements.put(node.getVar(), valueNode.getVar());
            }
        }

        private boolean containsLoggingFunction(SoyNode.RenderUnitNode node) {
            return SoyTreeUtils.allNodesOfType(node, FunctionNode.class).anyMatch(n -> n.getSoyFunction() instanceof LoggingFunction);
        }

        @Nullable
        private ExprNode rewriteContentNodeAsExpression(SoyNode.RenderUnitNode renderUnitNode) {
            ExprNode result;
            if (renderUnitNode.getContentKind() != SanitizedContentKind.TEXT) {
                return null;
            }
            if (this.containsLoggingFunction(renderUnitNode)) {
                return null;
            }
            List<ExprNode> newExprs = new ArrayList<ExprNode>(renderUnitNode.numChildren());
            for (SoyNode child : renderUnitNode.getChildren()) {
                if (child.getKind() == SoyNode.Kind.PRINT_NODE) {
                    PrintNode print = (PrintNode)child;
                    if (print.numChildren() == 0 || print.numChildren() == 1 && ((PrintDirectiveNode)print.getChild(0)).getPrintDirective().getName().equals("|text")) {
                        newExprs.add(print.getExpr().getRoot());
                        continue;
                    }
                    return null;
                }
                if (child.getKind() == SoyNode.Kind.RAW_TEXT_NODE) {
                    newExprs.add(new StringNode(((RawTextNode)child).getRawText(), QuoteStyle.SINGLE, child.getSourceLocation()));
                    continue;
                }
                return null;
            }
            if (newExprs.size() >= 1 && newExprs.get(0) instanceof StringNode) {
                result = (ExprNode)newExprs.get(0);
                newExprs = newExprs.subList(1, newExprs.size());
            } else {
                result = new StringNode("", QuoteStyle.SINGLE, renderUnitNode.getSourceLocation());
            }
            for (ExprNode expr : newExprs) {
                OperatorNodes.PlusOpNode op = new OperatorNodes.PlusOpNode(result.getSourceLocation().extend(expr.getSourceLocation()), SourceLocation.UNKNOWN);
                op.addChild(result);
                op.addChild(expr);
                op.setType(StringType.getInstance());
                result = op;
            }
            return result;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private static final class RefAndHolder {
        static final RefAndHolder NULL = new RefAndHolder();
        final VarRefNode ref;
        final SoyNode.ExprHolderNode holder;

        RefAndHolder() {
            this.ref = null;
            this.holder = null;
        }

        RefAndHolder(VarRefNode ref, SoyNode.ExprHolderNode holder) {
            this.ref = (VarRefNode)Preconditions.checkNotNull((Object)ref);
            this.holder = (SoyNode.ExprHolderNode)Preconditions.checkNotNull((Object)holder);
        }
    }
}

