/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.TofuTypeChecks;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;
import javax.annotation.Nullable;

final class TofuJavaValue
implements JavaValue {
    @Nullable
    private final SoyValue soyValue;
    @Nullable
    private final SourceLocation sourceLocation;
    @Nullable
    private final Object rawValue;

    static TofuJavaValue forSoyValue(SoyValue soyValue, SourceLocation sourceLocation) {
        return new TofuJavaValue((SoyValue)Preconditions.checkNotNull((Object)soyValue), null, (SourceLocation)Preconditions.checkNotNull((Object)sourceLocation));
    }

    static TofuJavaValue forRaw(Object value) {
        return new TofuJavaValue(null, Preconditions.checkNotNull((Object)value), null);
    }

    private TofuJavaValue(SoyValue soyValue, Object rawValue, SourceLocation sourceLocation) {
        this.soyValue = soyValue;
        this.rawValue = rawValue;
        this.sourceLocation = sourceLocation;
    }

    boolean hasSoyValue() {
        return this.soyValue != null;
    }

    SoyValue soyValue() {
        Preconditions.checkState((this.soyValue != null ? 1 : 0) != 0);
        return this.soyValue;
    }

    Object rawValue() {
        Preconditions.checkState((this.rawValue != null ? 1 : 0) != 0);
        return this.rawValue;
    }

    @Override
    public TofuJavaValue isNonNull() {
        if (this.soyValue == null) {
            throw RenderException.create("isNonNull is only supported on the 'args' parameters of JavaValueFactory methods");
        }
        return TofuJavaValue.forSoyValue(BooleanData.forValue(!this.soyValue.isNullish()), this.sourceLocation);
    }

    @Override
    public TofuJavaValue isNull() {
        if (this.soyValue == null) {
            throw RenderException.create("isNull is only supported on the 'args' parameters of JavaValueFactory methods");
        }
        return TofuJavaValue.forSoyValue(BooleanData.forValue(this.soyValue.isNullish()), this.sourceLocation);
    }

    @Override
    @CanIgnoreReturnValue
    public TofuJavaValue asSoyBoolean() {
        this.checkType(BoolType.getInstance());
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public TofuJavaValue asSoyFloat() {
        this.checkType(StringType.getInstance());
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public TofuJavaValue asSoyInt() {
        this.checkType(IntType.getInstance());
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public TofuJavaValue asSoyString() {
        this.checkType(StringType.getInstance());
        return this;
    }

    @Override
    public JavaValue coerceToSoyBoolean() {
        return TofuJavaValue.forSoyValue(BooleanData.forValue(this.soyValue.coerceToBoolean()), this.sourceLocation);
    }

    @Override
    public JavaValue coerceToSoyString() {
        return TofuJavaValue.forSoyValue(StringData.forValue(this.soyValue.coerceToString()), this.sourceLocation);
    }

    private void checkType(SoyType type) {
        if (!TofuTypeChecks.isInstance(type, this.soyValue, this.sourceLocation)) {
            throw RenderException.create("SoyValue[" + String.valueOf(this.soyValue) + "] of type: " + String.valueOf(this.soyValue.getClass()) + " is incompatible with soy type: " + String.valueOf(type));
        }
    }

    public String toString() {
        if (this.soyValue != null) {
            return "TofuJavaValue[soyValue=" + String.valueOf(this.soyValue) + "]";
        }
        return "TofuJavaValue[rawValue=" + String.valueOf(this.rawValue) + "]";
    }
}

