/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.ibm.icu.text.MessagePattern;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ParseErrors {
    private static final SoyErrorKind PLAIN_ERROR = SoyErrorKind.of("{0}", SoyErrorKind.StyleAllowance.values());
    private static final Pattern EXTRACT_LOCATION = Pattern.compile("at line (\\d+), column (\\d+).");
    private static final SoyErrorKind FOUND_DOUBLE_BRACE = SoyErrorKind.of("Soy '{{command}}' syntax is no longer supported. Use single braces.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG = SoyErrorKind.of("Unexpected closing tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_EOF = SoyErrorKind.of("Unexpected end of file.  Did you forget to close an attribute value or a comment?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_NEWLINE = SoyErrorKind.of("Unexpected newline in Soy string.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_PARAM_DECL = SoyErrorKind.of("Unexpected parameter declaration. Param declarations must come before any code in your template.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_RIGHT_BRACE = SoyErrorKind.of("Unexpected ''}''; did you mean '''{'rb'}'''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_TOKEN_MGR_ERROR = SoyErrorKind.of("Unexpected fatal Soy error. Please file a bug with your Soy file and we''ll take a look. (error code {0})\n{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final CharMatcher TOKENS_TO_QUOTE = CharMatcher.whitespace().or(CharMatcher.is((char)',')).or(CharMatcher.is((char)':')).precomputed();
    private static final SoyErrorKind SELECT_CASE_INVALID_VALUE = SoyErrorKind.of("Invalid value for select ''case'', expected an identifier (most commonly, a gender).{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);

    private ParseErrors() {
    }

    static void reportSoyFileParseException(ErrorReporter reporter, SourceFilePath filePath, ParseException e, int currentLexicalState) {
        ParseErrors.reportSoyFileParseException(reporter, filePath, e, currentLexicalState, "");
    }

    static void reportSoyFileParseException(ErrorReporter reporter, SourceFilePath filePath, ParseException e, int currentLexicalState, String optionalAdvice) {
        if (e instanceof SoyFileParser.ParseExceptionWithAdvice) {
            optionalAdvice = ((SoyFileParser.ParseExceptionWithAdvice)e).advice;
            e = ((SoyFileParser.ParseExceptionWithAdvice)e).original;
        }
        Token currentToken = e.currentToken;
        Token errorToken = currentToken.next != null ? currentToken.next : currentToken;
        SourceLocation location = Tokens.createSrcLoc(filePath, errorToken, new Token[0]);
        switch (errorToken.kind) {
            case 50: {
                reporter.report(location, UNEXPECTED_RIGHT_BRACE, new Object[0]);
                return;
            }
            case 42: 
            case 46: 
            case 47: 
            case 48: {
                reporter.report(location, UNEXPECTED_PARAM_DECL, new Object[0]);
                return;
            }
            case 154: 
            case 155: {
                if (!((String)optionalAdvice).isEmpty()) break;
                optionalAdvice = (String)optionalAdvice + ".\nNote: " + Tokens.getTokenDisplayName(errorToken.kind) + " is a reserved word in soy.";
                break;
            }
            case 165: {
                reporter.report(location, FOUND_DOUBLE_BRACE, new Object[0]);
                return;
            }
            case 166: {
                reporter.report(location, UNEXPECTED_CLOSE_TAG, new Object[0]);
                return;
            }
            case 123: {
                reporter.report(location, UNEXPECTED_NEWLINE, new Object[0]);
                return;
            }
            case 0: {
                errorToken.image = "eof";
                if (currentLexicalState == 8 || currentLexicalState == 9) {
                    optionalAdvice = (String)optionalAdvice + ". Did you forget to close an attribute?";
                    break;
                }
                if (currentLexicalState != 6 && currentLexicalState != 7) break;
                optionalAdvice = (String)optionalAdvice + ". Did you forget to close a comment?";
            }
        }
        ImmutableSet.Builder expectedTokenImages = ImmutableSet.builder();
        for (int[] expected : e.expectedTokenSequences) {
            String displayName = Tokens.getTokenDisplayName(expected[0]);
            if (displayName == null) continue;
            expectedTokenImages.add((Object)displayName);
        }
        reporter.report(location, PLAIN_ERROR, ParseErrors.formatParseExceptionDetails(errorToken.image, (List<String>)expectedTokenImages.build().asList()) + (String)optionalAdvice);
    }

    static void reportTokenMgrError(ErrorReporter reporter, SourceFilePath filePath, TokenMgrError exception) {
        SourceLocation location;
        int errorCode = exception.errorCode;
        String message = exception.getMessage();
        Matcher loc = EXTRACT_LOCATION.matcher(message);
        if (loc.find()) {
            int line = Integer.parseInt(loc.group(1));
            int column = Integer.parseInt(loc.group(2)) + 1;
            location = new SourceLocation(filePath, line, column, line, column);
        } else {
            location = new SourceLocation(filePath);
        }
        if (exception.errorCode == 0 && message.contains("<EOF>")) {
            reporter.report(location, UNEXPECTED_EOF, new Object[0]);
        } else {
            reporter.report(location, UNEXPECTED_TOKEN_MGR_ERROR, errorCode, message);
        }
    }

    private static String formatParseExceptionDetails(String errorToken, List<String> expectedTokens) {
        ImmutableSet.Builder normalizedTokensBuilder = ImmutableSet.builder();
        for (String t : expectedTokens) {
            normalizedTokensBuilder.add((Object)ParseErrors.maybeQuoteForParseError(t));
        }
        expectedTokens = normalizedTokensBuilder.build().asList();
        StringBuilder details = new StringBuilder();
        int numExpectedTokens = expectedTokens.size();
        if (numExpectedTokens != 0) {
            details.append(": expected ");
            for (int i = 0; i < numExpectedTokens; ++i) {
                details.append((String)expectedTokens.get(i));
                if (i < numExpectedTokens - 2) {
                    details.append(", ");
                }
                if (i != numExpectedTokens - 2) continue;
                if (numExpectedTokens > 2) {
                    details.append(',');
                }
                details.append(" or ");
            }
        }
        return String.format("parse error at '%s'%s", ParseErrors.escapeWhitespaceForErrorPrinting(errorToken), details);
    }

    private static String maybeQuoteForParseError(String token) {
        if (((String)token).length() > 1 && ((String)token).charAt(0) == '\"' && ((String)token).charAt(((String)token).length() - 1) == '\"') {
            token = ((String)token).substring(1, ((String)token).length() - 1);
        }
        if (TOKENS_TO_QUOTE.matches(((String)token).charAt(0)) || TOKENS_TO_QUOTE.matches(((String)token).charAt(((String)token).length() - 1))) {
            token = "'" + (String)token + "'";
        }
        return ParseErrors.escapeWhitespaceForErrorPrinting((String)token);
    }

    static String validateSelectCaseLabel(ExprNode caseValue, ErrorReporter reporter) {
        boolean isError;
        boolean isNumeric;
        String value;
        if (caseValue instanceof StringNode) {
            value = ((StringNode)caseValue).getValue();
            int argNumber = MessagePattern.validateArgumentName((String)value);
            if (argNumber != -1) {
                try {
                    Long.parseLong(value);
                    isNumeric = true;
                }
                catch (NumberFormatException nfe) {
                    isNumeric = false;
                }
                isError = true;
            } else {
                isNumeric = false;
                isError = false;
            }
        } else {
            isNumeric = caseValue instanceof FloatNode || caseValue instanceof IntegerNode;
            isError = true;
            value = "";
        }
        if (isError) {
            reporter.report(caseValue.getSourceLocation(), SELECT_CASE_INVALID_VALUE, isNumeric ? "  Did you mean to use {plural} instead of {select}?" : "");
        }
        return value;
    }

    private static String escapeWhitespaceForErrorPrinting(String s) {
        s = s.replace("\r", "\\r");
        s = s.replace("\n", "\\n");
        s = s.replace("\t", "\\t");
        return s;
    }
}

