/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.FileMetadata;
import com.google.template.soy.soytree.PartialFileMetadata;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.TemplateType;
import java.util.Collection;
import javax.annotation.Nullable;

public interface FileSetMetadata
extends PartialFileSetMetadata {
    @Nullable
    public TemplateMetadata getTemplate(String var1);

    default public TemplateMetadata getTemplate(TemplateNode node) {
        return (TemplateMetadata)Preconditions.checkNotNull((Object)this.getTemplate(node.getTemplateName()));
    }

    public DelTemplateSelector<TemplateMetadata> getDelTemplateSelector();

    @Override
    default public PartialFileMetadata getPartialFile(SourceLogicalPath path) {
        return this.getFile(path);
    }

    @Override
    default public Collection<? extends PartialFileMetadata> getAllPartialFiles() {
        return this.getAllFiles();
    }

    @Nullable
    public FileMetadata getFile(SourceLogicalPath var1);

    public Collection<? extends FileMetadata> getAllFiles();

    public Collection<TemplateMetadata> getAllTemplates();

    @Nullable
    default public TemplateMetadata getBasicTemplateOrElement(String templateFqn) {
        TemplateMetadata metadata = this.getTemplate(templateFqn);
        if (metadata == null) {
            return null;
        }
        TemplateType.TemplateKind kind = metadata.getTemplateType().getTemplateKind();
        return kind == TemplateType.TemplateKind.BASIC || kind == TemplateType.TemplateKind.ELEMENT ? metadata : null;
    }
}

