/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class HtmlTagNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode {
    private final TagName tagName;
    private final TagExistence tagExistence;
    private final boolean selfClosing;
    private final List<HtmlTagNode> taggedPairs = new ArrayList<HtmlTagNode>();

    protected HtmlTagNode(int id, SoyNode.StandaloneNode node, SourceLocation sourceLocation, TagExistence tagExistence, boolean selfClosing) {
        super(id, sourceLocation);
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkState((node.getParent() == null ? 1 : 0) != 0);
        this.addChild(node);
        this.tagName = HtmlTagNode.tagNameFromNode(node);
        this.tagExistence = tagExistence;
        this.selfClosing = selfClosing;
    }

    protected HtmlTagNode(HtmlTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.tagExistence = orig.tagExistence;
        if (this.numChildren() > 0) {
            SoyNode.StandaloneNode tagChild = (SoyNode.StandaloneNode)this.getChild(0);
            this.tagName = HtmlTagNode.tagNameFromNode(tagChild);
        } else {
            this.tagName = null;
        }
        copyState.updateRefs(orig, this);
        for (HtmlTagNode matchingNode : orig.taggedPairs) {
            copyState.registerRefListener(matchingNode, this.taggedPairs::add);
        }
        this.selfClosing = orig.selfClosing;
    }

    @Override
    public final SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    public final TagName getTagName() {
        return this.tagName;
    }

    public List<HtmlTagNode> getTaggedPairs() {
        return this.taggedPairs;
    }

    public void addTagPair(HtmlTagNode node) {
        if (!this.taggedPairs.contains(node)) {
            this.taggedPairs.add(node);
        }
    }

    public boolean hasUnpredictableTagLocation() {
        HtmlTagNode closeTag;
        ParentNode otherParent;
        if (!this.getTagName().isStatic()) {
            return true;
        }
        if (this.isSelfClosing() || this.getTagName().isDefinitelyVoid()) {
            return false;
        }
        if (this.getTaggedPairs().size() != 1 || this.getTaggedPairs().get(0).getTaggedPairs().size() != 1) {
            return true;
        }
        ParentNode parent = this.getParent();
        return parent != (otherParent = (closeTag = this.getTaggedPairs().get(0)).getParent());
    }

    public boolean isSynthetic() {
        return this.tagExistence == TagExistence.SYNTHETIC;
    }

    @Nullable
    public HtmlAttributeNode getDirectAttributeNamed(String attrName) {
        for (int i = 1; i < this.numChildren(); ++i) {
            HtmlAttributeNode attr;
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)this.getChild(i);
            if (!(child instanceof HtmlAttributeNode) || !(attr = (HtmlAttributeNode)child).definitelyMatchesAttributeName(attrName)) continue;
            return attr;
        }
        return null;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    private static TagName tagNameFromNode(SoyNode.StandaloneNode rawTextOrPrintNode) {
        Preconditions.checkState((rawTextOrPrintNode instanceof RawTextNode || rawTextOrPrintNode instanceof PrintNode ? 1 : 0) != 0);
        return rawTextOrPrintNode instanceof RawTextNode ? new TagName((RawTextNode)rawTextOrPrintNode) : new TagName((PrintNode)rawTextOrPrintNode);
    }

    public static enum TagExistence {
        IN_TEMPLATE,
        SYNTHETIC;

    }
}

