/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UndefinedType;
import java.util.Optional;
import javax.annotation.Nullable;

public final class TemplateBasicNode
extends TemplateNode {
    public static final SoyErrorKind INVALID_USEVARIANTTYPE = SoyErrorKind.of("Invalid type name \"{0}\" for attribute \"usevarianttype\". Must be \"number\", \"string\", or a proto enum.", new SoyErrorKind.StyleAllowance[0]);
    public static final String ATTR_USEVARIANTTYPE = "usevarianttype";
    public static final String ATTR_VARIANT = "variant";
    public static final String ATTR_MODIFIES = "modifies";
    private final boolean modifiable;
    private final CommandTagAttribute legacyDeltemplateNamespaceAttr;
    private final CommandTagAttribute useVariantTypeAttr;
    private String variantString = null;
    private SoyType useVariantType = null;

    TemplateBasicNode(TemplateBasicNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, Visibility visibility, boolean modifiable, @Nullable CommandTagAttribute legacyDeltemplateNamespaceAttr, @Nullable CommandTagAttribute useVariantTypeAttr, @Nullable ImmutableList<TemplateHeaderVarDefn> params) {
        super(nodeBuilder, "template", soyFileHeaderInfo, visibility, params);
        this.modifiable = modifiable;
        this.legacyDeltemplateNamespaceAttr = legacyDeltemplateNamespaceAttr;
        this.useVariantTypeAttr = useVariantTypeAttr;
    }

    private TemplateBasicNode(TemplateBasicNode orig, CopyState copyState) {
        super(orig, copyState);
        this.modifiable = orig.modifiable;
        this.legacyDeltemplateNamespaceAttr = copyState.copyNullable(orig.legacyDeltemplateNamespaceAttr);
        this.useVariantTypeAttr = copyState.copyNullable(orig.useVariantTypeAttr);
        this.useVariantType = orig.useVariantType;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getTemplateName();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_BASIC_NODE;
    }

    @Override
    public TemplateBasicNode copy(CopyState copyState) {
        return new TemplateBasicNode(this, copyState);
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    private Optional<CommandTagAttribute> getCommandTagAttribute(String name) {
        return this.getAttributes().stream().filter(a -> name.equals(a.getName().identifier())).findFirst();
    }

    private Optional<CommandTagAttribute> getCommandTagAttributeExpr(String name) {
        return this.getCommandTagAttribute(name).map(a -> a.hasExprValue() ? a : null);
    }

    @Nullable
    public ExprRootNode getModifiesExpr() {
        return this.getCommandTagAttributeExpr(ATTR_MODIFIES).map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    public String getLegacyDeltemplateNamespace() {
        return this.legacyDeltemplateNamespaceAttr != null ? this.legacyDeltemplateNamespaceAttr.getValue() : "";
    }

    @Nullable
    public ExprRootNode getVariantExpr() {
        return this.getCommandTagAttributeExpr(ATTR_VARIANT).map(a -> (ExprRootNode)a.valueAsExprList().get(0)).orElse(null);
    }

    private static boolean isValidVariantType(SoyType type) {
        return type.equals(SoyTypes.NUMBER_TYPE) || type.equals(StringType.getInstance()) || type.getKind().equals((Object)SoyType.Kind.PROTO_ENUM);
    }

    public void resolveUseVariantType(SoyTypeRegistry registry, ErrorReporter errorReporter) {
        Preconditions.checkState((this.useVariantType == null ? 1 : 0) != 0);
        if (this.useVariantTypeAttr == null) {
            this.useVariantType = UndefinedType.getInstance();
            return;
        }
        SoyType resolvedType = registry.getType(this.useVariantTypeAttr.getValue());
        if (resolvedType == null || !TemplateBasicNode.isValidVariantType(resolvedType)) {
            errorReporter.report(this.getCommandTagAttribute(ATTR_USEVARIANTTYPE).map(CommandTagAttribute::getSourceLocation).orElse(this.getSourceLocation()), INVALID_USEVARIANTTYPE, this.useVariantTypeAttr.getValue());
            this.useVariantType = UndefinedType.getInstance();
        } else {
            this.useVariantType = resolvedType;
        }
    }

    @Nullable
    public CommandTagAttribute getUseVariantTypeAttribute() {
        return this.useVariantTypeAttr;
    }

    public SoyType getUseVariantType() {
        Preconditions.checkNotNull((Object)this.useVariantType, (Object)"if usevarianttype is set, resolveUseVariantType() needs to be called to resolve the type before getUseVariantType() is used");
        return this.useVariantType;
    }

    public String getDelTemplateVariant() {
        if (this.getVariantExpr() == null) {
            this.variantString = "";
            return this.variantString;
        }
        if (this.variantString != null) {
            return this.variantString;
        }
        return this.resolveVariantExpression();
    }

    private String resolveVariantExpression() {
        this.variantString = TemplateNode.variantExprToString(this.getVariantExpr().getRoot());
        return this.variantString;
    }

    @Nullable
    public String moddedSoyNamespace() {
        TemplateLiteralNode templateLiteralNode;
        SoyType nodeType;
        if (this.getModifiesExpr() != null && this.getModName() != null && this.getModifiesExpr().getRoot() instanceof TemplateLiteralNode && (nodeType = (templateLiteralNode = (TemplateLiteralNode)this.getModifiesExpr().getRoot()).getType()) instanceof TemplateType && ((TemplateType)nodeType).getLegacyDeltemplateNamespace().isEmpty()) {
            return templateLiteralNode.getResolvedName().substring(0, templateLiteralNode.getResolvedName().lastIndexOf("."));
        }
        return null;
    }

    @Nullable
    public String deltemplateAnnotationName() {
        TemplateLiteralNode templateLiteralNode;
        SoyType nodeType;
        if (this.isModifiable()) {
            return !this.getLegacyDeltemplateNamespace().isEmpty() ? this.getLegacyDeltemplateNamespace() : null;
        }
        if (this.getModifiesExpr() != null && this.getModifiesExpr().getRoot() instanceof TemplateLiteralNode && (nodeType = (templateLiteralNode = (TemplateLiteralNode)this.getModifiesExpr().getRoot()).getType()) instanceof TemplateType) {
            String legacyNamespace = ((TemplateType)nodeType).getLegacyDeltemplateNamespace();
            return !legacyNamespace.isEmpty() ? legacyNamespace : null;
        }
        return null;
    }
}

