/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.List;
import javax.annotation.Nullable;

public class TemplateDelegateNodeBuilder
extends TemplateNodeBuilder<TemplateDelegateNodeBuilder> {
    private String delTemplateName;
    private ExprRootNode delTemplateVariantExpr;
    private TemplateNode.Priority delPriority;

    public TemplateDelegateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    @CanIgnoreReturnValue
    public TemplateDelegateNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        this.delTemplateName = templateName.identifier();
        block6: for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            if (COMMON_ATTRIBUTE_NAMES.contains((Object)name.identifier())) continue;
            switch (name.identifier()) {
                case "variant": {
                    this.delTemplateVariantExpr = attribute.valueAsExpr(this.errorReporter);
                    continue block6;
                }
            }
            this.errorReporter.report(name.location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name.identifier(), "deltemplate", ImmutableList.builder().addAll((Iterable)COMMON_ATTRIBUTE_NAMES).add((Object)"variant").build());
        }
        this.delPriority = this.soyFileHeaderInfo.getPriority();
        this.genInternalTemplateNameHelper(templateName);
        return this;
    }

    private void genInternalTemplateNameHelper(Identifier originalNameIdentifier) {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0);
        String variant = "";
        if (this.delTemplateVariantExpr != null) {
            ExprNode expr = this.delTemplateVariantExpr.getRoot();
            variant = expr instanceof StringNode ? ((StringNode)expr).getValue() : expr.toSourceString();
        }
        String generatedPartialTemplateName = TemplateDelegateNodeBuilder.partialDeltemplateTemplateName(this.delTemplateName, this.soyFileHeaderInfo.getModName(), variant);
        this.setTemplateNames(Identifier.create(generatedPartialTemplateName, originalNameIdentifier.identifier(), originalNameIdentifier.location()), this.soyFileHeaderInfo.getNamespace());
    }

    public static String partialDeltemplateTemplateName(String delTemplateName, @Nullable String modName, String variant) {
        Object modTemplateAndVariantStr = (modName == null ? "" : modName) + "_" + delTemplateName.replace('.', '_') + "_" + variant;
        modTemplateAndVariantStr = ((String)modTemplateAndVariantStr).replace('.', '_');
        return "__deltemplate_" + (String)modTemplateAndVariantStr;
    }

    public static boolean isDeltemplateTemplateName(String templateName) {
        return templateName.startsWith("__deltemplate_");
    }

    @Override
    public TemplateDelegateNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        return new TemplateDelegateNode(this, this.soyFileHeaderInfo, this.delTemplateName, this.delPriority, (ImmutableList<TemplateHeaderVarDefn>)this.params);
    }

    @Override
    protected TemplateDelegateNodeBuilder self() {
        return this;
    }
}

