/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.List;

public final class TemplateElementNodeBuilder
extends TemplateNodeBuilder<TemplateElementNodeBuilder> {
    static final ImmutableSet<String> BANNED_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"autoescape", (Object)"stricthtml", (Object)"visibility");
    private static final SoyErrorKind BANNED_ATTRIBUTE_NAMES_ERROR = SoyErrorKind.of("Attribute ''{0}'' is not allowed on Soy elements.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_ELEMENT_KIND = SoyErrorKind.of("Soy element kind must be html or html<...>.", new SoyErrorKind.StyleAllowance[0]);
    private List<CommandTagAttribute> attrs = ImmutableList.of();

    public TemplateElementNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    @CanIgnoreReturnValue
    public TemplateElementNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.attrs = attrs;
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        block6: for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            switch (name.identifier()) {
                case "kind": {
                    if (this.getContentKind().getSanitizedContentKind().isHtml()) continue block6;
                    this.errorReporter.report(attribute.getValueLocation(), INVALID_ELEMENT_KIND, new Object[0]);
                    continue block6;
                }
            }
            if (BANNED_ATTRIBUTE_NAMES.contains((Object)name.identifier())) {
                this.errorReporter.report(name.location(), BANNED_ATTRIBUTE_NAMES_ERROR, name.identifier());
                continue;
            }
            if (COMMON_ATTRIBUTE_NAMES.contains((Object)name.identifier())) continue;
            this.errorReporter.report(name.location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name.identifier(), "element", ImmutableList.builder().addAll((Iterable)COMMON_ATTRIBUTE_NAMES.stream().filter(n -> !BANNED_ATTRIBUTE_NAMES.contains(n)).collect(ImmutableList.toImmutableList())).build());
        }
        this.setTemplateNames(templateName, this.soyFileHeaderInfo.getNamespace());
        return this;
    }

    @Override
    public TemplateElementNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        return new TemplateElementNode(this, this.soyFileHeaderInfo, (ImmutableList<TemplateHeaderVarDefn>)this.params);
    }

    @Override
    protected TemplateElementNodeBuilder self() {
        return this;
    }
}

