/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.defn;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.ast.TypeNode;
import javax.annotation.Nullable;

public final class TemplateStateVar
extends AbstractVarDefn
implements TemplateHeaderVarDefn {
    private String desc;
    private final SourceLocation sourceLocation;
    @Nullable
    private final TypeNode typeNode;
    private final ExprRootNode initialValue;

    public TemplateStateVar(String name, @Nullable TypeNode typeNode, @Nullable ExprNode initialValue, @Nullable String desc, @Nullable SourceLocation nameLocation, SourceLocation sourceLocation) {
        super(name, nameLocation, null);
        this.desc = desc;
        this.initialValue = initialValue == null ? new ExprRootNode(new UndefinedNode(SourceLocation.UNKNOWN)) : new ExprRootNode(initialValue);
        this.sourceLocation = sourceLocation;
        this.typeNode = typeNode;
    }

    private TemplateStateVar(TemplateStateVar old, CopyState copyState) {
        super(old);
        this.typeNode = old.typeNode == null ? null : old.typeNode.copy();
        this.desc = old.desc;
        this.initialValue = old.initialValue.copy(copyState);
        this.sourceLocation = old.sourceLocation;
        copyState.updateRefs(old.initialValue, this.initialValue);
    }

    @Override
    public String refName() {
        return "$" + this.name();
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public TypeNode getTypeNode() {
        return this.typeNode;
    }

    @Override
    public ExprRootNode defaultValue() {
        return this.initialValue;
    }

    public boolean hasExplicitDefaultValue() {
        return !(this.initialValue.getRoot() instanceof UndefinedNode);
    }

    @Override
    public VarDefn.Kind kind() {
        return VarDefn.Kind.STATE;
    }

    @Override
    public boolean isInjected() {
        return false;
    }

    @Override
    public void setType(SoyType type) {
        if (this.type != null) {
            throw new IllegalStateException("type has already been set.");
        }
        this.type = type;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean isExplicitlyOptional() {
        return false;
    }

    @Override
    @Nullable
    public String desc() {
        return this.desc;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String toString() {
        String description = this.getClass().getSimpleName() + "{name = " + this.name() + ", desc = " + this.desc + "}";
        return description;
    }

    @Override
    public TemplateStateVar copy(CopyState copyState) {
        return new TemplateStateVar(this, copyState);
    }
}

