/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import java.util.Objects;

public final class ListType
extends SoyType {
    public static final ListType EMPTY_LIST = new ListType(null);
    public static final ListType ANY_LIST = new ListType(AnyType.getInstance());
    private final SoyType elementType;

    private ListType(SoyType elementType) {
        this.elementType = elementType;
    }

    public static ListType of(SoyType elementType) {
        Preconditions.checkNotNull((Object)elementType);
        return new ListType(elementType);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.LIST;
    }

    public SoyType getElementType() {
        return this.elementType;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType srcType, SoyType.UnknownAssignmentPolicy policy) {
        if (srcType.getKind() == SoyType.Kind.LIST) {
            ListType srcListType = (ListType)srcType;
            if (srcListType == EMPTY_LIST) {
                return true;
            }
            if (this == EMPTY_LIST) {
                return false;
            }
            return this.elementType.isAssignableFromInternal(srcListType.elementType, policy);
        }
        return false;
    }

    @Override
    public String toString() {
        return "list<" + String.valueOf(this.elementType) + ">";
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        builder.setListElement(this.elementType.toProto());
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && Objects.equals(((ListType)other).elementType, this.elementType);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.elementType);
    }

    @Override
    public <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

