/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.internal.proto.FieldVisitor;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.ProtoTypeRegistry;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TypeInterner;
import com.google.template.soy.types.TypeRegistries;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class SoyProtoType
extends SoyType {
    private final Object scope;
    private final Descriptors.Descriptor typeDescriptor;
    private final ImmutableMap<String, FieldWithType> fields;
    private final ImmutableSet<String> extensionFieldNames;

    public static SoyProtoType newForTest(Descriptors.Descriptor d) {
        return new SoyProtoType(TypeRegistries.newTypeInterner(), fqn -> null, d, (Set<Descriptors.FieldDescriptor>)ImmutableSet.of());
    }

    SoyProtoType(TypeInterner interner, ProtoTypeRegistry registry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this.scope = interner;
        this.typeDescriptor = descriptor;
        this.fields = Field.getFieldsForType(descriptor, extensions, fieldDescriptor -> new FieldWithType(fieldDescriptor, interner, registry));
        this.extensionFieldNames = (ImmutableSet)extensions.stream().map(Field::computeSoyFullyQualifiedName).sorted().collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType fromType) {
        return fromType == this;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.typeDescriptor;
    }

    public String getDescriptorExpression() {
        return ProtoUtils.getQualifiedOuterClassname((Descriptors.GenericDescriptor)this.typeDescriptor);
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(String fieldName) {
        FieldWithType field = (FieldWithType)this.fields.get((Object)fieldName);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Cannot find field %s in %s. Known fields are %s.", fieldName, this, this.getFieldNames()));
        }
        return field.getDescriptor();
    }

    @Nullable
    public SoyType getFieldType(String fieldName) {
        FieldWithType field = (FieldWithType)this.fields.get((Object)fieldName);
        return field != null ? field.getType() : null;
    }

    @Nullable
    public SoyType getFieldSetterType(String fieldName) {
        FieldWithType field = (FieldWithType)this.fields.get((Object)fieldName);
        return field != null ? field.getSetterType() : null;
    }

    public ImmutableSet<String> getFieldNames() {
        return this.fields.keySet();
    }

    public ImmutableSet<String> getExtensionFieldNames() {
        return this.extensionFieldNames;
    }

    public String getJsName(ProtoUtils.MutabilityMode mutabilityMode) {
        return ProtoUtils.calculateUnprefixedJsName((Descriptors.GenericDescriptor)this.typeDescriptor);
    }

    @Override
    public String toString() {
        return this.typeDescriptor.getFullName();
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        builder.setProto(this.typeDescriptor.getFullName());
    }

    @Override
    public <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoyProtoType that = (SoyProtoType)o;
        if (this.scope != that.scope) {
            throw new IllegalArgumentException(String.format("Illegal comparison of two SoyProtoType's from different type registries %s and %s.", this.scope, that.scope));
        }
        return com.google.common.base.Objects.equal((Object)this.typeDescriptor.getFullName(), (Object)that.typeDescriptor.getFullName());
    }

    public int hashCode() {
        return Objects.hashCode(this.typeDescriptor.getFullName());
    }

    private static final class FieldWithType
    extends Field {
        @GuardedBy(value="this")
        SoyType type;
        @GuardedBy(value="this")
        SoyType setterType;
        @GuardedBy(value="this")
        private final TypeInterner interner;
        private final ProtoTypeRegistry registry;

        FieldWithType(Descriptors.FieldDescriptor fieldDesc, TypeInterner interner, ProtoTypeRegistry registry) {
            super(fieldDesc);
            this.interner = interner;
            this.registry = registry;
        }

        synchronized SoyType getType() {
            if (this.type == null) {
                this.type = FieldVisitor.visitField(this.getDescriptor(), new TypeVisitor(this.interner, this.registry, false));
                Preconditions.checkNotNull((Object)this.type, (String)"Couldn't find a type for: %s", (Object)this.getDescriptor());
            }
            return this.type;
        }

        synchronized SoyType getSetterType() {
            if (this.setterType == null) {
                this.setterType = FieldVisitor.visitField(this.getDescriptor(), new TypeVisitor(this.interner, this.registry, true));
                Preconditions.checkNotNull((Object)this.setterType, (String)"Couldn't find a setter type for: %s", (Object)this.getDescriptor());
            }
            return this.setterType;
        }
    }

    private static final class TypeVisitor
    extends FieldVisitor<SoyType> {
        private final TypeInterner interner;
        private final ProtoTypeRegistry registry;
        private final boolean setterField;

        TypeVisitor(TypeInterner interner, ProtoTypeRegistry registry, boolean setterField) {
            this.interner = interner;
            this.registry = registry;
            this.setterField = setterField;
        }

        @Override
        protected SoyType visitMap(Descriptors.FieldDescriptor mapField, SoyType keyType, SoyType valueType) {
            return this.interner.getOrCreateMapType(keyType, SoyTypes.tryRemoveNullish(valueType));
        }

        @Override
        protected SoyType visitRepeated(SoyType value) {
            return this.interner.getOrCreateListType(SoyTypes.tryRemoveNullish(value));
        }

        @Override
        protected SoyType visitMessage(Descriptors.Descriptor messageType) {
            return this.interner.getOrCreateNullishType(this.registry.getProtoType(messageType.getFullName()));
        }

        @Override
        protected SoyType visitEnum(Descriptors.EnumDescriptor enumType, Descriptors.FieldDescriptor fieldType) {
            return this.registry.getProtoType(enumType.getFullName());
        }

        @Override
        protected SoyType visitLongAsInt() {
            return this.setterField ? SoyTypes.NUMBER_TYPE : IntType.getInstance();
        }

        @Override
        protected SoyType visitUnsignedInt() {
            return this.setterField ? SoyTypes.NUMBER_TYPE : IntType.getInstance();
        }

        @Override
        protected SoyType visitUnsignedLongAsString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitLongAsString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitBool() {
            return BoolType.getInstance();
        }

        @Override
        protected SoyType visitInt() {
            return this.setterField ? SoyTypes.NUMBER_TYPE : IntType.getInstance();
        }

        @Override
        protected SoyType visitBytes() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitDoubleAsFloat() {
            return this.setterField ? SoyTypes.NUMBER_TYPE : FloatType.getInstance();
        }

        @Override
        protected SoyType visitFloat() {
            return this.setterField ? SoyTypes.NUMBER_TYPE : FloatType.getInstance();
        }

        @Override
        protected SoyType visitSafeHtml() {
            return this.interner.getOrCreateNullishType(SanitizedType.HtmlType.getInstance());
        }

        @Override
        protected SoyType visitSafeScript() {
            return this.interner.getOrCreateNullishType(SanitizedType.JsType.getInstance());
        }

        @Override
        protected SoyType visitSafeStyle() {
            return this.interner.getOrCreateNullishType(SanitizedType.StyleType.getInstance());
        }

        @Override
        protected SoyType visitSafeStyleSheet() {
            return this.interner.getOrCreateNullishType(SanitizedType.StyleType.getInstance());
        }

        @Override
        protected SoyType visitSafeUrl() {
            return this.interner.getOrCreateNullishType(SanitizedType.UriType.getInstance());
        }

        @Override
        protected SoyType visitTrustedResourceUrl() {
            return this.interner.getOrCreateNullishType(SanitizedType.TrustedResourceUriType.getInstance());
        }
    }
}

