/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnknownType;
import java.util.HashSet;
import java.util.Set;

public final class TemplateBindingUtil {
    private static final SoyErrorKind PARAMETER_NAME_MISMATCH = SoyErrorKind.of("Cannot bind parameter named `{0}` to template of type `{1}`; no such parameter.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PARAMETER_TYPE_MISMATCH = SoyErrorKind.of("Cannot bind parameter named `{0}` to template of type `{1}`; expected `{2}` but found `{3}`.", new SoyErrorKind.StyleAllowance[0]);

    public static SoyType bindParameters(SoyType base, RecordType parameterType, SoyTypeRegistry typeRegistry, ErrorReporter.LocationBound errorReporter) {
        Preconditions.checkArgument((boolean)SoyTypes.isKindOrUnionOfKinds(base, (Set<SoyType.Kind>)ImmutableSet.of((Object)((Object)SoyType.Kind.TEMPLATE), (Object)((Object)SoyType.Kind.TEMPLATE_TYPE))));
        HashSet<SoyType> types = new HashSet<SoyType>();
        block3: for (SoyType baseType : SoyTypes.expandUnions(base)) {
            switch (baseType.getKind()) {
                case TEMPLATE: {
                    types.add(TemplateBindingUtil.bindParametersToTemplate((TemplateType)baseType, parameterType, typeRegistry, errorReporter));
                    continue block3;
                }
            }
            throw new AssertionError();
        }
        return typeRegistry.getOrCreateUnionType(types);
    }

    private static SoyType bindParametersToTemplate(TemplateType base, RecordType parameters, SoyTypeRegistry typeRegistry, ErrorReporter.LocationBound errorReporter) {
        HashSet unboundParameters = new HashSet(base.getParameterMap().keySet());
        boolean reportedErrors = false;
        TemplateType.Builder builder = base.toBuilder();
        for (RecordType.Member member : parameters.getMembers()) {
            if (base.getParameter(member.name()) == null) {
                if (member.name().equals("extraRootElementAttributes") && base.getAllowExtraAttributes()) {
                    builder.setAllowExtraAttributes(false);
                    continue;
                }
                String didYouMeanMessage = SoyErrors.getDidYouMeanMessage((Iterable<String>)base.getParameterMap().keySet(), member.name());
                errorReporter.report(PARAMETER_NAME_MISMATCH, member.name(), base, didYouMeanMessage);
                reportedErrors = true;
                continue;
            }
            if (!base.getParameter(member.name()).getCheckedType().isAssignableFromLoose(member.checkedType())) {
                errorReporter.report(PARAMETER_TYPE_MISMATCH, member.name(), base, base.getParameter(member.name()).getCheckedType(), member.checkedType());
                reportedErrors = true;
            }
            unboundParameters.remove(member.name());
        }
        if (reportedErrors) {
            return UnknownType.getInstance();
        }
        ImmutableList newParameters = (ImmutableList)base.getParameters().stream().filter(parameter -> unboundParameters.contains(parameter.getName())).collect(ImmutableList.toImmutableList());
        builder.setIdentifierForDebugging(TemplateType.stringRepresentation((Iterable<TemplateType.Parameter>)newParameters, base.getContentKind(), (ImmutableSet<String>)ImmutableSet.of()));
        builder.setParameters((ImmutableList<TemplateType.Parameter>)newParameters);
        return typeRegistry.internTemplateType(builder.build());
    }

    private TemplateBindingUtil() {
    }
}

