/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.CaseFormat;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.soytree.ParameterP;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.$AutoValue_TemplateType;
import com.google.template.soy.types.AutoValue_TemplateType_DataAllCallSituation;
import com.google.template.soy.types.AutoValue_TemplateType_Parameter;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class TemplateType
extends SoyType {
    public static final String EXTRA_ROOT_ELEMENT_ATTRIBUTES = "extraRootElementAttributes";
    public static final String KEY_HIDDEN_ATTRIBUTE_NAME = "ssk";
    private static final Parameter EXTRA_ROOT_ELEMENT_ATTRIBUTES_PARAM = Parameter.builder().setName("extraRootElementAttributes").setType(SanitizedType.AttributesType.getInstance()).setKind(ParameterKind.PARAM).setRequired(false).setImplicit(true).build();
    private static final Parameter KEY_HIDDEN_ATTRIBUTE = Parameter.builder().setName("ssk").setType(StringType.getInstance()).setKind(ParameterKind.ATTRIBUTE).setRequired(false).setImplicit(true).build();

    public abstract boolean getAllowExtraAttributes();

    public boolean getAllowExtraAttributesOrExplicit() {
        return this.getAllowExtraAttributes() || this.getParameters().stream().anyMatch(p -> p.getName().equals(EXTRA_ROOT_ELEMENT_ATTRIBUTES));
    }

    public abstract ImmutableSet<String> getReservedAttributes();

    public abstract TemplateKind getTemplateKind();

    public abstract TemplateContentKind getContentKind();

    public abstract boolean isStrictHtml();

    public abstract ImmutableList<Parameter> getParameters();

    @Memoized
    public ImmutableList<Parameter> getActualParameters() {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(this.getParameters());
        if (this.getContentKind() instanceof TemplateContentKind.ElementContentKind) {
            builder.add((Object)KEY_HIDDEN_ATTRIBUTE);
        }
        if (this.getAllowExtraAttributes()) {
            builder.add((Object)EXTRA_ROOT_ELEMENT_ATTRIBUTES_PARAM);
        }
        return builder.build();
    }

    @Memoized
    public ImmutableMap<String, Parameter> getParameterMap() {
        return (ImmutableMap)this.getParameters().stream().collect(ImmutableMap.toImmutableMap(Parameter::getName, p -> p));
    }

    @Nullable
    public final Parameter getParameter(String name) {
        return (Parameter)this.getParameterMap().get((Object)name);
    }

    public abstract ImmutableList<DataAllCallSituation> getDataAllCallSituations();

    public abstract String getIdentifierForDebugging();

    public abstract SoyType getUseVariantType();

    public abstract boolean isModifiable();

    public abstract boolean isModifying();

    public abstract String getLegacyDeltemplateNamespace();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_TemplateType.Builder().setModifiable(false).setModifying(false).setLegacyDeltemplateNamespace("");
    }

    public static TemplateType declaredTypeOf(Iterable<Parameter> parameters, SoyType returnType, SoyType useVariantType, boolean isModifiable, boolean isModifying, String legacyDeltemplateNamespace) {
        TemplateContentKind templateContentKind = TemplateType.fromType(returnType);
        SanitizedContentKind contentKind = templateContentKind.getSanitizedContentKind();
        return TemplateType.builder().setTemplateKind(TemplateKind.BASIC).setContentKind(templateContentKind).setStrictHtml(contentKind.isHtml()).setParameters((ImmutableList<Parameter>)ImmutableList.copyOf(parameters)).setDataAllCallSituations((ImmutableList<DataAllCallSituation>)ImmutableList.of()).setIdentifierForDebugging(TemplateType.stringRepresentation(parameters, templateContentKind, (ImmutableSet<String>)ImmutableSet.of())).setAllowExtraAttributes(false).setReservedAttributes((ImmutableSet<String>)ImmutableSet.of()).setUseVariantType(useVariantType).setModifiable(isModifiable).setModifying(isModifying).setLegacyDeltemplateNamespace(legacyDeltemplateNamespace).build();
    }

    public static TemplateContentKind fromType(SoyType type) {
        if (type instanceof SanitizedType.ElementType) {
            return TemplateContentKind.ElementContentKind.valueOf(((SanitizedType.ElementType)type).getTagName());
        }
        if (type instanceof SanitizedType) {
            return TemplateContentKind.fromSanitizedContentKind(((SanitizedType)type).getContentKind());
        }
        return TemplateContentKind.fromSanitizedContentKind(SanitizedContentKind.TEXT);
    }

    @Override
    public final SoyType.Kind getKind() {
        return SoyType.Kind.TEMPLATE;
    }

    @Override
    final boolean doIsAssignableFromNonUnionType(SoyType srcType, SoyType.UnknownAssignmentPolicy unknownPolicy) {
        if (srcType.getKind() != SoyType.Kind.TEMPLATE) {
            return false;
        }
        TemplateType srcTemplate = (TemplateType)srcType;
        ImmutableMap thisParams = (ImmutableMap)this.getParameters().stream().collect(ImmutableMap.toImmutableMap(Parameter::getName, (Function)Functions.identity()));
        ImmutableMap srcParams = (ImmutableMap)srcTemplate.getParameters().stream().collect(ImmutableMap.toImmutableMap(Parameter::getName, (Function)Functions.identity()));
        for (Parameter thisParam : this.getParameters()) {
            if (srcParams.containsKey((Object)thisParam.getName())) continue;
            return false;
        }
        for (Parameter srcParam : srcTemplate.getParameters()) {
            Parameter thisParam = (Parameter)thisParams.get((Object)srcParam.getName());
            if (thisParam == null) {
                if (!srcParam.isRequired()) continue;
                return false;
            }
            if (srcParam.isRequired() && !thisParam.isRequired()) {
                return false;
            }
            if (srcParam.getCheckedType().isAssignableFromInternal(thisParam.getCheckedType(), unknownPolicy)) continue;
            return false;
        }
        return this.getContentKind().isAssignableFrom(srcTemplate.getContentKind());
    }

    @Override
    public final String toString() {
        return TemplateType.stringRepresentation(this.getParameters(), this.getContentKind(), this.getReservedAttributes());
    }

    static String stringRepresentation(Iterable<Parameter> parameters, TemplateContentKind contentKind, ImmutableSet<String> reservedAttributes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Parameter parameter : parameters) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object name = parameter.getName();
            if (parameter.getKind() == ParameterKind.ATTRIBUTE) {
                name = "@" + Parameter.paramToAttrName((String)name);
            }
            sb.append((String)name);
            if (!parameter.isRequired()) {
                sb.append("?");
            }
            sb.append(": ");
            sb.append(parameter.getTypeStringRepresentation());
        }
        if (!reservedAttributes.isEmpty()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("*-{").append(reservedAttributes.stream().map(a -> "@" + a).collect(Collectors.joining(", "))).append("}");
        }
        sb.append(") => ");
        sb.append(contentKind.asAttributeValue());
        return sb.toString();
    }

    @Override
    final void doToProto(SoyTypeP.Builder builder) {
        SoyTypeP.TemplateTypeP.Builder templateBuilder = builder.getTemplateBuilder();
        for (Parameter parameter : this.getParameters()) {
            templateBuilder.addParameter(ParameterP.newBuilder().setName(parameter.getName()).setKind(parameter.getKind().toProto()).setType(parameter.getType().toProto()).setRequired(parameter.isRequired()).setImplicit(parameter.isImplicit()).build());
        }
        SoyTypeP returnType = TemplateType.templateContentKindToType(this.getContentKind()).toProto();
        if (this.getAllowExtraAttributes()) {
            returnType = SoyTypeP.newBuilder(returnType).setHtml(returnType.getHtml().toBuilder().setAllowExtraAttributes(true).addAllReservedAttributes((Iterable<String>)this.getReservedAttributes())).build();
        }
        templateBuilder.setUseVariantType(this.getUseVariantType().toProto());
        templateBuilder.setIsModifiable(this.isModifiable());
        templateBuilder.setIsModifying(this.isModifying());
        templateBuilder.setLegacyDeltemplateNamespace(this.getLegacyDeltemplateNamespace());
        templateBuilder.setReturnType(returnType);
    }

    private static SoyType templateContentKindToType(TemplateContentKind kind) {
        if (kind instanceof TemplateContentKind.ElementContentKind) {
            return SanitizedType.ElementType.getInstance(((TemplateContentKind.ElementContentKind)kind).getTagName());
        }
        return SanitizedType.getTypeForContentKind(kind.getSanitizedContentKind());
    }

    @Override
    public final <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @AutoValue
    public static abstract class DataAllCallSituation {
        public static Builder builder() {
            return new AutoValue_TemplateType_DataAllCallSituation.Builder();
        }

        public abstract String getTemplateName();

        public abstract boolean isDelCall();

        public abstract ImmutableSet<String> getExplicitlyPassedParameters();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setTemplateName(String var1);

            public abstract Builder setDelCall(boolean var1);

            public abstract Builder setExplicitlyPassedParameters(ImmutableSet<String> var1);

            public abstract DataAllCallSituation build();
        }
    }

    @AutoValue
    public static abstract class Parameter {
        private static final Pattern ATTR_NAME = Pattern.compile("^[a-z_][a-z_\\d]*(-[a-z_\\d]+)*$");

        public static String attrToParamName(String attrName) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, attrName);
        }

        public static String paramToAttrName(String paramName) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, paramName);
        }

        public static boolean isValidAttrName(String attrName) {
            return ATTR_NAME.matcher(attrName).matches();
        }

        public static Builder builder() {
            return new AutoValue_TemplateType_Parameter.Builder();
        }

        public abstract String getName();

        public abstract ParameterKind getKind();

        public SoyType getType() {
            return this.getTypeWrapper().getType();
        }

        public SoyType getCheckedType() {
            SoyType type = this.getType();
            if (!this.isRequired()) {
                type = SoyTypes.makeUndefinable(type);
            }
            return type;
        }

        String getTypeStringRepresentation() {
            return this.getType().toString();
        }

        abstract LazyTypeWrapper getTypeWrapper();

        public abstract boolean isRequired();

        public abstract boolean isImplicit();

        @Nullable
        public abstract String getDescription();

        public abstract Builder toBuilder();

        public Parameter toComparable() {
            return this.getDescription() == null ? this : this.toBuilder().setDescription(null).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public Builder setTypeLazily(Supplier<SoyType> typeSupplier) {
                return this.setTypeWrapper(LazyTypeWrapper.fromSupplier(typeSupplier));
            }

            public Builder setType(SoyType type) {
                return this.setTypeWrapper(LazyTypeWrapper.constant(type));
            }

            public abstract Builder setKind(ParameterKind var1);

            abstract Builder setTypeWrapper(LazyTypeWrapper var1);

            public abstract Builder setRequired(boolean var1);

            public abstract Builder setImplicit(boolean var1);

            public abstract Builder setDescription(String var1);

            public abstract Parameter build();
        }

        static abstract class LazyTypeWrapper {
            LazyTypeWrapper() {
            }

            static LazyTypeWrapper constant(final SoyType type) {
                return new LazyTypeWrapper(){

                    @Override
                    SoyType getType() {
                        return type;
                    }
                };
            }

            static LazyTypeWrapper fromSupplier(final Supplier<SoyType> typeSupplier) {
                return new LazyTypeWrapper(){
                    @LazyInit
                    SoyType type;

                    @Override
                    SoyType getType() {
                        SoyType local = this.type;
                        if (local == null) {
                            local = (SoyType)typeSupplier.get();
                            if (local == null) {
                                throw new IllegalStateException("typeSupplier returned null");
                            }
                            this.type = local;
                        }
                        return local;
                    }
                };
            }

            @ForOverride
            abstract SoyType getType();

            public final int hashCode() {
                return this.getType().hashCode();
            }

            public final boolean equals(Object other) {
                return other instanceof LazyTypeWrapper && ((LazyTypeWrapper)other).getType().equals(this.getType());
            }

            public String toString() {
                return this.getType().toString();
            }
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setAllowExtraAttributes(boolean var1);

        public abstract Builder setReservedAttributes(ImmutableSet<String> var1);

        public abstract Builder setTemplateKind(TemplateKind var1);

        public abstract Builder setContentKind(TemplateContentKind var1);

        public abstract Builder setStrictHtml(boolean var1);

        public abstract Builder setParameters(ImmutableList<Parameter> var1);

        public abstract Builder setDataAllCallSituations(ImmutableList<DataAllCallSituation> var1);

        public abstract Builder setIdentifierForDebugging(String var1);

        public abstract Builder setUseVariantType(SoyType var1);

        public abstract Builder setModifiable(boolean var1);

        public abstract Builder setModifying(boolean var1);

        public abstract Builder setLegacyDeltemplateNamespace(String var1);

        public abstract TemplateType build();
    }

    public static enum ParameterKind {
        PARAM,
        ATTRIBUTE;


        public ParameterP.KindP toProto() {
            return ParameterP.KindP.valueOf(this.name());
        }

        public static ParameterKind fromProto(ParameterP.KindP proto) {
            if (proto == null || proto == ParameterP.KindP.DEFAULT) {
                return PARAM;
            }
            return ParameterKind.valueOf(proto.name());
        }
    }

    public static enum TemplateKind {
        BASIC,
        DELTEMPLATE,
        ELEMENT;

    }
}

