/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;

public final class UnionType
extends SoyType {
    private static final Comparator<SoyType> MEMBER_ORDER = Comparator.comparing(SoyType::toString);
    private final ImmutableSortedSet<SoyType> members;

    private UnionType(Iterable<? extends SoyType> members) {
        this.members = ImmutableSortedSet.copyOf(MEMBER_ORDER, members);
        Preconditions.checkArgument((this.members.size() != 1 ? 1 : 0) != 0);
        for (SoyType type : this.members) {
            if (type.getKind() != SoyType.Kind.UNKNOWN) continue;
            throw new IllegalArgumentException("Cannot create unions containing unknown: " + String.valueOf(this.members));
        }
    }

    public static SoyType of(SoyType ... members) {
        return UnionType.of(Arrays.asList(members));
    }

    public static SoyType of(Collection<SoyType> members) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(MEMBER_ORDER);
        for (SoyType type : members) {
            if (type.getKind() == SoyType.Kind.UNKNOWN || type.getKind() == SoyType.Kind.ANY) {
                return type;
            }
            if (type.getKind() == SoyType.Kind.UNION) {
                builder.addAll(((UnionType)type).members);
                continue;
            }
            builder.add((Object)type);
        }
        ImmutableSortedSet flattenedMembers = builder.build();
        if (flattenedMembers.size() == 1) {
            return (SoyType)Iterables.getOnlyElement((Iterable)flattenedMembers);
        }
        return new UnionType((Iterable<? extends SoyType>)flattenedMembers);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.UNION;
    }

    public ImmutableSet<SoyType> getMembers() {
        return this.members;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType srcType, SoyType.UnknownAssignmentPolicy unknownPolicy) {
        for (SoyType memberType : this.members) {
            if (!memberType.isAssignableFromInternal(srcType, unknownPolicy)) continue;
            return true;
        }
        return false;
    }

    public SoyType filter(Predicate<SoyType> filter) {
        ImmutableSortedSet filtered = (ImmutableSortedSet)this.members.stream().filter(filter).collect(ImmutableSortedSet.toImmutableSortedSet(MEMBER_ORDER));
        if (filtered.size() != this.members.size()) {
            return UnionType.of((Collection<SoyType>)filtered);
        }
        return this;
    }

    @Override
    public boolean isNullOrUndefined() {
        return this.members.stream().allMatch(SoyType::isNullOrUndefined);
    }

    @Override
    public String toString() {
        return Joiner.on((char)'|').join(this.members);
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        SoyTypeP.UnionTypeP.Builder unionBuilder = builder.getUnionBuilder();
        for (SoyType member : this.members) {
            unionBuilder.addMember(member.toProto());
        }
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((UnionType)other).members.equals(this.members);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.members);
    }

    @Override
    public <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

