/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.testing.compile.Diagnostics;
import com.google.testing.compile.InMemoryJavaFileManager;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTool;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

final class Compilation {
    private Compilation() {
    }

    static Result compile(Iterable<? extends Processor> processors, Iterable<? extends JavaFileObject> sources) {
        JavacTool compiler = (JavacTool)ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(compiler.getStandardFileManager((DiagnosticListener)diagnosticCollector, Locale.getDefault(), Charsets.UTF_8));
        JavaCompiler.CompilationTask task = compiler.getTask((Writer)null, (JavaFileManager)fileManager, (DiagnosticListener)diagnosticCollector, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (Iterable)sources);
        task.setProcessors(processors);
        task.call();
        return new Result((Iterable<Diagnostic<? extends JavaFileObject>>)diagnosticCollector.getDiagnostics(), (Iterable<JavaFileObject>)fileManager.getOutputFiles());
    }

    static Iterable<? extends CompilationUnitTree> parse(Iterable<? extends JavaFileObject> sources) {
        JavacTool compiler = (JavacTool)ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(compiler.getStandardFileManager((DiagnosticListener)diagnosticCollector, Locale.getDefault(), Charsets.UTF_8));
        JavaCompiler.CompilationTask task = compiler.getTask((Writer)null, (JavaFileManager)fileManager, (DiagnosticListener)diagnosticCollector, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (Iterable)sources);
        try {
            Iterable<? extends CompilationUnitTree> parsedCompilationUnits = ((JavacTask)task).parse();
            List diagnostics = diagnosticCollector.getDiagnostics();
            for (Diagnostic diagnostic : diagnostics) {
                if (Diagnostic.Kind.ERROR != diagnostic.getKind()) continue;
                throw new IllegalStateException("error while parsing:\n" + Diagnostics.toString(diagnostics));
            }
            return parsedCompilationUnits;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static final class Result {
        final ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnosticsByKind;
        final ImmutableListMultimap<JavaFileObject.Kind, JavaFileObject> generatedFilesByKind;

        Result(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics, Iterable<JavaFileObject> generatedFiles) {
            this.diagnosticsByKind = Multimaps.index(diagnostics, (Function)new Function<Diagnostic<?>, Diagnostic.Kind>(){

                public Diagnostic.Kind apply(Diagnostic<?> input) {
                    return input.getKind();
                }
            });
            this.generatedFilesByKind = Multimaps.index(generatedFiles, (Function)new Function<JavaFileObject, JavaFileObject.Kind>(){

                public JavaFileObject.Kind apply(JavaFileObject input) {
                    return input.getKind();
                }
            });
        }

        boolean successful() {
            return this.diagnosticsByKind.get((Object)Diagnostic.Kind.ERROR).isEmpty();
        }

        ImmutableList<JavaFileObject> generatedSources() {
            return this.generatedFilesByKind.get((Object)JavaFileObject.Kind.SOURCE);
        }
    }
}

