/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjects;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public final class Compilation {
    private final Compiler compiler;
    private final ImmutableList<JavaFileObject> sourceFiles;
    private final Status status;
    private final ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics;
    private final ImmutableList<JavaFileObject> generatedFiles;

    Compilation(Compiler compiler, Iterable<? extends JavaFileObject> sourceFiles, boolean successful, Iterable<Diagnostic<? extends JavaFileObject>> diagnostics, Iterable<JavaFileObject> generatedFiles) {
        this.compiler = compiler;
        this.sourceFiles = ImmutableList.copyOf(sourceFiles);
        this.status = successful ? Status.SUCCESS : Status.FAILURE;
        this.diagnostics = ImmutableList.copyOf(diagnostics);
        this.generatedFiles = ImmutableList.copyOf(generatedFiles);
    }

    Compiler compiler() {
        return this.compiler;
    }

    ImmutableList<JavaFileObject> sourceFiles() {
        return this.sourceFiles;
    }

    Status status() {
        return this.status;
    }

    public ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics() {
        return this.diagnostics;
    }

    public ImmutableList<Diagnostic<? extends JavaFileObject>> errors() {
        return this.diagnosticsOfKind(Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    public ImmutableList<Diagnostic<? extends JavaFileObject>> warnings() {
        return this.diagnosticsOfKind(Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    public ImmutableList<Diagnostic<? extends JavaFileObject>> notes() {
        return this.diagnosticsOfKind(Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsOfKind(Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        ImmutableSet kinds = Sets.immutableEnumSet((Enum)kind, (Enum[])more);
        return this.diagnostics().stream().filter(diagnostic -> kinds.contains((Object)diagnostic.getKind())).collect(Compilation.toImmutableList());
    }

    public ImmutableList<JavaFileObject> generatedFiles() {
        Preconditions.checkState((boolean)this.status.equals((Object)Status.SUCCESS), (String)"compilation failed, so generated files are unavailable. %s", (Object[])new Object[]{this.describeErrors()});
        return this.generatedFiles;
    }

    public ImmutableList<JavaFileObject> generatedSourceFiles() {
        return this.generatedFiles().stream().filter(generatedFile -> generatedFile.getKind().equals((Object)JavaFileObject.Kind.SOURCE)).collect(Compilation.toImmutableList());
    }

    public Optional<JavaFileObject> generatedFile(JavaFileManager.Location location, String path) {
        String expectedFilename = String.format("%s/%s", location.getName(), path);
        return this.generatedFiles().stream().filter(generated -> generated.toUri().getPath().endsWith(expectedFilename)).findFirst();
    }

    public Optional<JavaFileObject> generatedFile(JavaFileManager.Location location, String packageName, String fileName) {
        return this.generatedFile(location, packageName.isEmpty() ? fileName : packageName.replace('.', '/') + '/' + fileName);
    }

    public Optional<JavaFileObject> generatedSourceFile(String qualifiedName) {
        return this.generatedFile(StandardLocation.SOURCE_OUTPUT, qualifiedName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("compilation of ").append(this.sourceFiles.stream().map(FileObject::getName).collect(Collectors.toList()));
        if (!this.compiler.processors().isEmpty()) {
            builder.append(" using annotation processors ").append(this.compiler.processors());
        }
        if (!this.compiler.options().isEmpty()) {
            builder.append(" passing options ").append(this.compiler.options());
        }
        return builder.toString();
    }

    String describeErrors() {
        ImmutableList<Diagnostic<? extends JavaFileObject>> errors = this.errors();
        if (errors.isEmpty()) {
            return "Compilation produced no errors.\n";
        }
        StringBuilder message = new StringBuilder("Compilation produced the following errors:\n");
        errors.stream().forEach(error -> message.append(error).append('\n'));
        return message.toString();
    }

    String describeGeneratedSourceFiles() {
        ImmutableList generatedSourceFiles = this.generatedFiles.stream().filter(generatedFile -> generatedFile.getKind().equals((Object)JavaFileObject.Kind.SOURCE)).collect(Compilation.toImmutableList());
        if (generatedSourceFiles.isEmpty()) {
            return "No files were generated.\n";
        }
        StringBuilder message = new StringBuilder("Generated Source Files\n======================\n");
        for (JavaFileObject generatedFile2 : generatedSourceFiles) {
            message.append(this.describeGeneratedFile(generatedFile2));
        }
        return message.toString();
    }

    private String describeGeneratedFile(JavaFileObject generatedFile) {
        try {
            StringBuilder entry = new StringBuilder("\n").append(generatedFile.getName()).append(":\n");
            if (generatedFile.getKind().equals((Object)JavaFileObject.Kind.CLASS)) {
                entry.append(String.format("  [generated class file (%d bytes)]", JavaFileObjects.asByteSource(generatedFile).size()));
            } else {
                entry.append(generatedFile.getCharContent(true));
            }
            return entry.append('\n').toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
        }
    }

    private static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

