/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubjectFactory;
import com.google.testing.compile.JavaFileObjectSubject;
import com.google.testing.compile.JavaFileObjects;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public final class CompilationSubject
extends Subject<CompilationSubject, Compilation> {
    private static final Subject.Factory<CompilationSubject, Compilation> FACTORY = new CompilationSubjectFactory();
    private static final JavaFileObject ALREADY_FAILED = JavaFileObjects.forSourceLines("compile.Failure", "package compile;", "", "final class Failure {}");

    public static Subject.Factory<CompilationSubject, Compilation> compilations() {
        return FACTORY;
    }

    public static CompilationSubject assertThat(Compilation actual) {
        return (CompilationSubject)Truth.assertAbout(CompilationSubject.compilations()).that((Object)actual);
    }

    CompilationSubject(FailureMetadata failureMetadata, Compilation actual) {
        super(failureMetadata, (Object)actual);
    }

    public void succeeded() {
        if (((Compilation)this.actual()).status().equals((Object)Compilation.Status.FAILURE)) {
            this.failWithoutActual(Fact.simpleFact((String)(((Compilation)this.actual()).describeFailureDiagnostics() + ((Compilation)this.actual()).describeGeneratedSourceFiles())), new Fact[0]);
        }
    }

    public void succeededWithoutWarnings() {
        this.succeeded();
        this.hadWarningCount(0);
    }

    public void failed() {
        if (((Compilation)this.actual()).status().equals((Object)Compilation.Status.SUCCESS)) {
            this.failWithoutActual(Fact.simpleFact((String)("Compilation was expected to fail, but contained no errors.\n\n" + ((Compilation)this.actual()).describeGeneratedSourceFiles())), new Fact[0]);
        }
    }

    public void hadErrorCount(int expectedCount) {
        this.checkDiagnosticCount(expectedCount, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadErrorContaining(String expectedSubstring) {
        return this.hadDiagnosticContaining(expectedSubstring, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadErrorContainingMatch(String expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadErrorContainingMatch(Pattern expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    public void hadWarningCount(int expectedCount) {
        this.checkDiagnosticCount(expectedCount, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadWarningContaining(String expectedSubstring) {
        return this.hadDiagnosticContaining(expectedSubstring, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadWarningContainingMatch(String expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadWarningContainingMatch(Pattern expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    public void hadNoteCount(int expectedCount) {
        this.checkDiagnosticCount(expectedCount, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadNoteContaining(String expectedSubstring) {
        return this.hadDiagnosticContaining(expectedSubstring, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadNoteContainingMatch(String expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadNoteContainingMatch(Pattern expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    private void checkDiagnosticCount(int expectedCount, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics = ((Compilation)this.actual()).diagnosticsOfKind(kind, more);
        int actualCount = Iterables.size(diagnostics);
        if (actualCount != expectedCount) {
            this.failWithoutActual(Fact.simpleFact((String)CompilationSubject.messageListing(diagnostics, "Expected %d %s, but found the following %d %s:", new Object[]{expectedCount, CompilationSubject.kindPlural(kind), actualCount, CompilationSubject.kindPlural(kind)})), new Fact[0]);
        }
    }

    private static String messageListing(Iterable<? extends Diagnostic<?>> diagnostics, String headingFormat, Object ... formatArgs) {
        StringBuilder listing = new StringBuilder(String.format(headingFormat, formatArgs)).append('\n');
        for (Diagnostic<?> diagnostic : diagnostics) {
            listing.append(diagnostic.getMessage(null)).append('\n');
        }
        return listing.toString();
    }

    private static String kindSingular(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "an error";
            }
            case MANDATORY_WARNING: 
            case WARNING: {
                return "a warning";
            }
            case NOTE: {
                return "a note";
            }
            case OTHER: {
                return "a diagnostic message";
            }
        }
        throw new AssertionError((Object)kind);
    }

    private static String kindPlural(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "errors";
            }
            case MANDATORY_WARNING: 
            case WARNING: {
                return "warnings";
            }
            case NOTE: {
                return "notes";
            }
            case OTHER: {
                return "diagnostic messages";
            }
        }
        throw new AssertionError((Object)kind);
    }

    private DiagnosticInFile hadDiagnosticContaining(String expectedSubstring, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        return this.hadDiagnosticContainingMatch(String.format("containing \"%s\"", expectedSubstring), Pattern.compile(Pattern.quote(expectedSubstring)), kind, more);
    }

    private DiagnosticInFile hadDiagnosticContainingMatch(String expectedPattern, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        return this.hadDiagnosticContainingMatch(Pattern.compile(expectedPattern), kind, more);
    }

    private DiagnosticInFile hadDiagnosticContainingMatch(Pattern expectedPattern, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        return this.hadDiagnosticContainingMatch(String.format("containing match for /%s/", expectedPattern), expectedPattern, kind, more);
    }

    private DiagnosticInFile hadDiagnosticContainingMatch(String diagnosticMatchDescription, Pattern expectedPattern, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        String expectedDiagnostic = String.format("%s %s", CompilationSubject.kindSingular(kind), diagnosticMatchDescription);
        return new DiagnosticInFile(expectedDiagnostic, (Iterable)this.findMatchingDiagnostics(expectedDiagnostic, expectedPattern, kind, more));
    }

    private ImmutableList<Diagnostic<? extends JavaFileObject>> findMatchingDiagnostics(String expectedDiagnostic, Pattern expectedPattern, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsOfKind = ((Compilation)this.actual()).diagnosticsOfKind(kind, more);
        ImmutableList diagnosticsWithMessage = diagnosticsOfKind.stream().filter(diagnostic -> expectedPattern.matcher(diagnostic.getMessage(null)).find()).collect(CompilationSubject.toImmutableList());
        if (diagnosticsWithMessage.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact((String)CompilationSubject.messageListing(diagnosticsOfKind, "Expected %s, but only found:", new Object[]{expectedDiagnostic})), new Fact[0]);
        }
        return diagnosticsWithMessage;
    }

    @CanIgnoreReturnValue
    public JavaFileObjectSubject generatedFile(JavaFileManager.Location location, String packageName, String fileName) {
        return this.checkGeneratedFile(((Compilation)this.actual()).generatedFile(location, packageName, fileName), location, "named \"%s\" in %s", fileName, packageName.isEmpty() ? "the default package" : String.format("package \"%s\"", packageName));
    }

    @CanIgnoreReturnValue
    public JavaFileObjectSubject generatedFile(JavaFileManager.Location location, String path) {
        return this.checkGeneratedFile(((Compilation)this.actual()).generatedFile(location, path), location, path, new Object[0]);
    }

    @CanIgnoreReturnValue
    public JavaFileObjectSubject generatedSourceFile(String qualifiedName) {
        return this.generatedFile(StandardLocation.SOURCE_OUTPUT, qualifiedName.replaceAll("\\.", "/") + ".java");
    }

    private JavaFileObjectSubject checkGeneratedFile(Optional<JavaFileObject> generatedFile, JavaFileManager.Location location, String format, Object ... args) {
        if (!generatedFile.isPresent()) {
            StringBuilder builder = new StringBuilder("generated the file ");
            builder.append(args.length == 0 ? format : String.format(format, args));
            builder.append("; it generated:\n");
            for (JavaFileObject generated : ((Compilation)this.actual()).generatedFiles()) {
                if (!generated.toUri().getPath().contains(location.getName())) continue;
                builder.append("  ").append(generated.toUri().getPath()).append('\n');
            }
            this.fail(builder.toString());
            return (JavaFileObjectSubject)this.ignoreCheck().about(JavaFileObjectSubject.javaFileObjects()).that((Object)ALREADY_FAILED);
        }
        return (JavaFileObjectSubject)this.check().about(JavaFileObjectSubject.javaFileObjects()).that((Object)generatedFile.get());
    }

    private static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    private static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf);
    }

    public final class DiagnosticAtColumn
    extends DiagnosticAssertions {
        private final LinesInFile linesInFile;
        private final long line;

        private DiagnosticAtColumn(DiagnosticAssertions previous, LinesInFile linesInFile, long line, ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsOnLine) {
            super(previous, (Iterable<Diagnostic<? extends JavaFileObject>>)diagnosticsOnLine);
            this.linesInFile = linesInFile;
            this.line = line;
        }

        public void atColumn(long expectedColumn) {
            if (this.filterDiagnostics(diagnostic -> diagnostic.getColumnNumber() == expectedColumn).isEmpty()) {
                this.failExpectingMatchingDiagnostic(" in %s at column %d of line %d, but found it at column(s) %s:\n%s", this.linesInFile.fileName(), expectedColumn, this.line, this.columnsWithDiagnostics(), this.linesInFile.listLine(this.line));
            }
        }

        private ImmutableSet<String> columnsWithDiagnostics() {
            return (ImmutableSet)this.mapDiagnostics(diagnostic -> diagnostic.getColumnNumber() == -1L ? "(no associated position)" : Long.toString(diagnostic.getColumnNumber())).collect(CompilationSubject.toImmutableSet());
        }
    }

    public final class DiagnosticOnLine
    extends DiagnosticAssertions {
        private final LinesInFile linesInFile;

        private DiagnosticOnLine(DiagnosticAssertions previous, JavaFileObject file, ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsInFile) {
            super(previous, (Iterable<Diagnostic<? extends JavaFileObject>>)diagnosticsInFile);
            this.linesInFile = new LinesInFile(file);
        }

        @CanIgnoreReturnValue
        public DiagnosticAtColumn onLine(long expectedLine) {
            return new DiagnosticAtColumn(this, this.linesInFile, expectedLine, this.findMatchingDiagnosticsOnLine(expectedLine));
        }

        public void onLineContaining(String expectedLineSubstring) {
            this.findMatchingDiagnosticsOnLine(this.findLineContainingSubstring(expectedLineSubstring));
        }

        private long findLineContainingSubstring(String expectedLineSubstring) {
            ImmutableSet matchingLines = (ImmutableSet)Streams.mapWithIndex((Stream)this.linesInFile.linesInFile().stream(), (line, index) -> line.contains(expectedLineSubstring) ? Long.valueOf(index) : null).filter(Predicates.notNull()).map(index -> index + 1L).collect(CompilationSubject.toImmutableSet());
            Preconditions.checkArgument((!matchingLines.isEmpty() ? 1 : 0) != 0, (String)"No line in %s contained \"%s\"", (Object)this.linesInFile.fileName(), (Object)expectedLineSubstring);
            Preconditions.checkArgument((matchingLines.size() == 1 ? 1 : 0) != 0, (String)"More than one line in %s contained \"%s\":\n%s", (Object)this.linesInFile.fileName(), (Object)expectedLineSubstring, (Object)matchingLines.stream().collect(this.linesInFile.toLineList()));
            return (Long)Iterables.getOnlyElement((Iterable)matchingLines);
        }

        @CanIgnoreReturnValue
        private ImmutableList<Diagnostic<? extends JavaFileObject>> findMatchingDiagnosticsOnLine(long expectedLine) {
            ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsOnLine = this.filterDiagnostics(diagnostic -> diagnostic.getLineNumber() == expectedLine);
            if (diagnosticsOnLine.isEmpty()) {
                this.failExpectingMatchingDiagnostic(" in %s on line:\n%s\nbut found it on line(s):\n%s", this.linesInFile.fileName(), this.linesInFile.listLine(expectedLine), this.mapDiagnostics(Diagnostic::getLineNumber).collect(this.linesInFile.toLineList()));
            }
            return diagnosticsOnLine;
        }
    }

    static final class LinesInFile {
        private final JavaFileObject file;
        private ImmutableList<String> lines;

        LinesInFile(JavaFileObject file) {
            this.file = file;
        }

        String fileName() {
            return this.file.getName();
        }

        ImmutableList<String> linesInFile() {
            if (this.lines == null) {
                try {
                    this.lines = JavaFileObjects.asByteSource(this.file).asCharSource(StandardCharsets.UTF_8).readLines();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this.lines;
        }

        Collector<Long, ?, String> toLineList() {
            return Collectors.mapping(this::listLine, Collectors.joining("\n"));
        }

        String listLine(long lineNumber) {
            return lineNumber == -1L ? "(no associated line)" : String.format("%4d: %s", lineNumber, this.linesInFile().get((int)(lineNumber - 1L)));
        }
    }

    public final class DiagnosticInFile
    extends DiagnosticAssertions {
        private DiagnosticInFile(String expectedDiagnostic, Iterable<Diagnostic<? extends JavaFileObject>> diagnosticsWithMessage) {
            super(expectedDiagnostic, diagnosticsWithMessage);
        }

        @CanIgnoreReturnValue
        public DiagnosticOnLine inFile(JavaFileObject expectedFile) {
            return new DiagnosticOnLine(this, expectedFile, this.findDiagnosticsInFile(expectedFile));
        }

        private ImmutableList<Diagnostic<? extends JavaFileObject>> findDiagnosticsInFile(JavaFileObject expectedFile) {
            String expectedFilePath = expectedFile.toUri().getPath();
            ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsInFile = this.filterDiagnostics(diagnostic -> {
                JavaFileObject source = (JavaFileObject)diagnostic.getSource();
                return source != null && source.toUri().getPath().equals(expectedFilePath);
            });
            if (diagnosticsInFile.isEmpty()) {
                this.failExpectingMatchingDiagnostic(" in %s, but found it in %s", expectedFile.getName(), this.sourceFilesWithDiagnostics());
            }
            return diagnosticsInFile;
        }

        private ImmutableSet<String> sourceFilesWithDiagnostics() {
            return (ImmutableSet)this.mapDiagnostics(diagnostic -> diagnostic.getSource() == null ? "(no associated file)" : ((JavaFileObject)diagnostic.getSource()).getName()).collect(CompilationSubject.toImmutableSet());
        }
    }

    private class DiagnosticAssertions {
        private final String expectedDiagnostic;
        private final ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics;

        DiagnosticAssertions(String expectedDiagnostic, Iterable<Diagnostic<? extends JavaFileObject>> matchingDiagnostics) {
            this.expectedDiagnostic = expectedDiagnostic;
            this.diagnostics = ImmutableList.copyOf(matchingDiagnostics);
        }

        DiagnosticAssertions(DiagnosticAssertions previous, Iterable<Diagnostic<? extends JavaFileObject>> matchingDiagnostics) {
            this(previous.expectedDiagnostic, matchingDiagnostics);
        }

        ImmutableList<Diagnostic<? extends JavaFileObject>> filterDiagnostics(Predicate<? super Diagnostic<? extends JavaFileObject>> predicate) {
            return (ImmutableList)this.diagnostics.stream().filter(predicate).collect(CompilationSubject.toImmutableList());
        }

        <T> Stream<T> mapDiagnostics(Function<? super Diagnostic<? extends JavaFileObject>, T> mapper) {
            return this.diagnostics.stream().map(mapper);
        }

        protected void failExpectingMatchingDiagnostic(String format, Object ... args) {
            CompilationSubject.this.failWithoutActual(Fact.simpleFact((String)("Expected " + this.expectedDiagnostic + String.format(format, args))), new Fact[0]);
        }
    }
}

