/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.auto.common.MoreTypes;
import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.FormatMethod;
import com.google.testing.compile.AutoValue_TreeDiffer_MethodSignature;
import com.google.testing.compile.TreeDifference;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TreeDiffer {
    private static final TreeVisitor<@Nullable Void, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<Name>> IMPORT_NAMES_ACCUMULATOR = new SimpleTreeVisitor<Void, ImmutableList.Builder<Name>>(){

        @Override
        public @Nullable Void visitMemberSelect(MemberSelectTree memberSelectTree, ImmutableList.Builder<Name> names) {
            names.add((Object)memberSelectTree.getIdentifier());
            return memberSelectTree.getExpression().accept(this, names);
        }

        @Override
        public @Nullable Void visitIdentifier(IdentifierTree identifierTree, ImmutableList.Builder<Name> names) {
            names.add((Object)identifierTree.getName());
            return null;
        }
    };

    private TreeDiffer() {
    }

    static TreeDifference diffCompilationUnits(CompilationUnitTree expected, CompilationUnitTree actual) {
        return TreeDiffer.createDiff((CompilationUnitTree)Preconditions.checkNotNull((Object)expected), (CompilationUnitTree)Preconditions.checkNotNull((Object)actual), TreeFilter.KEEP_ALL);
    }

    static TreeDifference matchCompilationUnits(CompilationUnitTree pattern, Trees patternTrees, CompilationUnitTree actual, Trees actualTrees) {
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkNotNull((Object)actual);
        return TreeDiffer.createDiff(pattern, actual, new MatchExpectedTreesFilter(pattern, patternTrees, actual, actualTrees));
    }

    private static TreeDifference createDiff(@Nullable CompilationUnitTree expected, @Nullable CompilationUnitTree actual, TreeFilter treeFilter) {
        TreeDifference.Builder diffBuilder = new TreeDifference.Builder();
        DiffVisitor diffVisitor = new DiffVisitor(diffBuilder, treeFilter);
        diffVisitor.scan(expected, actual);
        return diffBuilder.build();
    }

    static TreeDifference diffSubtrees(TreePath pathToExpected, TreePath pathToActual) {
        TreeDifference.Builder diffBuilder = new TreeDifference.Builder();
        DiffVisitor diffVisitor = new DiffVisitor(diffBuilder, TreeFilter.KEEP_ALL, pathToExpected, pathToActual);
        diffVisitor.scan(pathToExpected.getLeaf(), pathToActual.getLeaf());
        return diffBuilder.build();
    }

    @AutoValue
    static abstract class MethodSignature {
        MethodSignature() {
        }

        abstract String name();

        abstract ImmutableList<Equivalence.Wrapper<TypeMirror>> parameterTypes();

        static MethodSignature create(CompilationUnitTree compilationUnitTree, MethodTree tree, Trees trees) {
            ImmutableList.Builder parameterTypes = ImmutableList.builder();
            for (VariableTree variableTree : tree.getParameters()) {
                parameterTypes.add((Object)MoreTypes.equivalence().wrap((Object)trees.getTypeMirror(trees.getPath(compilationUnitTree, variableTree))));
            }
            return new AutoValue_TreeDiffer_MethodSignature(tree.getName().toString(), (ImmutableList<Equivalence.Wrapper<TypeMirror>>)parameterTypes.build());
        }
    }

    private static class MatchExpectedTreesFilter
    implements TreeFilter {
        private final CompilationUnitTree pattern;
        private final Trees patternTrees;
        private final CompilationUnitTree actual;
        private final Trees actualTrees;

        MatchExpectedTreesFilter(CompilationUnitTree pattern, Trees patternTrees, CompilationUnitTree actual, Trees actualTrees) {
            this.pattern = pattern;
            this.patternTrees = patternTrees;
            this.actual = actual;
            this.actualTrees = actualTrees;
        }

        @Override
        public ImmutableList<Tree> filterActualMembers(ImmutableList<Tree> patternMembers, ImmutableList<Tree> actualMembers) {
            final HashSet patternVariableNames = new HashSet();
            final HashSet patternNestedTypeNames = new HashSet();
            final HashSet patternMethods = new HashSet();
            for (Tree patternTree : patternMembers) {
                patternTree.accept(new SimpleTreeVisitor<Void, Void>(){

                    @Override
                    public @Nullable Void visitVariable(VariableTree variable, @Nullable Void p) {
                        patternVariableNames.add(variable.getName().toString());
                        return null;
                    }

                    @Override
                    public @Nullable Void visitMethod(MethodTree method, @Nullable Void p) {
                        patternMethods.add(MethodSignature.create(pattern, method, patternTrees));
                        return null;
                    }

                    @Override
                    public @Nullable Void visitClass(ClassTree clazz, @Nullable Void p) {
                        patternNestedTypeNames.add(clazz.getSimpleName().toString());
                        return null;
                    }
                }, null);
            }
            final ImmutableList.Builder filteredActualTrees = ImmutableList.builder();
            for (final Tree actualTree : actualMembers) {
                actualTree.accept(new SimpleTreeVisitor<Void, Void>(){

                    @Override
                    public @Nullable Void visitVariable(VariableTree variable, @Nullable Void p) {
                        if (patternVariableNames.contains(variable.getName().toString())) {
                            filteredActualTrees.add((Object)actualTree);
                        }
                        return null;
                    }

                    @Override
                    public @Nullable Void visitMethod(MethodTree method, @Nullable Void p) {
                        if (patternMethods.contains(MethodSignature.create(actual, method, actualTrees))) {
                            filteredActualTrees.add((Object)method);
                        }
                        return null;
                    }

                    @Override
                    public @Nullable Void visitClass(ClassTree clazz, @Nullable Void p) {
                        if (patternNestedTypeNames.contains(clazz.getSimpleName().toString())) {
                            filteredActualTrees.add((Object)clazz);
                        }
                        return null;
                    }

                    @Override
                    protected @Nullable Void defaultAction(Tree tree, @Nullable Void p) {
                        filteredActualTrees.add((Object)tree);
                        return null;
                    }
                }, null);
            }
            return filteredActualTrees.build();
        }

        @Override
        public ImmutableList<ImportTree> filterImports(ImmutableList<ImportTree> patternImports, ImmutableList<ImportTree> actualImports) {
            ImmutableSet patternImportsAsStrings = (ImmutableSet)patternImports.stream().map(this::fullyQualifiedImport).collect(ImmutableSet.toImmutableSet());
            return (ImmutableList)actualImports.stream().filter(importTree -> patternImportsAsStrings.contains((Object)this.fullyQualifiedImport((ImportTree)importTree))).collect(ImmutableList.toImmutableList());
        }

        private String fullyQualifiedImport(ImportTree importTree) {
            ImmutableList.Builder names = ImmutableList.builder();
            importTree.getQualifiedIdentifier().accept(IMPORT_NAMES_ACCUMULATOR, names);
            return Joiner.on((char)'.').join((Iterable)names.build().reverse());
        }
    }

    private static interface TreeFilter {
        public static final TreeFilter KEEP_ALL = new TreeFilter(){

            @Override
            public ImmutableList<Tree> filterActualMembers(ImmutableList<Tree> expectedMembers, ImmutableList<Tree> actualMembers) {
                return actualMembers;
            }

            @Override
            public ImmutableList<ImportTree> filterImports(ImmutableList<ImportTree> expectedImports, ImmutableList<ImportTree> actualImports) {
                return actualImports;
            }
        };

        public ImmutableList<Tree> filterActualMembers(ImmutableList<Tree> var1, ImmutableList<Tree> var2);

        public ImmutableList<ImportTree> filterImports(ImmutableList<ImportTree> var1, ImmutableList<ImportTree> var2);
    }

    static final class DiffVisitor
    extends SimpleTreeVisitor<Void, Tree> {
        private @Nullable TreePath expectedPath;
        private @Nullable TreePath actualPath;
        private final TreeDifference.Builder diffBuilder;
        private final TreeFilter filter;

        DiffVisitor(TreeDifference.Builder diffBuilder, TreeFilter filter) {
            this(diffBuilder, filter, null, null);
        }

        private DiffVisitor(TreeDifference.Builder diffBuilder, TreeFilter filter, @Nullable TreePath pathToExpected, @Nullable TreePath pathToActual) {
            this.diffBuilder = diffBuilder;
            this.filter = filter;
            this.expectedPath = pathToExpected;
            this.actualPath = pathToActual;
        }

        public void addTypeMismatch(Tree expected, Tree actual) {
            this.diffBuilder.addDifferingNodes(this.expectedPathPlus(expected), this.actualPathPlus(actual), String.format("Expected node kind to be <%s> but was <%s>.", new Object[]{expected.getKind(), actual.getKind()}));
        }

        @FormatMethod
        private void checkForDiff(boolean p, String message, Object ... formatArgs) {
            if (!p) {
                this.diffBuilder.addDifferingNodes(Objects.requireNonNull(this.expectedPath), Objects.requireNonNull(this.actualPath), String.format(message, formatArgs));
            }
        }

        private TreePath actualPathPlus(Tree actual) {
            Preconditions.checkNotNull((Object)actual, (Object)"Tried to push null actual tree onto path.");
            return new TreePath(this.actualPath, actual);
        }

        private TreePath expectedPathPlus(Tree expected) {
            Preconditions.checkNotNull((Object)expected, (Object)"Tried to push null expected tree onto path.");
            return new TreePath(this.expectedPath, expected);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private @Nullable Void pushPathAndAccept(Tree expected, Tree actual) {
            TreePath prevExpectedPath = this.expectedPath;
            TreePath prevActualPath = this.actualPath;
            this.expectedPath = this.expectedPathPlus(expected);
            this.actualPath = this.actualPathPlus(actual);
            try {
                Void void_ = expected.accept(this, actual);
                return void_;
            }
            finally {
                this.expectedPath = prevExpectedPath;
                this.actualPath = prevActualPath;
            }
        }

        private boolean namesEqual(@Nullable Name expected, @Nullable Name actual) {
            return expected == null ? actual == null : actual != null && expected.contentEquals(actual);
        }

        private void scan(@Nullable Tree expected, @Nullable Tree actual) {
            if (expected == null && actual != null) {
                this.diffBuilder.addExtraActualNode(this.actualPathPlus(actual));
            } else if (expected != null && actual == null) {
                this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expected));
            } else if (actual != null && expected != null) {
                this.pushPathAndAccept(expected, actual);
            }
        }

        private void parallelScan(Iterable<? extends Tree> expecteds, Iterable<? extends Tree> actuals) {
            if (expecteds != null && actuals != null) {
                Iterator<? extends Tree> expectedsIterator = expecteds.iterator();
                Iterator<? extends Tree> actualsIterator = actuals.iterator();
                while (expectedsIterator.hasNext() && actualsIterator.hasNext()) {
                    this.pushPathAndAccept(expectedsIterator.next(), actualsIterator.next());
                }
                if (!expectedsIterator.hasNext() && actualsIterator.hasNext()) {
                    this.diffBuilder.addExtraActualNode(this.actualPathPlus(actualsIterator.next()));
                } else if (expectedsIterator.hasNext() && !actualsIterator.hasNext()) {
                    this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expectedsIterator.next()));
                }
            } else if (expecteds == null && actuals != null && !Iterables.isEmpty(actuals)) {
                this.diffBuilder.addExtraActualNode(this.actualPathPlus(actuals.iterator().next()));
            } else if (actuals == null && expecteds != null && !Iterables.isEmpty(expecteds)) {
                this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expecteds.iterator().next()));
            }
        }

        @Override
        public @Nullable Void visitAnnotation(AnnotationTree expected, Tree actual) {
            Optional<AnnotationTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getAnnotationType(), other.get().getAnnotationType());
            this.parallelScan(expected.getArguments(), other.get().getArguments());
            return null;
        }

        @Override
        public @Nullable Void visitMethodInvocation(MethodInvocationTree expected, Tree actual) {
            Optional<MethodInvocationTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getTypeArguments(), other.get().getTypeArguments());
            this.scan(expected.getMethodSelect(), other.get().getMethodSelect());
            this.parallelScan(expected.getArguments(), other.get().getArguments());
            return null;
        }

        @Override
        public @Nullable Void visitLambdaExpression(LambdaExpressionTree expected, Tree actual) {
            Optional<LambdaExpressionTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getParameters(), other.get().getParameters());
            this.scan(expected.getBody(), other.get().getBody());
            return null;
        }

        @Override
        public @Nullable Void visitMemberReference(MemberReferenceTree expected, Tree actual) {
            Optional<MemberReferenceTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getQualifierExpression(), other.get().getQualifierExpression());
            this.parallelScan(expected.getTypeArguments(), other.get().getTypeArguments());
            this.checkForDiff(expected.getName().contentEquals(other.get().getName()), "Expected identifier to be <%s> but was <%s>.", expected.getName(), other.get().getName());
            return null;
        }

        @Override
        public @Nullable Void visitAssert(AssertTree expected, Tree actual) {
            Optional<AssertTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), other.get().getCondition());
            this.scan(expected.getDetail(), other.get().getDetail());
            return null;
        }

        @Override
        public @Nullable Void visitAssignment(AssignmentTree expected, Tree actual) {
            Optional<AssignmentTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getVariable(), other.get().getVariable());
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitCompoundAssignment(CompoundAssignmentTree expected, Tree actual) {
            Optional<CompoundAssignmentTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getVariable(), other.get().getVariable());
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitBinary(BinaryTree expected, Tree actual) {
            Optional<BinaryTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getLeftOperand(), other.get().getLeftOperand());
            this.scan(expected.getRightOperand(), other.get().getRightOperand());
            return null;
        }

        @Override
        public @Nullable Void visitBlock(BlockTree expected, Tree actual) {
            Optional<BlockTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.isStatic() == other.get().isStatic(), "Expected block to be <%s> but was <%s>.", expected.isStatic() ? "static" : "non-static", other.get().isStatic() ? "static" : "non-static");
            this.parallelScan(expected.getStatements(), other.get().getStatements());
            return null;
        }

        @Override
        public @Nullable Void visitBreak(BreakTree expected, Tree actual) {
            Optional<BreakTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(this.namesEqual(expected.getLabel(), other.get().getLabel()), "Expected label on break statement to be <%s> but was <%s>.", expected.getLabel(), other.get().getLabel());
            return null;
        }

        @Override
        public @Nullable Void visitCase(CaseTree expected, Tree actual) {
            Optional<CaseTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            this.parallelScan(expected.getStatements(), other.get().getStatements());
            return null;
        }

        @Override
        public @Nullable Void visitCatch(CatchTree expected, Tree actual) {
            Optional<CatchTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getParameter(), other.get().getParameter());
            this.scan(expected.getBlock(), other.get().getBlock());
            return null;
        }

        @Override
        public @Nullable Void visitClass(ClassTree expected, Tree actual) {
            Optional<ClassTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getSimpleName().contentEquals(other.get().getSimpleName()), "Expected name of type to be <%s> but was <%s>.", expected.getSimpleName(), other.get().getSimpleName());
            this.scan(expected.getModifiers(), other.get().getModifiers());
            this.parallelScan(expected.getTypeParameters(), other.get().getTypeParameters());
            this.scan(expected.getExtendsClause(), other.get().getExtendsClause());
            this.parallelScan(expected.getImplementsClause(), other.get().getImplementsClause());
            this.parallelScan((Iterable<? extends Tree>)expected.getMembers(), (Iterable<? extends Tree>)this.filter.filterActualMembers((ImmutableList<Tree>)ImmutableList.copyOf(expected.getMembers()), (ImmutableList<Tree>)ImmutableList.copyOf(other.get().getMembers())));
            return null;
        }

        @Override
        public @Nullable Void visitConditionalExpression(ConditionalExpressionTree expected, Tree actual) {
            Optional<ConditionalExpressionTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), other.get().getCondition());
            this.scan(expected.getTrueExpression(), other.get().getTrueExpression());
            this.scan(expected.getFalseExpression(), other.get().getFalseExpression());
            return null;
        }

        @Override
        public @Nullable Void visitContinue(ContinueTree expected, Tree actual) {
            Optional<ContinueTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(this.namesEqual(expected.getLabel(), other.get().getLabel()), "Expected label on continue statement to be <%s> but was <%s>.", expected.getLabel(), other.get().getLabel());
            return null;
        }

        @Override
        public @Nullable Void visitDoWhileLoop(DoWhileLoopTree expected, Tree actual) {
            Optional<DoWhileLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), other.get().getCondition());
            this.scan(expected.getStatement(), other.get().getStatement());
            return null;
        }

        @Override
        public @Nullable Void visitErroneous(ErroneousTree expected, Tree actual) {
            Optional<ErroneousTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getErrorTrees(), other.get().getErrorTrees());
            return null;
        }

        @Override
        public @Nullable Void visitExpressionStatement(ExpressionStatementTree expected, Tree actual) {
            Optional<ExpressionStatementTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitEnhancedForLoop(EnhancedForLoopTree expected, Tree actual) {
            Optional<EnhancedForLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getVariable(), other.get().getVariable());
            this.scan(expected.getExpression(), other.get().getExpression());
            this.scan(expected.getStatement(), other.get().getStatement());
            return null;
        }

        @Override
        public @Nullable Void visitForLoop(ForLoopTree expected, Tree actual) {
            Optional<ForLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getInitializer(), other.get().getInitializer());
            this.scan(expected.getCondition(), other.get().getCondition());
            this.parallelScan(expected.getUpdate(), other.get().getUpdate());
            this.scan(expected.getStatement(), other.get().getStatement());
            return null;
        }

        @Override
        public @Nullable Void visitIdentifier(IdentifierTree expected, Tree actual) {
            Optional<IdentifierTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(other.get().getName()), "Expected identifier to be <%s> but was <%s>.", expected.getName(), other.get().getName());
            return null;
        }

        @Override
        public @Nullable Void visitIf(IfTree expected, Tree actual) {
            Optional<IfTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), other.get().getCondition());
            this.scan(expected.getThenStatement(), other.get().getThenStatement());
            this.scan(expected.getElseStatement(), other.get().getElseStatement());
            return null;
        }

        @Override
        public @Nullable Void visitImport(ImportTree expected, Tree actual) {
            Optional<ImportTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.isStatic() == other.get().isStatic(), "Expected import to be <%s> but was <%s>.", expected.isStatic() ? "static" : "non-static", other.get().isStatic() ? "static" : "non-static");
            this.scan(expected.getQualifiedIdentifier(), other.get().getQualifiedIdentifier());
            return null;
        }

        @Override
        public @Nullable Void visitArrayAccess(ArrayAccessTree expected, Tree actual) {
            Optional<ArrayAccessTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            this.scan(expected.getIndex(), other.get().getIndex());
            return null;
        }

        @Override
        public @Nullable Void visitLabeledStatement(LabeledStatementTree expected, Tree actual) {
            Optional<LabeledStatementTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getLabel().contentEquals(other.get().getLabel()), "Expected statement label to be <%s> but was <%s>.", expected.getLabel(), other.get().getLabel());
            this.scan(expected.getStatement(), other.get().getStatement());
            return null;
        }

        @Override
        public @Nullable Void visitLiteral(LiteralTree expected, Tree actual) {
            Optional<LiteralTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(com.google.common.base.Objects.equal((Object)expected.getValue(), (Object)other.get().getValue()), "Expected literal value to be <%s> but was <%s>.", expected.getValue(), other.get().getValue());
            return null;
        }

        @Override
        public @Nullable Void visitMethod(MethodTree expected, Tree actual) {
            Optional<MethodTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(other.get().getName()), "Expected method name to be <%s> but was <%s>.", expected.getName(), other.get().getName());
            this.scan(expected.getModifiers(), other.get().getModifiers());
            this.scan(expected.getReturnType(), other.get().getReturnType());
            this.parallelScan(expected.getTypeParameters(), other.get().getTypeParameters());
            this.parallelScan(expected.getParameters(), other.get().getParameters());
            this.parallelScan(expected.getThrows(), other.get().getThrows());
            this.scan(expected.getBody(), other.get().getBody());
            this.scan(expected.getDefaultValue(), other.get().getDefaultValue());
            return null;
        }

        @Override
        public @Nullable Void visitModifiers(ModifiersTree expected, Tree actual) {
            Optional<ModifiersTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getFlags().equals(other.get().getFlags()), "Expected modifier set to be <%s> but was <%s>.", expected.getFlags(), other.get().getFlags());
            this.parallelScan(expected.getAnnotations(), other.get().getAnnotations());
            return null;
        }

        @Override
        public @Nullable Void visitNewArray(NewArrayTree expected, Tree actual) {
            Optional<NewArrayTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), other.get().getType());
            this.parallelScan(expected.getDimensions(), other.get().getDimensions());
            this.parallelScan(expected.getInitializers(), other.get().getInitializers());
            return null;
        }

        @Override
        public @Nullable Void visitNewClass(NewClassTree expected, Tree actual) {
            Optional<NewClassTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getEnclosingExpression(), other.get().getEnclosingExpression());
            this.parallelScan(expected.getTypeArguments(), other.get().getTypeArguments());
            this.scan(expected.getIdentifier(), other.get().getIdentifier());
            this.parallelScan(expected.getArguments(), other.get().getArguments());
            this.scan(expected.getClassBody(), other.get().getClassBody());
            return null;
        }

        @Override
        public @Nullable Void visitParenthesized(ParenthesizedTree expected, Tree actual) {
            Optional<ParenthesizedTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitReturn(ReturnTree expected, Tree actual) {
            Optional<ReturnTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitMemberSelect(MemberSelectTree expected, Tree actual) {
            Optional<MemberSelectTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getIdentifier().contentEquals(other.get().getIdentifier()), "Expected member identifier to be <%s> but was <%s>.", expected.getIdentifier(), other.get().getIdentifier());
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitEmptyStatement(EmptyStatementTree expected, Tree actual) {
            if (!this.checkTypeAndCast(expected, actual).isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            return null;
        }

        @Override
        public @Nullable Void visitSwitch(SwitchTree expected, Tree actual) {
            Optional<SwitchTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            this.parallelScan(expected.getCases(), other.get().getCases());
            return null;
        }

        @Override
        public @Nullable Void visitSynchronized(SynchronizedTree expected, Tree actual) {
            Optional<SynchronizedTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            this.scan(expected.getBlock(), other.get().getBlock());
            return null;
        }

        @Override
        public @Nullable Void visitThrow(ThrowTree expected, Tree actual) {
            Optional<ThrowTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitCompilationUnit(CompilationUnitTree expected, Tree actual) {
            Optional<CompilationUnitTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getPackageAnnotations(), other.get().getPackageAnnotations());
            this.scan(expected.getPackageName(), other.get().getPackageName());
            this.parallelScan((Iterable<? extends Tree>)expected.getImports(), (Iterable<? extends Tree>)this.filter.filterImports((ImmutableList<ImportTree>)ImmutableList.copyOf(expected.getImports()), (ImmutableList<ImportTree>)ImmutableList.copyOf(other.get().getImports())));
            this.parallelScan(expected.getTypeDecls(), other.get().getTypeDecls());
            return null;
        }

        @Override
        public @Nullable Void visitTry(TryTree expected, Tree actual) {
            Optional<TryTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.parallelScan(expected.getResources(), other.get().getResources());
            this.scan(expected.getBlock(), other.get().getBlock());
            this.parallelScan(expected.getCatches(), other.get().getCatches());
            this.scan(expected.getFinallyBlock(), other.get().getFinallyBlock());
            return null;
        }

        @Override
        public @Nullable Void visitParameterizedType(ParameterizedTypeTree expected, Tree actual) {
            Optional<ParameterizedTypeTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), other.get().getType());
            this.parallelScan(expected.getTypeArguments(), other.get().getTypeArguments());
            return null;
        }

        @Override
        public @Nullable Void visitArrayType(ArrayTypeTree expected, Tree actual) {
            Optional<ArrayTypeTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), other.get().getType());
            return null;
        }

        @Override
        public @Nullable Void visitTypeCast(TypeCastTree expected, Tree actual) {
            Optional<TypeCastTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getType(), other.get().getType());
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitPrimitiveType(PrimitiveTypeTree expected, Tree actual) {
            Optional<PrimitiveTypeTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getPrimitiveTypeKind() == other.get().getPrimitiveTypeKind(), "Expected primitive type kind to be <%s> but was <%s>.", new Object[]{expected.getPrimitiveTypeKind(), other.get().getPrimitiveTypeKind()});
            return null;
        }

        @Override
        public @Nullable Void visitTypeParameter(TypeParameterTree expected, Tree actual) {
            Optional<TypeParameterTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(other.get().getName()), "Expected type parameter name to be <%s> but was <%s>.", expected.getName(), other.get().getName());
            this.parallelScan(expected.getBounds(), other.get().getBounds());
            return null;
        }

        @Override
        public @Nullable Void visitInstanceOf(InstanceOfTree expected, Tree actual) {
            Optional<InstanceOfTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            this.scan(expected.getType(), other.get().getType());
            return null;
        }

        @Override
        public @Nullable Void visitUnary(UnaryTree expected, Tree actual) {
            Optional<UnaryTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getExpression(), other.get().getExpression());
            return null;
        }

        @Override
        public @Nullable Void visitVariable(VariableTree expected, Tree actual) {
            Optional<VariableTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.checkForDiff(expected.getName().contentEquals(other.get().getName()), "Expected variable name to be <%s> but was <%s>.", expected.getName(), other.get().getName());
            this.scan(expected.getModifiers(), other.get().getModifiers());
            this.scan(expected.getType(), other.get().getType());
            this.scan(expected.getInitializer(), other.get().getInitializer());
            return null;
        }

        @Override
        public @Nullable Void visitWhileLoop(WhileLoopTree expected, Tree actual) {
            Optional<WhileLoopTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getCondition(), other.get().getCondition());
            this.scan(expected.getStatement(), other.get().getStatement());
            return null;
        }

        @Override
        public @Nullable Void visitWildcard(WildcardTree expected, Tree actual) {
            Optional<WildcardTree> other = this.checkTypeAndCast(expected, actual);
            if (!other.isPresent()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            this.scan(expected.getBound(), other.get().getBound());
            return null;
        }

        @Override
        public @Nullable Void visitOther(Tree expected, Tree actual) {
            throw new UnsupportedOperationException("cannot compare unknown trees");
        }

        private <T extends Tree> Optional<T> checkTypeAndCast(T expected, Tree actual) {
            Tree.Kind treeKind;
            Tree.Kind expectedKind = ((Tree)Preconditions.checkNotNull(expected)).getKind();
            if (expectedKind == (treeKind = ((Tree)Preconditions.checkNotNull((Object)actual)).getKind())) {
                Tree treeAsExpectedType = actual;
                return Optional.of(treeAsExpectedType);
            }
            return Optional.empty();
        }
    }
}

