/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.common.io.ByteSource;
import com.google.testing.compile.ForwardingStandardJavaFileManager;
import com.google.testing.compile.JavaFileObjects;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.jspecify.annotations.Nullable;

final class InMemoryJavaFileManager
extends ForwardingStandardJavaFileManager {
    private final LoadingCache<URI, JavaFileObject> inMemoryOutputs = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<URI, JavaFileObject>(){

        public JavaFileObject load(URI key) {
            return new InMemoryJavaFileObject(key);
        }
    });
    private final Map<URI, JavaFileObject> inMemoryInputs = new HashMap<URI, JavaFileObject>();

    InMemoryJavaFileManager(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    private static URI uriForFileObject(JavaFileManager.Location location, String packageName, String relativeName) {
        StringBuilder uri = new StringBuilder("mem:///").append(location.getName()).append('/');
        if (!packageName.isEmpty()) {
            uri.append(packageName.replace('.', '/')).append('/');
        }
        uri.append(relativeName);
        return URI.create(uri.toString());
    }

    private static URI uriForJavaFileObject(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
        return URI.create("mem:///" + location.getName() + '/' + className.replace('.', '/') + kind.extension);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }

    @Override
    public @Nullable FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        if (location.isOutputLocation()) {
            return (FileObject)this.inMemoryOutputs.getIfPresent((Object)InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName));
        }
        Optional<JavaFileObject> inMemoryInput = this.findInMemoryInput(packageName, relativeName);
        if (inMemoryInput.isPresent()) {
            return inMemoryInput.get();
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public @Nullable JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location.isOutputLocation()) {
            return (JavaFileObject)this.inMemoryOutputs.getIfPresent((Object)InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind));
        }
        Optional<JavaFileObject> inMemoryInput = this.findInMemoryInput(className);
        if (inMemoryInput.isPresent()) {
            return inMemoryInput.get();
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    private Optional<JavaFileObject> findInMemoryInput(String className) {
        int lastDot = className.lastIndexOf(46);
        return this.findInMemoryInput(lastDot == -1 ? "" : className.substring(0, lastDot - 1), className.substring(lastDot + 1) + ".java");
    }

    private Optional<JavaFileObject> findInMemoryInput(String packageName, String relativeName) {
        String suffix = packageName.isEmpty() ? relativeName : packageName.replace('.', '/') + "/" + relativeName;
        return (Optional)this.inMemoryInputs.entrySet().stream().filter(entry -> Objects.requireNonNull(((URI)entry.getKey()).getPath()).endsWith(suffix)).map(Map.Entry::getValue).collect(MoreCollectors.toOptional());
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForFileObject(location, packageName, relativeName);
        return (FileObject)this.inMemoryOutputs.getUnchecked((Object)uri);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        URI uri = InMemoryJavaFileManager.uriForJavaFileObject(location, className, kind);
        return (JavaFileObject)this.inMemoryOutputs.getUnchecked((Object)uri);
    }

    ImmutableList<JavaFileObject> getGeneratedSources() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry entry : this.inMemoryOutputs.asMap().entrySet()) {
            if (!Objects.requireNonNull(((URI)entry.getKey()).getPath()).startsWith("/" + StandardLocation.SOURCE_OUTPUT.name()) || ((JavaFileObject)entry.getValue()).getKind() != JavaFileObject.Kind.SOURCE) continue;
            result.add((Object)((JavaFileObject)entry.getValue()));
        }
        return result.build();
    }

    ImmutableList<JavaFileObject> getOutputFiles() {
        return ImmutableList.copyOf(this.inMemoryOutputs.asMap().values());
    }

    void addSourceFiles(Iterable<? extends JavaFileObject> files) {
        for (JavaFileObject javaFileObject : files) {
            this.inMemoryInputs.put(javaFileObject.toUri(), javaFileObject);
        }
    }

    private static final class InMemoryJavaFileObject
    extends SimpleJavaFileObject
    implements JavaFileObject {
        private long lastModified = 0L;
        private Optional<ByteSource> data = Optional.empty();

        InMemoryJavaFileObject(URI uri) {
            super(uri, JavaFileObjects.deduceKind(uri));
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.data.isPresent()) {
                return this.data.get().openStream();
            }
            throw new FileNotFoundException();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    data = Optional.of(ByteSource.wrap((byte[])this.toByteArray()));
                    lastModified = System.currentTimeMillis();
                }
            };
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            if (this.data.isPresent()) {
                return this.data.get().asCharSource(Charset.defaultCharset()).openStream();
            }
            throw new FileNotFoundException();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            if (this.data.isPresent()) {
                return this.data.get().asCharSource(Charset.defaultCharset()).read();
            }
            throw new FileNotFoundException();
        }

        @Override
        public Writer openWriter() throws IOException {
            return new StringWriter(){

                @Override
                public void close() throws IOException {
                    super.close();
                    data = Optional.of(ByteSource.wrap((byte[])this.toString().getBytes(Charset.defaultCharset())));
                    lastModified = System.currentTimeMillis();
                }
            };
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public boolean delete() {
            this.data = Optional.empty();
            this.lastModified = 0L;
            return true;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.toUri()).add("kind", (Object)this.kind).toString();
        }
    }
}

