/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.testing.junit.testparameterinjector.AutoAnnotation_TestParameterAnnotationMethodProcessor_TestIndexHolderFactory_create;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_AnnotationTypeOrigin;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata;
import com.google.testing.junit.testparameterinjector.AutoValue_TestParameterAnnotationMethodProcessor_TestParameterValue;
import com.google.testing.junit.testparameterinjector.ByteStringReflection;
import com.google.testing.junit.testparameterinjector.ExecutableValidationResult;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessor;
import com.google.testing.junit.testparameterinjector.TestParameterAnnotation;
import com.google.testing.junit.testparameterinjector.TestParameterValidator;
import com.google.testing.junit.testparameterinjector.TestParameterValueProvider;
import com.google.testing.junit.testparameterinjector.TestParameterValues;
import com.google.testing.junit.testparameterinjector.TestParameters;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

final class TestParameterAnnotationMethodProcessor
implements TestMethodProcessor {
    private final boolean onlyForFieldsAndParameters;
    private final LoadingCache<Class<?>, ImmutableList<AnnotationTypeOrigin>> annotationTypeOriginsCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::calculateAnnotationTypeOrigins));
    private final Cache<Method, List<List<TestParameterValue>>> parameterValuesCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public static TestParameterValues getTestParameterValues(TestInfo testInfo) {
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        if (testIndexHolder == null) {
            return annotationType -> Optional.absent();
        }
        return annotationType -> FluentIterable.from(new TestParameterAnnotationMethodProcessor(false).getParameterValuesForTest(testIndexHolder, testInfo.getTestClass())).filter(testParameterValue -> testParameterValue.annotationTypeOrigin().annotationType().equals(annotationType)).transform(TestParameterValue::value).first();
    }

    public static Optional<Object> getTestParameterValue(TestInfo testInfo, Class<? extends Annotation> annotationType) {
        return TestParameterAnnotationMethodProcessor.getTestParameterValues(testInfo).getValue(annotationType);
    }

    private static List<Object> getParametersAnnotationValues(AnnotationWithMetadata annotationWithMetadata) {
        Annotation annotation = annotationWithMetadata.annotation();
        TestParameterAnnotation testParameter = annotation.annotationType().getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValueProvider> valueProvider = testParameter.valueProvider();
        try {
            return valueProvider.getConstructor(new Class[0]).newInstance(new Object[0]).provideValues(annotation, annotationWithMetadata.paramClass());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unexpected exception while invoking value provider " + valueProvider, e);
        }
    }

    private TestParameterAnnotationMethodProcessor(boolean onlyForFieldsAndParameters) {
        this.onlyForFieldsAndParameters = onlyForFieldsAndParameters;
    }

    static TestMethodProcessor forAllAnnotationPlacements() {
        return new TestParameterAnnotationMethodProcessor(false);
    }

    static TestMethodProcessor onlyForFieldsAndParameters() {
        return new TestParameterAnnotationMethodProcessor(true);
    }

    private ImmutableList<AnnotationTypeOrigin> calculateAnnotationTypeOrigins(Class<?> testClass) {
        List<AnnotationTypeOrigin> fieldAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testClass)).transformAndConcat(c -> Arrays.asList(c.getDeclaredFields())).transformAndConcat(field -> Arrays.asList(field.getAnnotations())).toList(), Origin.FIELD);
        List<AnnotationTypeOrigin> methodAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from((Object[])testClass.getMethods()).transformAndConcat(method -> Arrays.asList(method.getAnnotations())).toList(), Origin.METHOD);
        List<AnnotationTypeOrigin> parameterAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testClass)).transformAndConcat(c -> Arrays.asList(c.getDeclaredMethods())).transformAndConcat(method -> Arrays.asList(method.getParameterAnnotations())).transformAndConcat(Arrays::asList).toList(), Origin.METHOD_PARAMETER);
        List<AnnotationTypeOrigin> classAnnotations = this.extractTestParameterAnnotations(Arrays.asList(testClass.getAnnotations()), Origin.CLASS);
        List<AnnotationTypeOrigin> constructorAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from((Object[])testClass.getDeclaredConstructors()).transformAndConcat(constructor -> Arrays.asList(constructor.getAnnotations())).toList(), Origin.CONSTRUCTOR);
        List<AnnotationTypeOrigin> constructorParameterAnnotations = this.extractTestParameterAnnotations((List<Annotation>)FluentIterable.from((Object[])testClass.getDeclaredConstructors()).transformAndConcat(constructor -> FluentIterable.from(Arrays.asList(constructor.getParameterAnnotations())).transformAndConcat(Arrays::asList)).toList(), Origin.CONSTRUCTOR_PARAMETER);
        this.checkDuplicatedClassAndFieldAnnotations(constructorAnnotations, classAnnotations, fieldAnnotations);
        this.checkDuplicatedFieldsAnnotations(methodAnnotations, fieldAnnotations);
        Preconditions.checkState((FluentIterable.from(constructorAnnotations).toSet().size() == constructorAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on the constructor.");
        Preconditions.checkState((FluentIterable.from(classAnnotations).toSet().size() == classAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on the class.");
        if (this.onlyForFieldsAndParameters) {
            Preconditions.checkState((boolean)methodAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow method-level annotations that could be field/parameter annotations, but found %s", methodAnnotations);
            Preconditions.checkState((boolean)classAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow class-level annotations that could be field/parameter annotations, but found %s", classAnnotations);
            Preconditions.checkState((boolean)constructorAnnotations.isEmpty(), (String)"This test runner (constructed by the testparameterinjector package) was configured to disallow constructor-level annotations that could be field/parameter annotations, but found %s", constructorAnnotations);
        }
        return FluentIterable.from(classAnnotations).append(fieldAnnotations).append(constructorAnnotations).append(constructorParameterAnnotations).append(methodAnnotations).append(parameterAnnotations).toSet().asList();
    }

    private ImmutableList<AnnotationTypeOrigin> getAnnotationTypeOrigins(Class<?> testClass, Origin firstOrigin, Origin ... otherOrigins) {
        ImmutableSet originsToFilterBy = ImmutableSet.builder().add((Object)firstOrigin).add((Object[])otherOrigins).build();
        try {
            return FluentIterable.from((Iterable)((Iterable)this.annotationTypeOriginsCache.getUnchecked(testClass))).filter(arg_0 -> TestParameterAnnotationMethodProcessor.lambda$getAnnotationTypeOrigins$10((Set)originsToFilterBy, arg_0)).toList();
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IllegalStateException.class);
            throw e;
        }
    }

    private void checkDuplicatedFieldsAnnotations(List<AnnotationTypeOrigin> methodAnnotations, List<AnnotationTypeOrigin> fieldAnnotations) {
        if (FluentIterable.from(fieldAnnotations).toSet().size() != fieldAnnotations.size()) {
            ArrayList methodOrFieldAnnotations = new ArrayList(FluentIterable.from(methodAnnotations).append(new HashSet<AnnotationTypeOrigin>(fieldAnnotations)).transform(AnnotationTypeOrigin::annotationType).toList());
            Preconditions.checkState((FluentIterable.from(methodOrFieldAnnotations).toSet().size() == methodOrFieldAnnotations.size() ? 1 : 0) != 0, (Object)"Annotations should not be duplicated on a method and field if they are present on multiple fields");
        }
    }

    private void checkDuplicatedClassAndFieldAnnotations(List<AnnotationTypeOrigin> constructorAnnotations, List<AnnotationTypeOrigin> classAnnotations, List<AnnotationTypeOrigin> fieldAnnotations) {
        ImmutableSet classAnnotationTypes = FluentIterable.from(classAnnotations).transform(AnnotationTypeOrigin::annotationType).toSet();
        ImmutableSet uniqueFieldAnnotations = FluentIterable.from(fieldAnnotations).transform(AnnotationTypeOrigin::annotationType).toSet();
        ImmutableSet uniqueConstructorAnnotations = FluentIterable.from(constructorAnnotations).transform(AnnotationTypeOrigin::annotationType).toSet();
        Preconditions.checkState((boolean)Collections.disjoint(classAnnotationTypes, uniqueFieldAnnotations), (Object)"Annotations should not be duplicated on a class and field");
        Preconditions.checkState((boolean)Collections.disjoint(classAnnotationTypes, uniqueConstructorAnnotations), (Object)"Annotations should not be duplicated on a class and constructor");
        Preconditions.checkState((boolean)Collections.disjoint(uniqueConstructorAnnotations, uniqueFieldAnnotations), (Object)"Annotations should not be duplicated on a field and constructor");
    }

    private List<AnnotationTypeOrigin> extractTestParameterAnnotations(List<Annotation> annotations, Origin origin) {
        return new ArrayList<AnnotationTypeOrigin>((Collection<AnnotationTypeOrigin>)FluentIterable.from(annotations).transform(Annotation::annotationType).filter(annotationType -> annotationType.isAnnotationPresent(TestParameterAnnotation.class)).transform(annotationType -> AnnotationTypeOrigin.create(annotationType, origin)).toList());
    }

    @Override
    public ExecutableValidationResult validateConstructor(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length == 0) {
            return ExecutableValidationResult.notValidated();
        }
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Class<?> testClass = constructor.getDeclaringClass();
        return ExecutableValidationResult.validated(this.validateMethodOrConstructorParameters(this.removeOverrides((List<AnnotationTypeOrigin>)this.getAnnotationTypeOrigins(testClass, Origin.CLASS, Origin.CONSTRUCTOR, Origin.CONSTRUCTOR_PARAMETER), testClass), testClass, constructor, parameterTypes, parameterAnnotations));
    }

    @Override
    public ExecutableValidationResult validateTestMethod(Method testMethod, Class<?> testClass) {
        Class<?>[] methodParameterTypes = testMethod.getParameterTypes();
        if (methodParameterTypes.length == 0) {
            return ExecutableValidationResult.notValidated();
        }
        return ExecutableValidationResult.validated(this.validateMethodOrConstructorParameters((List<AnnotationTypeOrigin>)this.getAnnotationTypeOrigins(testClass, Origin.CLASS, Origin.METHOD, Origin.METHOD_PARAMETER), testClass, testMethod, methodParameterTypes, testMethod.getParameterAnnotations()));
    }

    private List<Throwable> validateMethodOrConstructorParameters(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, AnnotatedElement methodOrConstructor, Class<?>[] parameterTypes, Annotation[][] parametersAnnotations) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
            Class<?> parameterType = parameterTypes[parameterIndex];
            Annotation[] parameterAnnotations = parametersAnnotations[parameterIndex];
            boolean matchingTestParameterAnnotationFound = false;
            for (AnnotationTypeOrigin testParameterAnnotationType : annotationTypeOrigins) {
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    if (!parameterAnnotation.annotationType().equals(testParameterAnnotationType.annotationType())) continue;
                    Class<?> valueMethodReturnType = TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterAnnotationType.annotationType(), Optional.of(parameterType));
                    if (!parameterType.isAssignableFrom(valueMethodReturnType)) {
                        errors.add(new IllegalStateException(String.format("Parameter of type %s annotated with %s does not match expected type %s in method/constructor %s", parameterType.getName(), testParameterAnnotationType.annotationType().getName(), valueMethodReturnType.getName(), methodOrConstructor)));
                        continue;
                    }
                    matchingTestParameterAnnotationFound = true;
                }
            }
            if (!matchingTestParameterAnnotationFound) {
                ImmutableList<? extends Class<? extends Annotation>> testParameterAnnotationTypes = this.getTestParameterAnnotations((List<AnnotationTypeOrigin>)TestParameterAnnotationMethodProcessor.filterAnnotationTypeOriginsByOrigin(annotationTypeOrigins, Origin.CLASS, Origin.CONSTRUCTOR, Origin.METHOD), testClass, methodOrConstructor);
                for (Class testParameterAnnotationType : testParameterAnnotationTypes) {
                    if (!parameterType.isAssignableFrom(TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterAnnotationType, Optional.absent()))) continue;
                    if (matchingTestParameterAnnotationFound) {
                        errors.add(new IllegalStateException(String.format("Ambiguous method/constructor parameter type, matching multiple annotations for parameter of type %s in method %s", parameterType.getName(), methodOrConstructor)));
                    }
                    matchingTestParameterAnnotationFound = true;
                }
            }
            if (matchingTestParameterAnnotationFound) continue;
            errors.add(new IllegalStateException(String.format("No matching test parameter annotation found for parameter of type %s in method/constructor %s", parameterType.getName(), methodOrConstructor)));
        }
        return errors;
    }

    @Override
    public Optional<List<Object>> maybeGetConstructorParameters(Constructor<?> constructor, TestInfo testInfo) {
        if (testInfo.getAnnotation(TestIndexHolder.class) == null || constructor.isAnnotationPresent(TestParameters.class)) {
            return Optional.absent();
        }
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        List<TestParameterValue> testParameterValues = this.getParameterValuesForTest(testIndexHolder, testInfo.getTestClass());
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        ArrayList<Object> parameterValues = new ArrayList<Object>(parameterTypes.length);
        ArrayList<Class<? extends Annotation>> processedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
        ImmutableList<TestParameterValue> parameterValuesForConstructor = TestParameterAnnotationMethodProcessor.filterByOrigin(testParameterValues, Origin.CLASS, Origin.CONSTRUCTOR, Origin.CONSTRUCTOR_PARAMETER);
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterValues.add(this.getParameterValue((List<TestParameterValue>)parameterValuesForConstructor, parameterTypes[i], parameterAnnotations[i], (List<Class<? extends Annotation>>)processedAnnotationTypes));
        }
        return Optional.of(parameterValues);
    }

    @Override
    public Optional<List<Object>> maybeGetTestMethodParameters(TestInfo testInfo) {
        Method testMethod = testInfo.getMethod();
        if (testInfo.getAnnotation(TestIndexHolder.class) == null || testMethod.isAnnotationPresent(TestParameters.class)) {
            return Optional.absent();
        }
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        Preconditions.checkState((testIndexHolder != null ? 1 : 0) != 0);
        ImmutableList<TestParameterValue> testParameterValues = TestParameterAnnotationMethodProcessor.filterByOrigin(this.getParameterValuesForTest(testIndexHolder, testInfo.getTestClass()), Origin.CLASS, Origin.METHOD, Origin.METHOD_PARAMETER);
        Class<?>[] parameterTypes = testMethod.getParameterTypes();
        Annotation[][] parametersAnnotations = testMethod.getParameterAnnotations();
        ArrayList<Object> parameterValues = new ArrayList<Object>(parameterTypes.length);
        ArrayList<Class<? extends Annotation>> processedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterValues.add(this.getParameterValue((List<TestParameterValue>)testParameterValues, parameterTypes[i], parametersAnnotations[i], (List<Class<? extends Annotation>>)processedAnnotationTypes));
        }
        return Optional.of(parameterValues);
    }

    @Override
    public List<TestInfo> calculateTestInfos(TestInfo originalTest) {
        List<List<TestParameterValue>> parameterValuesForMethod = this.getParameterValuesForMethod(originalTest.getMethod(), originalTest.getTestClass());
        if (parameterValuesForMethod.equals(ImmutableList.of((Object)ImmutableList.of()))) {
            return ImmutableList.of((Object)originalTest);
        }
        ImmutableList.Builder testInfos = ImmutableList.builder();
        for (int parametersIndex = 0; parametersIndex < parameterValuesForMethod.size(); ++parametersIndex) {
            List<TestParameterValue> testParameterValues = parameterValuesForMethod.get(parametersIndex);
            testInfos.add((Object)originalTest.withExtraParameters((List<TestInfo.TestInfoParameter>)FluentIterable.from(testParameterValues).transform(param -> TestInfo.TestInfoParameter.create(param.toTestNameString(), param.value(), param.valueIndex())).toList()).withExtraAnnotation(TestIndexHolderFactory.create(this.strictIndexOf((List)this.getMethodsIncludingParents(originalTest.getTestClass()), (Object)originalTest.getMethod()), parametersIndex, originalTest.getTestClass().getName())));
        }
        return testInfos.build();
    }

    private List<List<TestParameterValue>> getParameterValuesForMethod(Method method, Class<?> testClass) {
        try {
            return (List)this.parameterValuesCache.get((Object)method, () -> {
                ImmutableList<List<TestParameterValue>> testParameterValuesList = this.getAnnotationValuesForUsedAnnotationTypes(method, testClass);
                return FluentIterable.from((Iterable)Lists.cartesianProduct(testParameterValuesList)).filter(testParameterValues -> FluentIterable.from((Iterable)testParameterValues).filter(testParameterValue -> TestParameterAnnotationMethodProcessor.callShouldSkip(testParameterValue.annotationTypeOrigin().annotationType(), testParameterValues)).isEmpty()).toList();
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
    }

    private List<TestParameterValue> getParameterValuesForTest(TestIndexHolder testIndexHolder, Class<?> testClass) {
        Verify.verify((boolean)testIndexHolder.testClassName().equals(testClass.getName()), (String)"The class for which the given annotation was created (%s) is not the same as the test class that this runner is handling (%s)", (Object)testIndexHolder.testClassName(), (Object)testClass.getName());
        Method testMethod = (Method)this.getMethodsIncludingParents(testClass).get(testIndexHolder.methodIndex());
        return this.getParameterValuesForMethod(testMethod, testClass).get(testIndexHolder.parametersIndex());
    }

    private ImmutableList<List<TestParameterValue>> getAnnotationValuesForUsedAnnotationTypes(Method method, Class<?> testClass) {
        ImmutableList annotationTypes = FluentIterable.from(this.getAnnotationTypeOrigins(testClass, Origin.CLASS, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.FIELD, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.CONSTRUCTOR, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.CONSTRUCTOR_PARAMETER, new Origin[0])).append(this.getAnnotationTypeOrigins(testClass, Origin.METHOD, new Origin[0])).append((Iterable)ImmutableList.sortedCopyOf(this.annotationComparator(method.getParameterAnnotations()), this.getAnnotationTypeOrigins(testClass, Origin.METHOD_PARAMETER, new Origin[0]))).toList();
        return FluentIterable.from(this.removeOverrides((List<AnnotationTypeOrigin>)annotationTypes, testClass, method)).transform(annotationTypeOrigin -> this.getAnnotationFromParametersOrTestOrClass((AnnotationTypeOrigin)annotationTypeOrigin, method, testClass)).filter(l -> !l.isEmpty()).transformAndConcat(i -> i).toList();
    }

    private Comparator<AnnotationTypeOrigin> annotationComparator(Annotation[][] parameterAnnotations) {
        ImmutableList annotationOrdering = FluentIterable.from((Object[])parameterAnnotations).transformAndConcat(Arrays::asList).transform(Annotation::annotationType).transform(Class::getName).toList();
        return (annotationTypeOrigin, t1) -> Integer.compare(annotationOrdering.indexOf((Object)annotationTypeOrigin.annotationType().getName()), annotationOrdering.indexOf((Object)t1.annotationType().getName()));
    }

    private List<AnnotationTypeOrigin> removeOverrides(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, Method method) {
        return this.removeOverrides(new ArrayList<AnnotationTypeOrigin>((Collection<AnnotationTypeOrigin>)FluentIterable.from(annotationTypeOrigins).filter(annotationTypeOrigin -> {
            switch (annotationTypeOrigin.origin()) {
                case FIELD: 
                case CLASS: {
                    return this.getAnnotationListWithType(method.getAnnotations(), annotationTypeOrigin.annotationType()).isEmpty();
                }
            }
            return true;
        }).toList()), testClass);
    }

    private List<AnnotationTypeOrigin> removeOverrides(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass) {
        return new ArrayList<AnnotationTypeOrigin>((Collection<AnnotationTypeOrigin>)FluentIterable.from(annotationTypeOrigins).filter(annotationTypeOrigin -> {
            switch (annotationTypeOrigin.origin()) {
                case FIELD: 
                case CLASS: {
                    return this.getAnnotationListWithType(TestParameterAnnotationMethodProcessor.getOnlyConstructor(testClass).getAnnotations(), annotationTypeOrigin.annotationType()).isEmpty();
                }
            }
            return true;
        }).toList());
    }

    private ImmutableList<List<TestParameterValue>> getAnnotationFromParametersOrTestOrClass(AnnotationTypeOrigin annotationTypeOrigin, Method method, Class<?> testClass) {
        Annotation annotation;
        Origin origin = annotationTypeOrigin.origin();
        Class<? extends Annotation> annotationType = annotationTypeOrigin.annotationType();
        if (origin == Origin.CONSTRUCTOR_PARAMETER) {
            Constructor<?> constructor = TestParameterAnnotationMethodProcessor.getOnlyConstructor(testClass);
            ImmutableList<AnnotationWithMetadata> annotations = TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(constructor, annotationType);
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.CONSTRUCTOR) {
            Annotation annotation2 = TestParameterAnnotationMethodProcessor.getOnlyConstructor(testClass).getAnnotation(annotationType);
            if (annotation2 != null) {
                return ImmutableList.of(TestParameterValue.create(AnnotationWithMetadata.withoutMetadata(annotation2), origin));
            }
        } else if (origin == Origin.METHOD_PARAMETER) {
            ImmutableList<AnnotationWithMetadata> annotations = TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(method, annotationType);
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.METHOD) {
            if (method.isAnnotationPresent(annotationType)) {
                return ImmutableList.of(TestParameterValue.create(AnnotationWithMetadata.withoutMetadata(method.getAnnotation(annotationType)), origin));
            }
        } else if (origin == Origin.FIELD) {
            ArrayList<AnnotationWithMetadata> annotations = new ArrayList<AnnotationWithMetadata>((Collection<AnnotationWithMetadata>)FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testClass)).transformAndConcat(c -> Arrays.asList(c.getDeclaredFields())).transformAndConcat(field -> FluentIterable.from(this.getAnnotationListWithType(field.getAnnotations(), annotationType)).transform(annotation -> AnnotationWithMetadata.withMetadata(annotation, field.getType(), field.getName()))).toList());
            if (!annotations.isEmpty()) {
                return TestParameterAnnotationMethodProcessor.toTestParameterValueList(annotations, origin);
            }
        } else if (origin == Origin.CLASS && (annotation = testClass.getAnnotation(annotationType)) != null) {
            return ImmutableList.of(TestParameterValue.create(AnnotationWithMetadata.withoutMetadata(annotation), origin));
        }
        return ImmutableList.of();
    }

    private static ImmutableList<List<TestParameterValue>> toTestParameterValueList(List<AnnotationWithMetadata> annotationWithMetadatas, Origin origin) {
        return FluentIterable.from(annotationWithMetadatas).transform(annotationWithMetadata -> new ArrayList<TestParameterValue>((Collection<TestParameterValue>)TestParameterValue.create(annotationWithMetadata, origin))).toList();
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Method callable, Class<? extends Annotation> annotationType) {
        try {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameters(), annotationType);
        }
        catch (NoSuchMethodError ignored) {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameterTypes(), callable.getParameterAnnotations(), annotationType);
        }
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Constructor<?> callable, Class<? extends Annotation> annotationType) {
        try {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameters(), annotationType);
        }
        catch (NoSuchMethodError ignored) {
            return TestParameterAnnotationMethodProcessor.getAnnotationWithMetadataListWithType(callable.getParameterTypes(), callable.getParameterAnnotations(), annotationType);
        }
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Parameter[] parameters, Class<? extends Annotation> annotationType) {
        return FluentIterable.from((Object[])parameters).transform(parameter -> {
            Object annotation = parameter.getAnnotation(annotationType);
            return annotation == null ? null : (parameter.isNamePresent() ? AnnotationWithMetadata.withMetadata(annotation, parameter.getType(), parameter.getName()) : AnnotationWithMetadata.withMetadata(annotation, parameter.getType()));
        }).filter(Objects::nonNull).toList();
    }

    private static ImmutableList<AnnotationWithMetadata> getAnnotationWithMetadataListWithType(Class<?>[] parameterTypes, Annotation[][] annotations, Class<? extends Annotation> annotationType) {
        Preconditions.checkArgument((parameterTypes.length == annotations.length ? 1 : 0) != 0);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                resultBuilder.add((Object)AnnotationWithMetadata.withMetadata(annotation, parameterTypes[i]));
            }
        }
        return resultBuilder.build();
    }

    private ImmutableList<Annotation> getAnnotationListWithType(Annotation[] annotations, Class<? extends Annotation> annotationType) {
        return FluentIterable.from((Object[])annotations).filter(annotation -> annotation.annotationType().equals(annotationType)).toList();
    }

    private static Constructor<?> getOnlyConstructor(Class<?> testClass) {
        Constructor<?>[] constructors = testClass.getDeclaredConstructors();
        Preconditions.checkState((constructors.length == 1 ? 1 : 0) != 0, (String)"a single public constructor is required for class %s", testClass);
        return constructors[0];
    }

    @Override
    public void postProcessTestInstance(Object testInstance, TestInfo testInfo) {
        TestIndexHolder testIndexHolder = testInfo.getAnnotation(TestIndexHolder.class);
        try {
            if (testIndexHolder != null) {
                List<TestParameterValue> testParameterValues = this.getParameterValuesForTest(testIndexHolder, testInfo.getTestClass());
                ImmutableList<TestParameterValue> testParameterValuesForFieldInjection = TestParameterAnnotationMethodProcessor.filterByOrigin(testParameterValues, Origin.CLASS, Origin.FIELD, Origin.METHOD);
                ArrayList<TestParameterValue> remainingTestParameterValuesForFieldInjection = new ArrayList<TestParameterValue>((Collection<TestParameterValue>)testParameterValuesForFieldInjection);
                block2: for (Field declaredField : FluentIterable.from(TestParameterAnnotationMethodProcessor.listWithParents(testInstance.getClass())).transformAndConcat(c -> Arrays.asList(c.getDeclaredFields())).toList()) {
                    for (TestParameterValue testParameterValue : remainingTestParameterValuesForFieldInjection) {
                        if (!declaredField.isAnnotationPresent(testParameterValue.annotationTypeOrigin().annotationType())) continue;
                        declaredField.setAccessible(true);
                        declaredField.set(testInstance, testParameterValue.value());
                        remainingTestParameterValuesForFieldInjection.remove(testParameterValue);
                        continue block2;
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableList<TestParameterValue> filterByOrigin(List<TestParameterValue> testParameterValues, Origin ... origins) {
        ImmutableSet originsToFilterBy = ImmutableSet.copyOf((Object[])origins);
        return FluentIterable.from(testParameterValues).filter(arg_0 -> TestParameterAnnotationMethodProcessor.lambda$filterByOrigin$30((Set)originsToFilterBy, arg_0)).toList();
    }

    private static ImmutableList<AnnotationTypeOrigin> filterAnnotationTypeOriginsByOrigin(List<AnnotationTypeOrigin> annotationTypeOrigins, Origin ... origins) {
        List<Origin> originList = Arrays.asList(origins);
        return FluentIterable.from(annotationTypeOrigins).filter(annotationTypeOrigin -> originList.contains((Object)annotationTypeOrigin.origin())).toList();
    }

    private Object getParameterValue(List<TestParameterValue> testParameterValues, Class<?> methodParameterType, Annotation[] parameterAnnotations, List<Class<? extends Annotation>> processedAnnotationTypes) {
        ArrayList<Class<? extends Annotation>> iteratedAnnotationTypes = new ArrayList<Class<? extends Annotation>>();
        for (TestParameterValue testParameterValue : testParameterValues) {
            for (Annotation parameterAnnotation : parameterAnnotations) {
                Class<? extends Annotation> annotationType = testParameterValue.annotationTypeOrigin().annotationType();
                if (!parameterAnnotation.annotationType().equals(annotationType)) continue;
                if (Collections.frequency(processedAnnotationTypes, annotationType) == Collections.frequency(iteratedAnnotationTypes, annotationType)) {
                    processedAnnotationTypes.add(annotationType);
                    return testParameterValue.value();
                }
                iteratedAnnotationTypes.add(annotationType);
            }
        }
        for (TestParameterValue testParameterValue : testParameterValues) {
            if (!methodParameterType.isAssignableFrom(TestParameterAnnotationMethodProcessor.getValueMethodReturnType(testParameterValue.annotationTypeOrigin().annotationType(), Optional.absent()))) continue;
            return testParameterValue.value();
        }
        throw new IllegalStateException("The method parameter should have matched a TestParameterAnnotation");
    }

    private static boolean callShouldSkip(Class<? extends Annotation> annotationType, List<TestParameterValue> testParameterValues) {
        TestParameterAnnotation annotation = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValidator> validator = annotation.validator();
        try {
            return validator.getConstructor(new Class[0]).newInstance(new Object[0]).shouldSkip(new ValidatorContext(testParameterValues));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking validator " + validator, e);
        }
    }

    private static Class<?> getValueMethodReturnType(Class<? extends Annotation> annotationType, Optional<Class<?>> paramClass) {
        TestParameterAnnotation testParameter = annotationType.getAnnotation(TestParameterAnnotation.class);
        Class<? extends TestParameterValueProvider> valueProvider = testParameter.valueProvider();
        try {
            return valueProvider.getConstructor(new Class[0]).newInstance(new Object[0]).getValueType(annotationType, paramClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking value provider " + valueProvider, e);
        }
    }

    private ImmutableList<? extends Class<? extends Annotation>> getTestParameterAnnotations(List<AnnotationTypeOrigin> annotationTypeOrigins, Class<?> testClass, AnnotatedElement methodOrConstructor) {
        return FluentIterable.from(annotationTypeOrigins).transform(AnnotationTypeOrigin::annotationType).filter(annotationType -> testClass.isAnnotationPresent((Class<Annotation>)annotationType) || methodOrConstructor.isAnnotationPresent((Class<? extends Annotation>)annotationType)).toList();
    }

    private <T> int strictIndexOf(List<T> haystack, T needle) {
        int index = haystack.indexOf(needle);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"Could not find '%s' in %s", needle, haystack);
        return index;
    }

    private ImmutableList<Method> getMethodsIncludingParents(Class<?> clazz) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        while (clazz != null) {
            resultBuilder.add((Object[])clazz.getDeclaredMethods());
            clazz = clazz.getSuperclass();
        }
        return resultBuilder.build();
    }

    private static ImmutableList<Class<?>> listWithParents(Class<?> clazz) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            resultBuilder.add(currentClass);
        }
        return resultBuilder.build();
    }

    private static /* synthetic */ boolean lambda$filterByOrigin$30(Set originsToFilterBy, TestParameterValue testParameterValue) {
        return originsToFilterBy.contains((Object)testParameterValue.annotationTypeOrigin().origin());
    }

    private static /* synthetic */ boolean lambda$getAnnotationTypeOrigins$10(Set originsToFilterBy, AnnotationTypeOrigin annotationTypeOrigin) {
        return originsToFilterBy.contains((Object)annotationTypeOrigin.origin());
    }

    @AutoValue
    static abstract class AnnotationWithMetadata
    implements Serializable {
        AnnotationWithMetadata() {
        }

        abstract Annotation annotation();

        abstract Optional<Class<?>> paramClass();

        abstract Optional<String> paramName();

        public static AnnotationWithMetadata withMetadata(Annotation annotation, Class<?> paramClass, String paramName) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, Optional.of(paramClass), (Optional<String>)Optional.of((Object)paramName));
        }

        public static AnnotationWithMetadata withMetadata(Annotation annotation, Class<?> paramClass) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, Optional.of(paramClass), (Optional<String>)Optional.absent());
        }

        public static AnnotationWithMetadata withoutMetadata(Annotation annotation) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationWithMetadata(annotation, Optional.absent(), (Optional<String>)Optional.absent());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestIndexHolder {
        public int methodIndex();

        public int parametersIndex();

        public String testClassName();
    }

    static enum Origin {
        CLASS,
        FIELD,
        METHOD,
        METHOD_PARAMETER,
        CONSTRUCTOR,
        CONSTRUCTOR_PARAMETER;

    }

    @AutoValue
    static abstract class AnnotationTypeOrigin
    implements Serializable {
        private static final long serialVersionUID = 4909750539931241385L;

        AnnotationTypeOrigin() {
        }

        abstract Class<? extends Annotation> annotationType();

        abstract Origin origin();

        public static AnnotationTypeOrigin create(Class<? extends Annotation> annotationType, Origin origin) {
            return new AutoValue_TestParameterAnnotationMethodProcessor_AnnotationTypeOrigin(annotationType, origin);
        }

        public final String toString() {
            return this.annotationType().getSimpleName() + ":" + (Object)((Object)this.origin());
        }
    }

    static class TestIndexHolderFactory {
        static TestIndexHolder create(int methodIndex, int parametersIndex, String testClassName) {
            return new AutoAnnotation_TestParameterAnnotationMethodProcessor_TestIndexHolderFactory_create(methodIndex, parametersIndex, testClassName);
        }

        private TestIndexHolderFactory() {
        }
    }

    @AutoValue
    static abstract class TestParameterValue
    implements Serializable {
        private static final long serialVersionUID = -6491624726743872379L;

        TestParameterValue() {
        }

        abstract AnnotationTypeOrigin annotationTypeOrigin();

        @Nullable
        abstract Object value();

        abstract int valueIndex();

        abstract List<Object> specifiedValues();

        abstract Optional<Class<?>> paramClass();

        abstract Optional<String> paramName();

        String toTestNameString() {
            Class<? extends Annotation> annotationType = this.annotationTypeOrigin().annotationType();
            String namePattern = annotationType.getAnnotation(TestParameterAnnotation.class).name();
            if (this.paramName().isPresent() && this.paramClass().isPresent() && namePattern.equals("{0}") && Primitives.unwrap((Class)((Class)this.paramClass().get())).isPrimitive()) {
                return String.format("%s=%s", this.paramName().get(), this.valueAsString()).trim().replaceAll("\\s+", " ");
            }
            return MessageFormat.format(namePattern, this.valueAsString()).trim().replaceAll("\\s+", " ");
        }

        private String valueAsString() {
            if (this.value() != null && this.value().getClass().isArray()) {
                StringBuilder resultBuider = new StringBuilder();
                resultBuider.append("[");
                for (int i = 0; i < Array.getLength(this.value()); ++i) {
                    if (i > 0) {
                        resultBuider.append(", ");
                    }
                    resultBuider.append(Array.get(this.value(), i));
                }
                resultBuider.append("]");
                return resultBuider.toString();
            }
            if (ByteStringReflection.isInstanceOfByteString(this.value())) {
                return Arrays.toString(ByteStringReflection.byteStringToByteArray(this.value()));
            }
            return String.valueOf(this.value());
        }

        public static ImmutableList<TestParameterValue> create(AnnotationWithMetadata annotationWithMetadata, Origin origin) {
            List specifiedValues = TestParameterAnnotationMethodProcessor.getParametersAnnotationValues(annotationWithMetadata);
            Preconditions.checkState((!specifiedValues.isEmpty() ? 1 : 0) != 0, (Object)"The number of parameter values should not be 0, otherwise the parameter would cause the test to be skipped.");
            return FluentIterable.from((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(specifiedValues.size())), (DiscreteDomain)DiscreteDomain.integers())).transform(valueIndex -> new AutoValue_TestParameterAnnotationMethodProcessor_TestParameterValue(AnnotationTypeOrigin.create(annotationWithMetadata.annotation().annotationType(), origin), specifiedValues.get((int)valueIndex), (int)valueIndex, (List<Object>)new ArrayList<Object>(specifiedValues), annotationWithMetadata.paramClass(), annotationWithMetadata.paramName())).toList();
        }
    }

    private static class ValidatorContext
    implements TestParameterValidator.Context {
        private final List<TestParameterValue> testParameterValues;
        private final Set<Object> valueList;

        public ValidatorContext(List<TestParameterValue> testParameterValues) {
            this.testParameterValues = testParameterValues;
            this.valueList = FluentIterable.from(testParameterValues).transform(TestParameterValue::value).filter(Objects::nonNull).toSet();
        }

        @Override
        public boolean has(Class<? extends Annotation> testParameter, Object value) {
            return (Boolean)this.getValue(testParameter).transform(value::equals).or((Object)false);
        }

        @Override
        public <T extends Enum<T>, U extends Enum<U>> boolean has(T value1, U value2) {
            return this.valueList.contains(value1) && this.valueList.contains(value2);
        }

        @Override
        public Optional<Object> getValue(Class<? extends Annotation> testParameter) {
            return this.getParameter(testParameter).transform(TestParameterValue::value);
        }

        @Override
        public List<Object> getSpecifiedValues(Class<? extends Annotation> testParameter) {
            return (List)this.getParameter(testParameter).transform(TestParameterValue::specifiedValues).or((Object)ImmutableList.of());
        }

        private Optional<TestParameterValue> getParameter(Class<? extends Annotation> testParameter) {
            return FluentIterable.from(this.testParameterValues).firstMatch(value -> value.annotationTypeOrigin().annotationType().equals(testParameter));
        }
    }
}

